/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate.encryptor;

import java.util.HashMap;
import org.jasypt.encryption.pbe.PBEBigDecimalEncryptor;
import org.jasypt.encryption.pbe.PBEBigIntegerEncryptor;
import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.hibernate.encryptor.HibernatePBEBigDecimalEncryptor;
import org.jasypt.hibernate.encryptor.HibernatePBEBigIntegerEncryptor;
import org.jasypt.hibernate.encryptor.HibernatePBEByteEncryptor;
import org.jasypt.hibernate.encryptor.HibernatePBEStringEncryptor;

public final class HibernatePBEEncryptorRegistry {
    private static final HibernatePBEEncryptorRegistry instance = new HibernatePBEEncryptorRegistry();
    private final HashMap stringEncryptors = new HashMap();
    private final HashMap bigIntegerEncryptors = new HashMap();
    private final HashMap bigDecimalEncryptors = new HashMap();
    private final HashMap byteEncryptors = new HashMap();

    public static HibernatePBEEncryptorRegistry getInstance() {
        return instance;
    }

    private HibernatePBEEncryptorRegistry() {
    }

    public synchronized void registerPBEStringEncryptor(String registeredName, PBEStringEncryptor encryptor) {
        HibernatePBEStringEncryptor hibernateEncryptor = new HibernatePBEStringEncryptor(registeredName, encryptor);
        this.stringEncryptors.put(registeredName, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEStringEncryptor(HibernatePBEStringEncryptor hibernateEncryptor) {
        this.stringEncryptors.put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEStringEncryptor(String name) {
        this.stringEncryptors.remove(name);
    }

    public synchronized PBEStringEncryptor getPBEStringEncryptor(String registeredName) {
        HibernatePBEStringEncryptor hibernateEncryptor = (HibernatePBEStringEncryptor)this.stringEncryptors.get(registeredName);
        if (hibernateEncryptor == null) {
            return null;
        }
        return hibernateEncryptor.getEncryptor();
    }

    public synchronized void registerPBEBigIntegerEncryptor(String registeredName, PBEBigIntegerEncryptor encryptor) {
        HibernatePBEBigIntegerEncryptor hibernateEncryptor = new HibernatePBEBigIntegerEncryptor(registeredName, encryptor);
        this.bigIntegerEncryptors.put(registeredName, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEBigIntegerEncryptor(HibernatePBEBigIntegerEncryptor hibernateEncryptor) {
        this.bigIntegerEncryptors.put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEBigIntegerEncryptor(String name) {
        this.bigIntegerEncryptors.remove(name);
    }

    public synchronized PBEBigIntegerEncryptor getPBEBigIntegerEncryptor(String registeredName) {
        HibernatePBEBigIntegerEncryptor hibernateEncryptor = (HibernatePBEBigIntegerEncryptor)this.bigIntegerEncryptors.get(registeredName);
        if (hibernateEncryptor == null) {
            return null;
        }
        return hibernateEncryptor.getEncryptor();
    }

    public synchronized void registerPBEBigDecimalEncryptor(String registeredName, PBEBigDecimalEncryptor encryptor) {
        HibernatePBEBigDecimalEncryptor hibernateEncryptor = new HibernatePBEBigDecimalEncryptor(registeredName, encryptor);
        this.bigDecimalEncryptors.put(registeredName, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEBigDecimalEncryptor(HibernatePBEBigDecimalEncryptor hibernateEncryptor) {
        this.bigDecimalEncryptors.put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEBigDecimalEncryptor(String name) {
        this.bigDecimalEncryptors.remove(name);
    }

    public synchronized PBEBigDecimalEncryptor getPBEBigDecimalEncryptor(String registeredName) {
        HibernatePBEBigDecimalEncryptor hibernateEncryptor = (HibernatePBEBigDecimalEncryptor)this.bigDecimalEncryptors.get(registeredName);
        if (hibernateEncryptor == null) {
            return null;
        }
        return hibernateEncryptor.getEncryptor();
    }

    public synchronized void registerPBEByteEncryptor(String registeredName, PBEByteEncryptor encryptor) {
        HibernatePBEByteEncryptor hibernateEncryptor = new HibernatePBEByteEncryptor(registeredName, encryptor);
        this.byteEncryptors.put(registeredName, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEByteEncryptor(HibernatePBEByteEncryptor hibernateEncryptor) {
        this.byteEncryptors.put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEByteEncryptor(String name) {
        this.byteEncryptors.remove(name);
    }

    public synchronized PBEByteEncryptor getPBEByteEncryptor(String registeredName) {
        HibernatePBEByteEncryptor hibernateEncryptor = (HibernatePBEByteEncryptor)this.byteEncryptors.get(registeredName);
        if (hibernateEncryptor == null) {
            return null;
        }
        return hibernateEncryptor.getEncryptor();
    }
}

