/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.events;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.events.AlertConditionEvaluatorStateRepository;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Repository;

@Repository
public class FileAlertConditionEvaluatorStateRepository
implements AlertConditionEvaluatorStateRepository,
ApplicationContextAware {
    private File storageDirectory;
    public static final String EVALUATOR_STATE_FILE_NAME = "AlertConditionEvaluatorStates.dat";
    public static final String EXECUTION_STRATEGY_FILE_NAME = "ExecutionStrategyStates.dat";
    private final Log log = LogFactory.getLog(FileAlertConditionEvaluatorStateRepository.class);

    public FileAlertConditionEvaluatorStateRepository(File storageDirectory) {
        this.storageDirectory = storageDirectory;
    }

    public FileAlertConditionEvaluatorStateRepository() {
    }

    private void closeStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Error closing input stream", (Throwable)e);
        }
    }

    private void closeStream(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Error closing output stream", (Throwable)e);
        }
    }

    @Override
    public Map<Integer, Serializable> getAlertConditionEvaluatorStates() {
        return this.getStates(new File(this.storageDirectory, EVALUATOR_STATE_FILE_NAME));
    }

    @Override
    public Map<Integer, Serializable> getExecutionStrategyStates() {
        return this.getStates(new File(this.storageDirectory, EXECUTION_STRATEGY_FILE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Serializable> getStates(File in) {
        block7: {
            if (in.exists() && in.canRead()) {
                Map map;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Loading alert condition evaluator states from [" + in.getAbsolutePath() + "]"));
                }
                FileInputStream fileInputStream = null;
                ObjectInputStream objectInputStream = null;
                try {
                    Map states;
                    fileInputStream = new FileInputStream(in);
                    objectInputStream = new ObjectInputStream(new BufferedInputStream(fileInputStream));
                    map = states = (Map)objectInputStream.readObject();
                    in.delete();
                }
                catch (Exception e) {
                    try {
                        this.log.warn((Object)("Error while reading alert condition evaluator states from [" + in.getAbsolutePath() + "]"), (Throwable)e);
                        in.delete();
                    }
                    catch (Throwable throwable) {
                        in.delete();
                        this.closeStream(objectInputStream);
                        this.closeStream(fileInputStream);
                        throw throwable;
                    }
                    this.closeStream(objectInputStream);
                    this.closeStream(fileInputStream);
                    break block7;
                }
                this.closeStream(objectInputStream);
                this.closeStream(fileInputStream);
                return map;
            }
            if (in.exists()) {
                this.log.warn((Object)("Alert condition evaluator states found in [" + in.getAbsolutePath() + "] but I don't have read access!"));
            }
        }
        return new HashMap<Integer, Serializable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistStates(Map<Integer, Serializable> states, File out) {
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (out.isFile()) {
                this.log.warn((Object)(out.getAbsolutePath() + " already exists.  It will be deleted."));
            }
            out.delete();
            fileOutputStream = new FileOutputStream(out);
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
            objectOutputStream.writeObject(states);
            objectOutputStream.flush();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Successfully saved alert condition evaluator states to " + out.getAbsolutePath()));
            }
            this.closeStream(objectOutputStream);
            this.closeStream(fileOutputStream);
        }
        catch (Exception e) {
            try {
                this.log.warn((Object)"Unable to save alert condition evaluator states", (Throwable)e);
                this.closeStream(objectOutputStream);
                this.closeStream(fileOutputStream);
            }
            catch (Throwable throwable) {
                this.closeStream(objectOutputStream);
                this.closeStream(fileOutputStream);
                throw throwable;
            }
        }
    }

    @Override
    public void saveAlertConditionEvaluatorStates(Map<Integer, Serializable> alertConditionEvaluatorStates) {
        this.persistStates(alertConditionEvaluatorStates, new File(this.storageDirectory, EVALUATOR_STATE_FILE_NAME));
    }

    @Override
    public void saveExecutionStrategyStates(Map<Integer, Serializable> executionStrategyStates) {
        this.persistStates(executionStrategyStates, new File(this.storageDirectory, EXECUTION_STRATEGY_FILE_NAME));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            this.storageDirectory = new File(new File(applicationContext.getResource("/").getFile().getParent()).getParent());
        }
        catch (IOException e) {
            throw new BeanCreationException("Error setting storage directory", (Throwable)e);
        }
    }
}

