/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.io.Serializable;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.appdef.shared.AIIpValue;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.LatherUtil;
import org.hyperic.hq.autoinventory.ScanMethodState;
import org.hyperic.util.StringUtil;
import org.hyperic.util.StringifiedException;

public class ScanStateCore
implements Serializable {
    private static final long serialVersionUID = -10594694796182781L;
    private AIPlatformValue _platform = null;
    private ScanMethodState[] _scanMethodStates;
    private boolean _isInterrupted = false;
    private boolean _isDone = false;
    private long _startTime = 0L;
    private long _endTime = 0L;
    private String _certDN;
    private boolean _areServersIncluded = true;
    private StringifiedException _globalException = null;

    public ScanMethodState[] getScanMethodStates() {
        return this._scanMethodStates;
    }

    public void setScanMethodStates(ScanMethodState[] scanMethodStates) {
        this._scanMethodStates = scanMethodStates;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public void setStartTime(long _startTime) {
        this._startTime = _startTime;
    }

    public long getEndTime() {
        return this._endTime;
    }

    public void setEndTime(long _endTime) {
        this._endTime = _endTime;
    }

    public StringifiedException getGlobalException() {
        return this._globalException;
    }

    public void setGlobalException(StringifiedException _globalException) {
        this._globalException = _globalException;
    }

    public boolean getAreServersIncluded() {
        return this._areServersIncluded;
    }

    public void setAreServersIncluded(boolean b) {
        this._areServersIncluded = b;
    }

    public boolean getIsDone() {
        return this._isDone;
    }

    public void setIsDone(boolean b) {
        this._isDone = b;
    }

    public boolean getIsInterrupted() {
        return this._isInterrupted;
    }

    public void setIsInterrupted(boolean b) {
        this._isInterrupted = b;
    }

    public AIPlatformValue getPlatform() {
        return this._platform;
    }

    public void setPlatform(AIPlatformValue platform) {
        if (this._platform != null) {
            AIIpValue[] ips = this.getIps();
            for (int i = 0; i < ips.length; ++i) {
                platform.addAIIpValue(ips[i]);
            }
        }
        this._platform = platform;
        this._platform.setCertdn(this._certDN);
    }

    public AIIpValue[] getIps() {
        return this._platform.getAIIpValues();
    }

    public void setIps(AIIpValue[] ips) {
        if (this._platform == null) {
            this._platform = new AIPlatformValue();
        } else {
            this._platform.removeAllAIIpValues();
        }
        if (ips == null) {
            return;
        }
        for (int i = 0; i < ips.length; ++i) {
            this._platform.addAIIpValue(ips[i]);
        }
    }

    public String getCertDN() {
        if (this._platform == null) {
            return null;
        }
        return this._platform.getCertdn();
    }

    public void setCertDN(String certDN) {
        this._certDN = certDN;
        if (this._platform != null) {
            this._platform.setCertdn(certDN);
        }
    }

    public void toAgentRemoteValue(String keyName, AgentRemoteValue arv) throws AutoinventoryException {
        arv.setValue(keyName, LatherUtil.encode(this));
    }

    public static ScanStateCore fromAgentRemoteValue(String keyName, AgentRemoteValue arv) throws AutoinventoryException {
        return LatherUtil.decodeScanStateCore(arv.getValue(keyName));
    }

    public String toString() {
        if (this._platform == null) {
            return "[ScanState]";
        }
        return "[ScanState platform=" + this._platform + " ips=" + StringUtil.arrayToString((Object[])this._platform.getAIIpValues()) + " serversIncluded=" + this._areServersIncluded + "]";
    }
}

