/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.HashMap;
import java.util.Map;
import org.hyperic.hq.appdef.shared.AIIpValue;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

public class PlatformResource
extends AIPlatformValue {
    public PlatformResource() {
        Long now = new Long(System.currentTimeMillis());
        this.setCTime(now);
        this.setMTime(now);
    }

    public void addInterface(String address, String netmask, String mac) {
        this.addInterface(address, netmask, mac, null, null);
    }

    public void addInterface(String address, String netmask, String mac, String address6, String address6Scope) {
        AIIpValue ip = new AIIpValue();
        ip.setAddress(address);
        if (netmask != null) {
            ip.setNetmask(netmask);
        }
        if (mac != null) {
            ip.setMACAddress(mac);
        }
        if (address6 != null) {
            ip.setAddress6(address6);
        }
        if (address6Scope != null) {
            ip.setAddress6Scope(address6Scope);
        }
        ip.setCTime(this.getCTime());
        ip.setMTime(this.getMTime());
        this.addAIIpValue(ip);
    }

    public void setCustomProperties(ConfigResponse config) {
        if (config == null) {
            return;
        }
        try {
            this.setCustomProperties(config.encode());
        }
        catch (EncodingException e) {
            throw new IllegalArgumentException("Error encoding config");
        }
    }

    public void setProductConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        try {
            this.setProductConfig(config.encode());
        }
        catch (EncodingException e) {
            throw new IllegalArgumentException("Error encoding config");
        }
    }

    public void setMeasurementConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        try {
            this.setMeasurementConfig(config.encode());
        }
        catch (EncodingException e) {
            throw new IllegalArgumentException("Error encoding config");
        }
    }

    public void setMeasurementConfig(ConfigResponse config, int logTrackLevel) {
        LogTrackPlugin.setEnabled(config, 1, logTrackLevel);
        this.setMeasurementConfig(config);
    }

    public void setControlConfig(ConfigResponse config) {
        if (config == null) {
            return;
        }
        try {
            this.setControlConfig(config.encode());
        }
        catch (EncodingException e) {
            throw new IllegalArgumentException("Error encoding config");
        }
    }

    public void setProductConfig(Map config) {
        this.setProductConfig(new ConfigResponse(config));
    }

    public void setMeasurementConfig(Map config) {
        this.setMeasurementConfig(new ConfigResponse(config));
    }

    public void setControlConfig(Map config) {
        this.setControlConfig(new ConfigResponse(config));
    }

    public void setControlConfig() {
        this.setControlConfig(new HashMap());
    }

    public void setCustomProperties(Map props) {
        this.setCustomProperties(new ConfigResponse(props));
    }
}

