/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.ResourceTag;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlEndAttrHandler;
import org.hyperic.util.xmlparser.XmlTextHandler;

class HelpTag
extends BaseTag
implements XmlTextHandler,
XmlEndAttrHandler {
    private static final String ATTR_APPEND = "append";
    private static final String[] OPTIONAL_ATTRS = new String[]{"name", "append", "include", "platform"};
    private String helpName;

    HelpTag(BaseTag parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    public void handleText(String text) {
        if (!this.collectHelp) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        this.includeHelp(this.getAttribute("include"), sb);
        sb.append(this.data.applyFilters(text));
        this.includeHelp(this.getAttribute(ATTR_APPEND), sb);
        String data = sb.toString();
        if (data.trim().length() == 0) {
            data = "";
        }
        this.data.help.put(this.helpName, data);
    }

    public void endAttributes() throws XmlAttrException {
        if (!this.collectHelp) {
            return;
        }
        String name = this.getAttribute("name");
        if (this.isResourceParent()) {
            if (name != null) {
                String msg = "help 'name' attribute not allowed when nested in a " + this.parent.getName() + " tag";
                throw new XmlAttrException(msg);
            }
            this.helpName = ((ResourceTag)this.parent).getPlatformName(this);
        } else {
            if (name == null) {
                throw new XmlAttrException("missing help 'name' attribute");
            }
            this.helpName = name;
        }
    }

    private void includeHelp(String include, StringBuffer sb) {
        String[] includes = this.getList(include);
        for (int i = 0; i < includes.length; ++i) {
            Object hep = this.data.help.get(includes[i]);
            if (hep == null) continue;
            sb.append(hep);
        }
    }
}

