/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.timer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StopWatch {
    private long _start;
    private long _end;
    private Map<String, LinkedList<TimeSlice>> _markerMap;

    public StopWatch() {
        this.reset();
    }

    public void markTimeBegin(String marker) {
        LinkedList<TimeSlice> list = this._markerMap.get(marker);
        if (null == list) {
            list = new LinkedList();
            this._markerMap.put(marker, list);
        }
        list.add(new TimeSlice(marker));
    }

    public void markTimeEnd(String marker) {
        LinkedList<TimeSlice> list = this._markerMap.get(marker);
        if (list == null) {
            throw new IllegalArgumentException("Invalid marker");
        }
        TimeSlice ts = list.getLast();
        ts.setFinished();
    }

    public StopWatch(long start) {
        this._start = start;
        this._markerMap = new HashMap<String, LinkedList<TimeSlice>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reset() {
        try {
            long l = this.getElapsed();
            return l;
        }
        finally {
            this._start = this.now();
            this._markerMap = new HashMap<String, LinkedList<TimeSlice>>();
        }
    }

    private final long now() {
        return System.currentTimeMillis();
    }

    public long getElapsed() {
        this._end = this.now();
        return this._end - this._start;
    }

    public String toString() {
        long elap = this.getElapsed();
        StringBuilder buf = new StringBuilder(64);
        buf.append(elap).append(" ms");
        if (this._markerMap.size() > 0) {
            buf.append(" { Markers: ");
            for (Map.Entry<String, LinkedList<TimeSlice>> entry : this._markerMap.entrySet()) {
                String marker = entry.getKey();
                LinkedList<TimeSlice> list = entry.getValue();
                this.writeBuf(marker, list, buf);
            }
            buf.append(" } ");
        }
        return buf.toString();
    }

    private void writeBuf(String marker, List<TimeSlice> tsList, StringBuilder buf) {
        long total = -1L;
        for (TimeSlice ts : tsList) {
            Long elapsed = ts.getElapsed();
            if (elapsed == null) continue;
            if (total == -1L) {
                total = 0L;
            }
            total += elapsed.longValue();
        }
        buf.append(" [").append(marker).append("=").append(total == -1L ? "null" : total + " ms").append("]");
    }

    class TimeSlice {
        String _marker;
        long _begin;
        long _end;

        public TimeSlice(String marker) {
            this._marker = marker;
            this._begin = StopWatch.this.now();
            this._end = 0L;
        }

        public void setFinished() {
            this._end = StopWatch.this.now();
        }

        public Long getElapsed() {
            if (this._end == 0L) {
                return StopWatch.this.now();
            }
            return new Long(this._end - this._begin);
        }
    }
}

