/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.util;

import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.capability.CapabilityMetadata;
import com.vmware.vim.binding.pbm.capability.GenericTypeInfo;
import com.vmware.vim.binding.pbm.capability.PropertyInstance;
import com.vmware.vim.binding.pbm.capability.PropertyMetadata;
import com.vmware.vim.binding.pbm.capability.types.BuiltinGenericTypesEnum;
import com.vmware.vim.binding.pbm.capability.types.DiscreteSet;
import com.vmware.vim.binding.pbm.capability.types.Range;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.util.List;
import java.util.Map;

public class RuleSetUtil {
    public static SubProfileCapabilityConstraints.SubProfile[] getSubProfiles(Profile profile) {
        if (profile == null || !(profile instanceof CapabilityBasedProfile)) {
            return null;
        }
        CapabilityBasedProfile capabilityBasedProfile = (CapabilityBasedProfile)profile;
        if (capabilityBasedProfile.constraints != null && capabilityBasedProfile.constraints instanceof SubProfileCapabilityConstraints) {
            return ((SubProfileCapabilityConstraints)capabilityBasedProfile.constraints).subProfiles;
        }
        return null;
    }

    public static SubProfileCapabilityConstraints.SubProfile getFirstSubProfile(Profile profile) {
        SubProfileCapabilityConstraints.SubProfile[] subProfiles = RuleSetUtil.getSubProfiles(profile);
        if (subProfiles != null && subProfiles.length > 0) {
            return subProfiles[0];
        }
        return null;
    }

    public static String getSubProfileVendorNamespace(SubProfileCapabilityConstraints.SubProfile subProfile) {
        if (subProfile != null && subProfile.capability != null) {
            for (CapabilityInstance capabilityInstance : subProfile.capability) {
                if (!MetadataUtil.isVendorNamespace(capabilityInstance.id.namespace)) continue;
                return capabilityInstance.id.namespace;
            }
        }
        return null;
    }

    public static SubProfileCapabilityConstraints.SubProfile createSubProfile(String title, List<CapabilityInstance> capabilities) {
        SubProfileCapabilityConstraints.SubProfile subProfile = new SubProfileCapabilityConstraints.SubProfile();
        subProfile.name = title;
        subProfile.capability = capabilities.toArray(new CapabilityInstance[capabilities.size()]);
        return subProfile;
    }

    public static NamespaceCapabilityMetadata getSubProfilePersistenceNamespace(SubProfileCapabilityConstraints.SubProfile subProfile, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        if (subProfile == null || subProfile.capability == null) {
            return null;
        }
        for (CapabilityInstance capabilityInstance : subProfile.capability) {
            NamespaceCapabilityMetadata capabilityNamespace;
            if (!MetadataUtil.isVendorNamespace(capabilityInstance.id.namespace) || !MetadataUtil.isPersistenceNamespace(capabilityNamespace = namespaceMetadata.get(capabilityInstance.id.namespace))) continue;
            return capabilityNamespace;
        }
        return null;
    }

    public static String getRuleSetTitle(int ruleSetIndex, String namespaceTitle) {
        String ruleSetTitle = PbmUtil.getLocalizedString("profile.content.ruleSet.titleFormat", "" + ruleSetIndex);
        if (namespaceTitle != null) {
            ruleSetTitle = PbmUtil.getLocalizedString("profile.content.ruleSet.titleFormatWithNamespace", ruleSetTitle, namespaceTitle);
        }
        return ruleSetTitle;
    }

    public static boolean hasMultipleNestedProperties(CapabilityMetadata capabilityMetadata) {
        if (capabilityMetadata == null) {
            return false;
        }
        if (capabilityMetadata.propertyMetadata != null && capabilityMetadata.propertyMetadata.length > 1) {
            return true;
        }
        return Boolean.TRUE.equals(capabilityMetadata.allowMultipleConstraints);
    }

    public static String getGenericTypeName(PropertyMetadata propertyMetadata) {
        if (propertyMetadata == null) {
            return null;
        }
        if (propertyMetadata.requirementsTypeHint != null) {
            String hint = propertyMetadata.requirementsTypeHint;
            if (BuiltinGenericTypesEnum.VMW_RANGE.toString().equals(hint) || BuiltinGenericTypesEnum.VMW_SET.toString().equals(hint)) {
                return hint;
            }
            return null;
        }
        if (propertyMetadata.type != null && propertyMetadata.type instanceof GenericTypeInfo) {
            GenericTypeInfo genericTypeInfo = (GenericTypeInfo)propertyMetadata.type;
            return genericTypeInfo.genericTypeName;
        }
        return null;
    }

    public static boolean hasGenericValue(PropertyInstance propertyInstance, PropertyMetadata propertyMetadata) {
        String genericTypeName = RuleSetUtil.getGenericTypeName(propertyMetadata);
        if (BuiltinGenericTypesEnum.VMW_RANGE.toString().equals(genericTypeName)) {
            return propertyInstance.value instanceof Range;
        }
        if (BuiltinGenericTypesEnum.VMW_SET.toString().equals(genericTypeName)) {
            return propertyInstance.value instanceof DiscreteSet;
        }
        return false;
    }
}

