/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.DatastoreNamespaceManager;
import com.vmware.vim.binding.vim.FileManager;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.VirtualDiskManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.storage.FileSpec;
import com.vmware.vsphere.client.storage.DatastoreCreateFolderSpec;
import com.vmware.vsphere.client.storage.DatastoreDeleteFileSpec;
import com.vmware.vsphere.client.storage.DatastoreFileCopySpec;
import com.vmware.vsphere.client.storage.DatastoreFileMoveSpec;
import com.vmware.vsphere.client.storage.DatastoreFileRenameSpec;
import com.vmware.vsphere.client.storage.InflateDiskSpec;
import com.vmware.vsphere.client.storage.util.DatastoreBrowserUtil;
import com.vmware.vsphere.client.storage.util.DatastorePathUtil;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreFileMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DatastoreFileMutationProvider.class);
    private QueryExecutor _queryExecutor;
    private TaskMonitor _taskMonitor;

    public DatastoreFileMutationProvider(QueryExecutor queryExecutor, TaskMonitor taskMonitor) {
        this._queryExecutor = queryExecutor;
        this._taskMonitor = taskMonitor;
    }

    public OperationResult add(DatastoreCreateFolderSpec spec) {
        DatastorePathUtil.escapeDatastoreNameInDatastoreCreateFolderSpec(spec);
        OperationResult opResult = new OperationResult();
        try {
            String serverGuid = this.getServerGuid(spec.datastore);
            if (spec.isRootFolder && !spec.supportTopLevelDirectoryCreate) {
                DatastoreNamespaceManager dsNamespaceManager = this.getDatastoreNamespaceManager(serverGuid);
                dsNamespaceManager.CreateDirectory(spec.datastore, spec.folderName, spec.policy);
            } else {
                FileManager fileManager = this.getFileManager(serverGuid);
                fileManager.makeDirectory(spec.folderName, spec.datacenter, Boolean.valueOf(spec.createParentDirectories));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to create folder: ", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult[] removeOnMultiEntity(ManagedObjectReference[] datastoreRef, DatastoreDeleteFileSpec spec) {
        DatastorePathUtil.escapeDatastoreNameInDatastoreDeleteFileSpec(spec);
        OperationResult[] opResults = null;
        try {
            opResults = new OperationResult[spec.targetFiles.length];
            FileManager fileManager = this.getFileManager(this.getServerGuid(datastoreRef[0]));
            for (int i = 0; i < spec.targetFiles.length; ++i) {
                opResults[i] = new OperationResult();
                String targetFile = spec.targetFiles[i];
                String targetFileType = spec.fileTypes[i];
                try {
                    ManagedObjectReference task = fileManager.delete(spec.sourceDatacenter, targetFile, targetFileType);
                    opResults[i].task = task;
                    continue;
                }
                catch (Exception e) {
                    _logger.error((Object)("Failed to remove file or folder " + targetFile + ": "), (Throwable)e);
                    opResults[i].error = MixedUtil.getMethodFault((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to remove file or folder: ", (Throwable)e);
            opResults = new OperationResult[]{new OperationResult()};
            opResults[0].error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResults;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, InflateDiskSpec spec) {
        DatastorePathUtil.escapeDatastoreNameInInflateDiskSpec(spec);
        OperationResult opResult = new OperationResult();
        try {
            VirtualDiskManager diskManager = this.getVirtualDiskManager(datastoreRef.getServerGuid());
            ManagedObjectReference task = diskManager.inflateVirtualDisk(spec.targetFile, spec.sourceDatacenter);
            opResult.task = task;
            if (spec.waitTaskToComplete) {
                this._taskMonitor.monitorTask(task);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to inflate disk: ", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, DatastoreFileCopySpec spec) {
        ManagedObjectReference destinationDatacenter;
        DatastorePathUtil.escapeDatastoreNameInDatastoreFileCopySpec(spec);
        OperationResult result = new OperationResult();
        result.entity = datastoreRef;
        FileManager fileManager = null;
        try {
            fileManager = this.getFileManager(datastoreRef.getServerGuid());
        }
        catch (Exception e) {
            _logger.error((Object)"Excepton while acquiring file manager.", (Throwable)e);
            result.error = e;
            return result;
        }
        try {
            destinationDatacenter = (ManagedObjectReference)this._queryExecutor.getProperty((Object)spec.destinationDatastore, "dc");
        }
        catch (Exception e) {
            _logger.error((Object)"Exception while retrieving destination datastore's datacenter.", (Throwable)e);
            result.error = e;
            return result;
        }
        ArrayList<ManagedObjectReference> copyTasks = new ArrayList<ManagedObjectReference>(spec.sourcePaths.length);
        for (int i = 0; i < spec.sourcePaths.length; ++i) {
            String filePath = spec.sourcePaths[i];
            String fileType = spec.sourceFileTypes[i];
            String destinationPath = null;
            try {
                destinationPath = DatastorePathUtil.getDestinationPath(filePath, spec.destinationPath, spec.preservePath);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            try {
                copyTasks.add(fileManager.copy(spec.sourceDatacenter, filePath, destinationDatacenter, destinationPath, spec.overwrite, fileType));
                continue;
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to copy file.", (Throwable)ex);
            }
        }
        if (spec.waitTasksToComplete && !copyTasks.isEmpty()) {
            try {
                this._taskMonitor.monitorTasks(copyTasks);
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to copy files.", (Throwable)ex);
                result.error = ex;
            }
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, DatastoreFileMoveSpec spec) {
        ManagedObjectReference destinationDatacenter;
        DatastorePathUtil.escapeDatastoreNameInDatastoreFileMoveSpec(spec);
        OperationResult result = new OperationResult();
        result.entity = datastoreRef;
        FileManager fileManager = null;
        try {
            fileManager = this.getFileManager(datastoreRef.getServerGuid());
        }
        catch (Exception e) {
            _logger.error((Object)"Excepton while acquiring file manager.", (Throwable)e);
            result.error = e;
            return result;
        }
        try {
            destinationDatacenter = (ManagedObjectReference)this._queryExecutor.getProperty((Object)spec.destinationDatastore, "dc");
        }
        catch (Exception e) {
            _logger.error((Object)"Exception while retrieving destination datastore's datacenter.", (Throwable)e);
            result.error = e;
            return result;
        }
        ArrayList<ManagedObjectReference> moveTasks = new ArrayList<ManagedObjectReference>(spec.sourcePaths.length);
        for (int i = 0; i < spec.sourcePaths.length; ++i) {
            String filePath = spec.sourcePaths[i];
            String fileType = spec.sourceFileTypes[i];
            String destinationPath = null;
            try {
                destinationPath = DatastorePathUtil.getDestinationPath(filePath, spec.destinationPath, spec.preservePath);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            try {
                moveTasks.add(fileManager.move(spec.sourceDatacenter, filePath, destinationDatacenter, destinationPath, spec.overwrite, fileType));
                continue;
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to move file.", (Throwable)ex);
            }
        }
        if (spec.waitTasksToComplete && !moveTasks.isEmpty()) {
            try {
                this._taskMonitor.monitorTasks(moveTasks);
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to move files.", (Throwable)ex);
                result.error = ex;
            }
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference moRef, FileSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = moRef;
        try {
            operationResult = DatastoreBrowserUtil.queryFiles(this._taskMonitor, moRef, spec);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to call DatastoreBrowserUtil.queryFiles()", (Throwable)ex);
            operationResult.error = ex;
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference datastoreRef, DatastoreFileRenameSpec spec) {
        ManagedObjectReference sourceDatacenter;
        DatastorePathUtil.escapeDatastoreNameInDatastoreFileRenameSpec(spec);
        OperationResult result = new OperationResult();
        result.entity = datastoreRef;
        FileManager fileManager = null;
        try {
            fileManager = this.getFileManager(datastoreRef.getServerGuid());
        }
        catch (Exception e) {
            _logger.error((Object)"Excepton while acquiring file manager.", (Throwable)e);
            result.error = e;
            return result;
        }
        try {
            sourceDatacenter = (ManagedObjectReference)this._queryExecutor.getProperty((Object)datastoreRef, "dc");
        }
        catch (Exception e) {
            _logger.error((Object)"Exception while retrieving destination datastore's datacenter.", (Throwable)e);
            result.error = e;
            return result;
        }
        String destinationPath = null;
        try {
            destinationPath = DatastorePathUtil.replacePathTrail(spec.sourcePath, spec.destinationName);
        }
        catch (IllegalArgumentException e) {
            result.error = new IllegalArgumentException(e.getMessage());
            return result;
        }
        BlockingFuture future = new BlockingFuture();
        fileManager.move(sourceDatacenter, spec.sourcePath, null, destinationPath, false, FileManager.FileType.File.name(), (Future)future);
        try {
            result.task = future.get();
        }
        catch (Exception e) {
            _logger.error((Object)"Exception while retrieving rename's task.", (Throwable)e);
            result.error = e;
            return result;
        }
        return result;
    }

    private String getServerGuid(ManagedObjectReference moRef) {
        if (moRef == null) {
            return null;
        }
        return moRef.getServerGuid();
    }

    private FileManager getFileManager(String serverGuid) throws Exception {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        ServiceInstance serviceInstance = service.getServiceInstance();
        ServiceInstanceContent sc = serviceInstance.retrieveContent();
        FileManager fileManager = (FileManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sc.fileManager);
        return fileManager;
    }

    private VirtualDiskManager getVirtualDiskManager(String serverGuid) throws Exception {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        ServiceInstance serviceInstance = service.getServiceInstance();
        ServiceInstanceContent sc = serviceInstance.retrieveContent();
        VirtualDiskManager vdManager = (VirtualDiskManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sc.virtualDiskManager);
        return vdManager;
    }

    private DatastoreNamespaceManager getDatastoreNamespaceManager(String serverGuid) throws Exception {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        ServiceInstance serviceInstance = service.getServiceInstance();
        ServiceInstanceContent sc = serviceInstance.retrieveContent();
        DatastoreNamespaceManager dsNamespaceManager = (DatastoreNamespaceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sc.datastoreNamespaceManager);
        return dsNamespaceManager;
    }
}

