/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.guest.auth.impl;

import com.vmware.vim.binding.vim.fault.GuestMultipleMappings;
import com.vmware.vim.binding.vim.vm.guest.AliasManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.vm.guest.auth.GuestAliasAdditionSpec;
import com.vmware.vsphere.client.vm.guest.auth.GuestAliasRemovalSpec;
import com.vmware.vsphere.client.vm.guest.auth.GuestAuthSpec;
import com.vmware.vsphere.client.vm.guest.auth.impl.VmGuestUtilities;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmGuestAliasMutationProvider
implements MutationProvider {
    private static Log _logger = LogFactory.getLog(VmGuestAliasMutationProvider.class);

    public OperationResult apply(ManagedObjectReference vmRef, GuestAliasAdditionSpec spec) {
        Validate.notNull((Object)((Object)spec));
        Validate.notNull((Object)spec.vm);
        Validate.notEmpty((Object[])spec.base64Cert);
        OperationResult result = this.createGenericOperationResult(vmRef);
        try {
            AliasManager aliasMgr = VmGuestUtilities.getAliasManager(vmRef);
            GuestAuthSpec guestAuthSpec = VmGuestUtilities.decrypt(spec.auth, vmRef);
            for (String base64Cert : spec.base64Cert) {
                try {
                    aliasMgr.addAlias(spec.vm, guestAuthSpec.guestAuth, spec.username, true, base64Cert, spec.aliasInfo);
                }
                catch (GuestMultipleMappings gmmError) {
                    _logger.warn((Object)"Guest mapping already exists", (Throwable)gmmError);
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to add alias.", (Throwable)exception);
            result.error = exception;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vmRef, GuestAliasRemovalSpec[] removalSpecs) throws Exception {
        Validate.notEmpty((Object[])removalSpecs);
        OperationResult result = this.createGenericOperationResult(vmRef);
        AliasManager aliasMgr = VmGuestUtilities.getAliasManager(vmRef);
        ArrayList<Exception> faults = new ArrayList<Exception>();
        try {
            for (GuestAliasRemovalSpec spec : removalSpecs) {
                GuestAuthSpec guestAuthSpec = VmGuestUtilities.decrypt(spec.auth, vmRef);
                aliasMgr.removeAlias(spec.vm, guestAuthSpec.guestAuth, spec.username, spec.base64Cert, spec.subject);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to remove alias.", (Throwable)exception);
            faults.add(exception);
        }
        if (!faults.isEmpty()) {
            result.error = faults.size() > 1 ? this.newCompositeException("", (Exception[])ArrayUtil.toArray(faults, Exception.class)) : (Exception)faults.get(0);
        }
        return result;
    }

    private OperationResult createGenericOperationResult(ManagedObjectReference vmRef) {
        OperationResult result = new OperationResult();
        OperationEffect effect = new OperationEffect();
        effect.affectedEntites = new Object[]{vmRef};
        result.effect = effect;
        return result;
    }

    private CompositeException newCompositeException(String message, Exception ... nestedExceptions) {
        CompositeException ce = new CompositeException(nestedExceptions);
        ce.setMessage(message);
        return ce;
    }
}

