/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.issue.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.GuestInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;
import com.vmware.vsphere.client.vm.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="Issue,VmToolsIssue")
public class VmToolsIssueAdapter
extends IssueAdapterBase {
    private static final String VM_TOOLS_ISSUE_TYPE = "VmToolsIssue";
    private static final String VM_NAME_PROPERTY = "name";
    private static final String POWER_STATE_PROPERTY = "summary.runtime.powerState";
    private static final String RUNNING_STATUS_PROPERTY = "summary.guest.toolsRunningStatus";
    private static final String VERSION_STATUS_PROPERTY = "summary.guest.toolsVersionStatus2";
    private static final Log _logger = LogFactory.getLog(VmToolsIssueAdapter.class);
    private DataService _dataService;

    public VmToolsIssueAdapter(DataService dataService) {
        super(VM_TOOLS_ISSUE_TYPE);
        this._dataService = dataService;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        String description;
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)entity), (String)VirtualMachine.class.getSimpleName())) {
            return new IssueAdapterBase.IssueData[0];
        }
        String vmName = null;
        VirtualMachine.PowerState powerState = null;
        String runningStatus = null;
        String versionStatus = null;
        try {
            PropertyValue[] propertyValues;
            for (PropertyValue propertyValue : propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object)entity, (String[])new String[]{VM_NAME_PROPERTY, POWER_STATE_PROPERTY, RUNNING_STATUS_PROPERTY, VERSION_STATUS_PROPERTY})) {
                if (VM_NAME_PROPERTY.equals(propertyValue.propertyName)) {
                    vmName = (String)propertyValue.value;
                    continue;
                }
                if (VERSION_STATUS_PROPERTY.equals(propertyValue.propertyName)) {
                    versionStatus = (String)propertyValue.value;
                    continue;
                }
                if (RUNNING_STATUS_PROPERTY.equals(propertyValue.propertyName)) {
                    runningStatus = (String)propertyValue.value;
                    continue;
                }
                if (!POWER_STATE_PROPERTY.equals(propertyValue.propertyName)) continue;
                powerState = (VirtualMachine.PowerState)propertyValue.value;
            }
            if (vmName == null) {
                _logger.warn((Object)String.format("Cound not retrieve VM name for %s", entity.toString()));
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error retrieving VM tools version status for %s", entity.toString()), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (!VirtualMachine.PowerState.poweredOn.equals(powerState)) {
            return new IssueAdapterBase.IssueData[0];
        }
        if (versionStatus == null) {
            _logger.warn((Object)String.format("Cound not retrieve VMware Tools version for %s", entity.toString()));
            return new IssueAdapterBase.IssueData[0];
        }
        if (GuestInfo.ToolsVersionStatus.guestToolsCurrent.equals((Object)GuestInfo.ToolsVersionStatus.valueOf(versionStatus)) || GuestInfo.ToolsVersionStatus.guestToolsSupportedNew.equals((Object)GuestInfo.ToolsVersionStatus.valueOf(versionStatus)) || GuestInfo.ToolsVersionStatus.guestToolsUnmanaged.equals((Object)GuestInfo.ToolsVersionStatus.valueOf((String)versionStatus))) {
            return new IssueAdapterBase.IssueData[0];
        }
        String descriptionKey = null;
        if (GuestInfo.ToolsVersionStatus.guestToolsNotInstalled.equals((Object)GuestInfo.ToolsVersionStatus.valueOf((String)versionStatus))) {
            description = Util.getLocalizedString("tools.install");
        } else {
            description = Util.getLocalizedString("tools.upgrade");
            descriptionKey = "tools.upgrade";
        }
        IssueInfo issueInfo = new IssueInfo();
        issueInfo.description = description;
        issueInfo.descriptionKey = descriptionKey;
        issueInfo.typeDisplayName = Util.getLocalizedString("issue.vmTools.displayName");
        issueInfo.entity = entity;
        issueInfo.entityName = vmName;
        issueInfo.details = runningStatus + "|" + versionStatus;
        issueInfo.status = IssueStatus.WARNING;
        IssueAdapterBase.IssueData issueData = new IssueAdapterBase.IssueData();
        issueData.key = entity.toString();
        issueData.issueInfo = issueInfo;
        return new IssueAdapterBase.IssueData[]{issueData};
    }
}

