/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.network.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.host.Capability;
import com.vmware.vim.binding.vim.vm.ConfigOption;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vim.vm.DeviceRuntimeInfo;
import com.vmware.vim.binding.vim.vm.PciPassthroughInfo;
import com.vmware.vim.binding.vim.vm.SriovInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceOption;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCardOption;
import com.vmware.vim.binding.vim.vm.device.VirtualSriovEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.vm.network.VmNptContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmNetworkPropertyProvider
implements PropertyProviderBean {
    private static final String VM_PROPERTY_ENV_BROWSER = "environmentBrowser";
    private static final String VM_PROPERTY_TEMPLATE = "config.template";
    private static final String VM_PROPERTY_DEVICE_INFO = "runtime.device";
    private static final String VM_PROPERTY_DEVICE = "config.hardware.device";
    private static final String VM_RELATION_HOST = "host";
    private static final String HOST_PROPERTY_CAPABILITY = "capability";
    private static final String HOST_RELATION_DVS = "dvs";
    private static final String DVS_PROPERTY_UUID = "config.uuid";
    private static final Log _logger = LogFactory.getLog(VmNetworkPropertyProvider.class);
    private final DataService _dataService;

    public VmNetworkPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="VirtualMachine")
    public VmNptContext getVmNptContext(ManagedObjectReference vmRef) {
        VmNptContext nptContext;
        try {
            nptContext = new VmNptData(vmRef).getVmNptContext();
        }
        catch (Exception ex) {
            nptContext = new VmNptContext();
            _logger.error((Object)ex);
        }
        return nptContext;
    }

    private class VmNptData {
        private DeviceRuntimeInfo[] _deviceStates;
        private VirtualDeviceOption[] _hardwareOptions;
        private Capability _hostCapability;
        private DistributedVirtualPort[] _distributedVirtualPort;
        private SriovInfo[] _sriov;
        private PciPassthroughInfo[] _pciPassthrough;
        private ManagedObjectReference _environmentBrowserRef;
        private VirtualDevice[] _vmDevice;
        private final ManagedObjectReference _vmRef;
        private Boolean _isTemplate;
        private boolean _hasSriovDevice = false;
        private final Map<String, ManagedObjectReference> _dvsMap = new HashMap<String, ManagedObjectReference>();
        private final Map<String, Set<String>> _dvsPortkeyMap = new HashMap<String, Set<String>>();

        public VmNptData(ManagedObjectReference vmRef) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{vmRef});
            this._vmRef = vmRef;
        }

        public VmNptContext getVmNptContext() throws Exception {
            _logger.debug((Object)"getVmConfigNptContext");
            this.queryVmProperties();
            if (Boolean.TRUE.equals(this._isTemplate)) {
                return null;
            }
            EnvironmentBrowser browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)this._environmentBrowserRef);
            if (browser == null) {
                throw new RuntimeException("Invalid environment browser reference.");
            }
            this.processVirtualDevices();
            List<ClientFutureImpl<DistributedVirtualPort[]>> queryPortsFutureList = this.queryVmPorts();
            ClientFutureImpl<ConfigOption> queryOptionsFuture = this.queryVmConfigOptions(browser);
            ClientFutureImpl<ConfigTarget> queryTargetFuture = this.queryVmConfigTarget(browser);
            this.processPortsFutures(queryPortsFutureList);
            this.processVmConfigOptions(queryOptionsFuture);
            this.processVmConfigTarget(queryTargetFuture);
            return this.asVmNptContext();
        }

        private void queryVmProperties() {
            Response response = null;
            try {
                QuerySpec vmPropsQuerySpec = QueryUtil.buildQuerySpec((Object)this._vmRef, (String[])new String[]{VmNetworkPropertyProvider.VM_PROPERTY_ENV_BROWSER, VmNetworkPropertyProvider.VM_PROPERTY_TEMPLATE, VmNetworkPropertyProvider.VM_PROPERTY_DEVICE_INFO, VmNetworkPropertyProvider.VM_PROPERTY_DEVICE});
                ObjectIdentityConstraint vmConstraint = QueryUtil.createObjectIdentityConstraint((Object)this._vmRef);
                RelationalConstraint hostConstraint = QueryUtil.createRelationalConstraint((String)VmNetworkPropertyProvider.VM_RELATION_HOST, (Constraint)vmConstraint, (Boolean)true, (String)HostSystem.class.getSimpleName());
                RelationalConstraint dvsConstraint = QueryUtil.createRelationalConstraint((String)VmNetworkPropertyProvider.HOST_RELATION_DVS, (Constraint)hostConstraint.clone(), (Boolean)true, (String)DistributedVirtualSwitch.class.getSimpleName());
                QuerySpec hostPropsQuerySpec = QueryUtil.buildQuerySpec((Constraint)hostConstraint, (String[])new String[]{VmNetworkPropertyProvider.HOST_PROPERTY_CAPABILITY});
                QuerySpec dvsPropQuerySpec = QueryUtil.buildQuerySpec((Constraint)dvsConstraint, (String[])new String[]{VmNetworkPropertyProvider.DVS_PROPERTY_UUID});
                ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
                querySpecs.add(vmPropsQuerySpec);
                querySpecs.add(hostPropsQuerySpec);
                querySpecs.add(dvsPropQuerySpec);
                RequestSpec requestSpec = new RequestSpec();
                requestSpec.querySpec = querySpecs.toArray(new QuerySpec[querySpecs.size()]);
                response = VmNetworkPropertyProvider.this._dataService.getData(requestSpec);
            }
            catch (CloneNotSupportedException e) {
                _logger.error((Object)"Error creating query specs.", (Throwable)e);
            }
            if (response == null || response.resultSet == null) {
                throw new RuntimeException(String.format("Data retrieval failed for virtual machine %s", this._vmRef.toString()));
            }
            for (ResultSet results : response.resultSet) {
                if (results.items == null) continue;
                for (ResultItem resultItem : results.items) {
                    if (resultItem.properties == null) continue;
                    for (PropertyValue propValue : resultItem.properties) {
                        String dvsUuid;
                        if (propValue.value == null) continue;
                        if (VmNetworkPropertyProvider.VM_PROPERTY_ENV_BROWSER.equals(propValue.propertyName)) {
                            this._environmentBrowserRef = (ManagedObjectReference)propValue.value;
                            continue;
                        }
                        if (VmNetworkPropertyProvider.VM_PROPERTY_TEMPLATE.equals(propValue.propertyName)) {
                            this._isTemplate = (Boolean)propValue.value;
                            continue;
                        }
                        if (VmNetworkPropertyProvider.VM_PROPERTY_DEVICE_INFO.equals(propValue.propertyName)) {
                            this._deviceStates = (DeviceRuntimeInfo[])propValue.value;
                            continue;
                        }
                        if (VmNetworkPropertyProvider.VM_PROPERTY_DEVICE.equals(propValue.propertyName)) {
                            this._vmDevice = (VirtualDevice[])propValue.value;
                            continue;
                        }
                        if (VmNetworkPropertyProvider.HOST_PROPERTY_CAPABILITY.equals(propValue.propertyName)) {
                            this._hostCapability = (Capability)propValue.value;
                            continue;
                        }
                        if (!VmNetworkPropertyProvider.DVS_PROPERTY_UUID.equals(propValue.propertyName) || StringUtil.isNullOrEmpty((String)(dvsUuid = (String)propValue.value))) continue;
                        this._dvsMap.put(dvsUuid, (ManagedObjectReference)resultItem.resourceObject);
                    }
                }
            }
        }

        private List<ClientFutureImpl<DistributedVirtualPort[]>> queryVmPorts() {
            ArrayList<ClientFutureImpl<DistributedVirtualPort[]>> futureList = new ArrayList<ClientFutureImpl<DistributedVirtualPort[]>>();
            for (Map.Entry<String, Set<String>> entry : this._dvsPortkeyMap.entrySet()) {
                String switchUuid = entry.getKey();
                ManagedObjectReference dvsMor = this._dvsMap.get(switchUuid);
                if (dvsMor == null || entry.getValue().size() <= 0) continue;
                try {
                    DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsMor);
                    if (dvs == null) continue;
                    PortCriteria portCriteria = new PortCriteria();
                    portCriteria.portKey = entry.getValue().toArray(new String[entry.getValue().size()]);
                    ClientFutureImpl future = new ClientFutureImpl();
                    dvs.fetchPorts(portCriteria, (Future)future);
                    futureList.add((ClientFutureImpl<DistributedVirtualPort[]>)future);
                }
                catch (Exception ex) {
                    _logger.error((Object)ex);
                }
            }
            return futureList;
        }

        private ClientFutureImpl<ConfigOption> queryVmConfigOptions(EnvironmentBrowser browser) {
            ClientFutureImpl queryOptionsFuture = new ClientFutureImpl();
            String serverGuid = this._environmentBrowserRef.getServerGuid();
            if (!StringUtil.isNullOrEmpty((String)serverGuid) && VcServiceUtil.is2014VcOrLater((String)serverGuid)) {
                _logger.debug((Object)"invoke queryConfigOptionEx()");
                browser.queryConfigOptionEx(null, (Future)queryOptionsFuture);
            } else {
                _logger.debug((Object)"invoke queryConfigOption()");
                browser.queryConfigOption(null, null, (Future)queryOptionsFuture);
            }
            return queryOptionsFuture;
        }

        private ClientFutureImpl<ConfigTarget> queryVmConfigTarget(EnvironmentBrowser browser) {
            ClientFutureImpl queryTargetFuture = null;
            if (this._hasSriovDevice) {
                _logger.debug((Object)"invoke queryConfigTarget()");
                queryTargetFuture = new ClientFutureImpl();
                browser.queryConfigTarget(null, (Future)queryTargetFuture);
            }
            return queryTargetFuture;
        }

        private void processVirtualDevices() {
            if (this._vmDevice == null) {
                return;
            }
            for (VirtualDevice device : this._vmDevice) {
                if (device instanceof VirtualSriovEthernetCard) {
                    this._hasSriovDevice = true;
                }
                if (!(device instanceof VirtualEthernetCard) || !(device.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo)) continue;
                VirtualEthernetCard.DistributedVirtualPortBackingInfo portBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing;
                if (portBacking.port == null || StringUtil.isNullOrEmpty((String)portBacking.port.switchUuid) || StringUtil.isNullOrEmpty((String)portBacking.port.portKey)) continue;
                Set<String> portkeySet = this._dvsPortkeyMap.get(portBacking.port.switchUuid);
                if (portkeySet == null) {
                    portkeySet = new TreeSet<String>();
                    this._dvsPortkeyMap.put(portBacking.port.switchUuid, portkeySet);
                }
                portkeySet.add(portBacking.port.portKey);
            }
        }

        private void processPortsFutures(List<ClientFutureImpl<DistributedVirtualPort[]>> futureList) {
            ArrayList<DistributedVirtualPort> portList = new ArrayList<DistributedVirtualPort>();
            for (ClientFutureImpl<DistributedVirtualPort[]> future : futureList) {
                try {
                    DistributedVirtualPort[] ports = (DistributedVirtualPort[])future.get();
                    if (ports == null) continue;
                    for (DistributedVirtualPort port : ports) {
                        port.config = null;
                        portList.add(port);
                    }
                }
                catch (Exception ex) {
                    _logger.error((Object)ex);
                }
            }
            this._distributedVirtualPort = portList.toArray(new DistributedVirtualPort[portList.size()]);
        }

        private void processVmConfigOptions(ClientFutureImpl<ConfigOption> future) {
            if (future == null) {
                return;
            }
            ConfigOption option = null;
            try {
                option = (ConfigOption)future.get();
            }
            catch (Exception ex) {
                _logger.error((Object)ex);
            }
            if (option == null || option.hardwareOptions == null || option.hardwareOptions.virtualDeviceOption == null) {
                return;
            }
            ArrayList<VirtualDeviceOption> deviceOptionList = new ArrayList<VirtualDeviceOption>();
            for (VirtualDeviceOption deviceOption : option.hardwareOptions.virtualDeviceOption) {
                if (!(deviceOption instanceof VirtualEthernetCardOption)) continue;
                deviceOptionList.add(deviceOption);
            }
            this._hardwareOptions = deviceOptionList.toArray(new VirtualDeviceOption[deviceOptionList.size()]);
        }

        private void processVmConfigTarget(ClientFutureImpl<ConfigTarget> future) {
            if (future == null) {
                return;
            }
            try {
                ConfigTarget target = (ConfigTarget)future.get();
                if (target != null) {
                    this._sriov = target.sriov;
                    this._pciPassthrough = target.pciPassthrough;
                }
            }
            catch (Exception ex) {
                _logger.error((Object)ex);
            }
        }

        private VmNptContext asVmNptContext() {
            VmNptContext nptContext = new VmNptContext();
            nptContext.deviceStates = this._deviceStates;
            nptContext.distributedVirtualPort = this._distributedVirtualPort;
            nptContext.hardwareOptions = this._hardwareOptions;
            nptContext.hostCapability = this._hostCapability;
            nptContext.pciPassthrough = this._pciPassthrough;
            nptContext.sriov = this._sriov;
            return nptContext;
        }
    }
}

