/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.screenshot;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.vm.screenshot.VmScreenshotSize;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmScreenshotPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VmScreenshotPropertyProvider.class);
    private final KeystoreService _keystoreService;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final int socketTimeoutMillis;

    public VmScreenshotPropertyProvider(KeystoreService keystoreService, SSLConfigurationProvider sslConfigurationProvider, long dataRetrievalTimeoutInMillis) {
        this._keystoreService = keystoreService;
        this._sslConfigurationProvider = sslConfigurationProvider;
        this.socketTimeoutMillis = (int)dataRetrievalTimeoutInMillis;
    }

    @type(value="VirtualMachine,VirtualMachineSnapshot")
    public byte[] getVmScreenshot(ManagedObjectReference moRef, VmScreenshotSize size) {
        Map<String, String> requestHeaders;
        HttpClient httpClient = this.getHttpClient();
        if (httpClient == null) {
            return null;
        }
        VcService vcService = VimSessionUtil.getService((String)moRef.getServerGuid());
        String requestUrl = this.getRequestUrl(vcService, moRef, size);
        byte[] result = httpClient.executeMethodResponseAsBytes(requestUrl, null, requestHeaders = this.getRequestHeaders(vcService));
        if (result == null || result.length == 0) {
            _logger.error((Object)"Cannot get VM screenshot, result is empty");
        }
        return result;
    }

    private HttpClient getHttpClient() {
        HttpClient httpClient = null;
        try {
            httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).addTrustStore(this._keystoreService.getKeyStore()).socketConnectionTimeout(this.socketTimeoutMillis).socketReadTimeout(this.socketTimeoutMillis).buildHttpClient();
        }
        catch (SSLException exception) {
            _logger.debug((Object)"Failed to create HTTP client.", (Throwable)exception);
        }
        return httpClient;
    }

    private String getRequestUrl(VcService vcService, ManagedObjectReference moRef, VmScreenshotSize size) {
        String vcServiceUrl = VcServiceUtil.getServiceUrl((VcService)vcService);
        StringBuilder urlBuilder = new StringBuilder(vcServiceUrl);
        urlBuilder.append("/screen?id=" + moRef.getValue());
        if (size != null && size.height > 0 && size.width > 0) {
            urlBuilder.append("&h=" + size.height + "&w=" + size.width);
        }
        String urlString = urlBuilder.toString();
        return urlString;
    }

    private Map<String, String> getRequestHeaders(VcService vcService) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String sessionCookie = vcService.getConnectionInfo().getSessionCookie();
        String header = "vmware_soap_session=" + sessionCookie;
        headers.put("Cookie", header);
        return headers;
    }
}

