/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.storageDrs.rules;

import com.vmware.vim.binding.vim.cluster.AntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRulesBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SdrsRulesManager {
    private static final Log LOGGER = LogFactory.getLog(SdrsRulesManager.class);
    private static final String DS_CLUSTER_PROPERY_NAME = "storagePod";
    private static final String DS_CLUSTER_TYPE_NAME = "StoragePod";
    private static final String DS_CLUSTER_VM_CONFIG_PROPERTY_NAME = "podStorageDrsEntry.storageDrsConfig.vmConfig";
    private static final String DS_CLUSTER_RULES_PROPERTY_NAME = "podStorageDrsEntry.storageDrsConfig.podConfig.rule";
    private static final String DS_CLUSTER_NAME_PROPERTY = "name";
    private DataService _dataService;

    public SdrsRulesManager(DataService dataService) {
        this._dataService = dataService;
    }

    public SdrsRuleInfo[] getSdrsRules(ManagedObjectReference vmRef) throws Exception {
        ResultSet resultSet = this.getRelatedDatastoreClustersSdrsRuleInfo(vmRef);
        List<SdrsRuleInfo> sdrsRules = this.extractSdrsRules(resultSet, vmRef);
        int rulesCount = sdrsRules.size();
        SdrsRuleInfo[] result = sdrsRules.toArray(new SdrsRuleInfo[rulesCount]);
        return result;
    }

    private ResultSet getRelatedDatastoreClustersSdrsRuleInfo(ManagedObjectReference vmRef) throws Exception {
        RelationalConstraint pods = QueryUtil.createRelationalConstraint((String)DS_CLUSTER_PROPERY_NAME, (Constraint)QueryUtil.createObjectIdentityConstraint((Object)vmRef), (Boolean)true, (String)DS_CLUSTER_TYPE_NAME);
        PropertySpec propSpec = new PropertySpec();
        propSpec.propertyNames = new String[]{DS_CLUSTER_RULES_PROPERTY_NAME, DS_CLUSTER_VM_CONFIG_PROPERTY_NAME, DS_CLUSTER_NAME_PROPERTY};
        QuerySpec query = new QuerySpec();
        query.resourceSpec = QueryUtil.createEmptyResourceSpec();
        query.resourceSpec.propertySpecs = new PropertySpec[]{propSpec};
        query.resourceSpec.constraint = pods;
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        return resultSet;
    }

    private List<SdrsRuleInfo> extractSdrsRules(ResultSet resultSet, ManagedObjectReference vmRef) {
        List<SdrsRuleInfo> sdrsRules = new ArrayList<SdrsRuleInfo>();
        if (resultSet == null || resultSet.items == null) {
            return sdrsRules;
        }
        ArrayList<DatastoreClusterSdrsRulesData> sdrsRulesConfigData = new ArrayList<DatastoreClusterSdrsRulesData>();
        for (ResultItem item : resultSet.items) {
            if (item.properties == null) continue;
            ManagedObjectReference dsClusterRef = (ManagedObjectReference)item.resourceObject;
            PropertyValue[] propertiesResult = item.properties;
            DatastoreClusterSdrsRulesData rulesData = new DatastoreClusterSdrsRulesData();
            rulesData.dsClusterRef = dsClusterRef;
            for (PropertyValue prop : propertiesResult) {
                if (DS_CLUSTER_RULES_PROPERTY_NAME.equals(prop.propertyName)) {
                    rulesData.podConfigRule = (RuleInfo[])prop.value;
                }
                if (DS_CLUSTER_VM_CONFIG_PROPERTY_NAME.equals(prop.propertyName)) {
                    rulesData.vmConfigInfo = (VmConfigInfo[])prop.value;
                }
                if (!DS_CLUSTER_NAME_PROPERTY.equals(prop.propertyName)) continue;
                rulesData.dsClusterName = (String)prop.value;
            }
            sdrsRulesConfigData.add(rulesData);
        }
        sdrsRules = this.buildSdrsRules(sdrsRulesConfigData, vmRef);
        return sdrsRules;
    }

    private List<SdrsRuleInfo> buildSdrsRules(List<DatastoreClusterSdrsRulesData> sdrsRulesConfigData, ManagedObjectReference vmRef) {
        ArrayList<SdrsRuleInfo> sdrsRules = new ArrayList<SdrsRuleInfo>();
        for (DatastoreClusterSdrsRulesData rulesData : sdrsRulesConfigData) {
            rulesData.podConfigRule = this.filterRulesByVm(rulesData.podConfigRule, vmRef);
            rulesData.vmConfigInfo = this.filterVmConfigByVm(rulesData.vmConfigInfo, vmRef);
            List vmAntiAffinityRules = SdrsRulesBuilder.buildVmAntiAffinityRules((ManagedObjectReference)rulesData.dsClusterRef, (RuleInfo[])rulesData.podConfigRule, (String)rulesData.dsClusterName);
            List intraVmAffinityRules = SdrsRulesBuilder.buildIntraVmAffinityRules((ManagedObjectReference)rulesData.dsClusterRef, (VmConfigInfo[])rulesData.vmConfigInfo, (String)rulesData.dsClusterName);
            List intraVmAntiAffinityRules = SdrsRulesBuilder.buildIntraVmAntiAffinityRules((ManagedObjectReference)rulesData.dsClusterRef, (VmConfigInfo[])rulesData.vmConfigInfo, (String)rulesData.dsClusterName);
            sdrsRules.addAll(intraVmAffinityRules);
            sdrsRules.addAll(vmAntiAffinityRules);
            sdrsRules.addAll(intraVmAntiAffinityRules);
        }
        return sdrsRules;
    }

    private RuleInfo[] filterRulesByVm(RuleInfo[] rules, ManagedObjectReference vmRef) {
        ArrayList<AntiAffinityRuleSpec> filteredRules = new ArrayList<AntiAffinityRuleSpec>();
        for (RuleInfo ruleInfo : rules) {
            if (!(ruleInfo instanceof AntiAffinityRuleSpec)) {
                LOGGER.warn((Object)"Unexpected SDRS rule type in datastore cluster config rules");
                continue;
            }
            AntiAffinityRuleSpec rule = (AntiAffinityRuleSpec)ruleInfo;
            Boolean containsVm = SdrsRulesManager.containsVm(rule.vm, vmRef);
            if (!containsVm.booleanValue()) continue;
            filteredRules.add(rule);
        }
        RuleInfo[] result = filteredRules.toArray(new RuleInfo[filteredRules.size()]);
        return result;
    }

    private VmConfigInfo[] filterVmConfigByVm(VmConfigInfo[] vmConfigInfo, ManagedObjectReference vmRef) {
        ArrayList<VmConfigInfo> filteredvmConfigInfo = new ArrayList<VmConfigInfo>();
        for (VmConfigInfo vmConfig : vmConfigInfo) {
            if (!ManagedObjectUtil.areEqual((ManagedObjectReference)vmConfig.vm, (ManagedObjectReference)vmRef).booleanValue()) continue;
            filteredvmConfigInfo.add(vmConfig);
        }
        int size = filteredvmConfigInfo.size();
        VmConfigInfo[] result = filteredvmConfigInfo.toArray(new VmConfigInfo[size]);
        return result;
    }

    private static Boolean containsVm(ManagedObjectReference[] morArray, ManagedObjectReference mor) {
        if (morArray == null || morArray.length == 0 || mor == null) {
            return false;
        }
        for (ManagedObjectReference vm : morArray) {
            if (!ManagedObjectUtil.areEqual((ManagedObjectReference)vm, (ManagedObjectReference)mor).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private class DatastoreClusterSdrsRulesData {
        public ManagedObjectReference dsClusterRef;
        RuleInfo[] podConfigRule = new RuleInfo[0];
        VmConfigInfo[] vmConfigInfo = new VmConfigInfo[0];
        public String dsClusterName;

        private DatastoreClusterSdrsRulesData() {
        }
    }
}

