/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.summary.model;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.RuntimeInfo;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.Property;
import com.vmware.vise.data.query.commands.Relationship;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.vm.util.Util;

@type(value="VirtualMachine")
public class VmSummaryData
extends DataModel {
    private static final String VM_TOOLS_STATUS_VERSION_DELIMITER = "\\|";
    private static final String GUEST_TOOLS_NOT_INSTALLED = "guestToolsNotInstalled";
    private static final String GUEST_TOOLS_NOT_RUNNING = "guestToolsNotRunning";
    private static final String VM_TOOLS_STATE_PREFIX = "tools.";
    private static final String NO_DATA = "--";
    @Property(name="name")
    public String name;
    @Property(name="guest.hostName")
    public transient String dnsNameInternal;
    @Property(name="vmIpAddressList")
    public transient String[] ipAddressesInternal;
    @Property(name="runtime.powerState")
    public VirtualMachine.PowerState powerState;
    @Property(name="effectiveGuestOsFamily")
    public String guestOsFamilyKey;
    @Property(name="guest.guestFullName")
    public transient String guestFullNameFromGuestInfo;
    @Property(name="config.guestFullName")
    public transient String guestFullNameFromConfigInfo;
    @Property(name="runtime.dasVmProtection")
    public RuntimeInfo.DasProtectionState dasProtectionState;
    @Property(name="runtime.faultToleranceState")
    public VirtualMachine.FaultToleranceState ftState;
    @Property(name="summary.quickStats.guestMemoryUsage")
    public int memoryUsageMb;
    @Property(name="summary.quickStats.overallCpuUsage")
    public int cpuUsageMhz;
    @Property(name="summary.storage.committed")
    public double storageUsageB;
    @Property(name="config.template")
    public boolean isTemplate;
    @Property(name="config.version")
    public transient String hwVersion;
    @Property(name="runtime.minRequiredEVCModeKey")
    public String minRequiredEVCModeKey;
    @Property(name="runtime.host")
    public Object host;
    @Property(name="name")
    @Relationship(name="runtime.host")
    public String hostName;
    @Property(name="config.product.version")
    @Relationship(name="runtime.host")
    public String hostVersion;
    @Property(name="toolsRunningStatus")
    public transient String toolsRunningStatus;
    @Property(name="detailedToolsVersionStatus")
    public transient String detailedToolsVersionStatus;
    @Property(name="primaryIconId")
    public String primaryIconId;
    @Property(name="vmScreenshot")
    public byte[] vmScreenshot;

    public String[] getIpAddresses() {
        if (this.ipAddressesInternal == null || this.ipAddressesInternal.length == 0 || this.ipAddressesInternal[0] == null) {
            return new String[]{NO_DATA};
        }
        return this.ipAddressesInternal;
    }

    public String getDnsName() {
        if (StringUtil.isNullOrEmpty((String)this.dnsNameInternal)) {
            return NO_DATA;
        }
        return this.dnsNameInternal;
    }

    public String getGuestFullName() {
        return StringUtil.isNullOrEmpty((String)this.guestFullNameFromGuestInfo) ? this.guestFullNameFromConfigInfo : this.guestFullNameFromGuestInfo;
    }

    public String getVmVersion() {
        if (StringUtil.isNullOrEmpty((String)this.hwVersion)) {
            return null;
        }
        return Util.getLocalizedString("VmHardware.HWVersion.long." + this.hwVersion);
    }

    public String getToolsStatus() {
        if (StringUtil.isNullOrEmpty((String)this.detailedToolsVersionStatus)) {
            return "";
        }
        String[] toolsVersionData = this.detailedToolsVersionStatus.trim().split(VM_TOOLS_STATUS_VERSION_DELIMITER);
        String toolsVersionStatus2 = toolsVersionData[0];
        String toolsVersion = null;
        if (toolsVersionData.length == 2) {
            toolsVersion = toolsVersionData[1];
        }
        if (GUEST_TOOLS_NOT_RUNNING.equals(this.toolsRunningStatus) && (toolsVersionStatus2 == null || GUEST_TOOLS_NOT_INSTALLED.equals(toolsVersionStatus2))) {
            return Util.getLocalizedString("guestToolsNotRunningNotInstalled");
        }
        String localizedDetailedToolsVersion = this.localizeDetailedToolsVersionStatus(toolsVersionStatus2, toolsVersion);
        String result = String.format(Util.getLocalizedString(this.toolsRunningStatus), localizedDetailedToolsVersion);
        return result;
    }

    private String localizeDetailedToolsVersionStatus(String toolsVersionStatus2, String toolsVersion) {
        String result = this.formatToolsStateLabel(toolsVersionStatus2);
        if (!StringUtil.isNullOrEmpty((String)toolsVersion)) {
            result = String.format(Util.getLocalizedString("detailedToolsVersionStatus"), toolsVersion, result);
        }
        return result;
    }

    private String formatToolsStateLabel(String toolsStatus) {
        if (StringUtil.isNullOrEmpty((String)toolsStatus)) {
            return "";
        }
        return Util.getLocalizedString(VM_TOOLS_STATE_PREFIX + toolsStatus + ".text");
    }
}

