/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.actions;

import com.vmware.opsmgmt.client.extension.alarms.actions.AlarmActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionGroup;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionGroupBuilder;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionGroupFactory {
    private Log _logger = LogFactory.getLog(ActionGroupFactory.class);

    public List<ActionGroup> build(AlarmActionWrapper wrapper, Map<ManagedObjectReference, String> objectNames) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{wrapper, objectNames});
        ArrayList<ActionGroup> result = new ArrayList<ActionGroup>();
        ActionGroupBuilder agb = new ActionGroupBuilder();
        for (AlarmTriggeringAction ata : wrapper.getAlarmTrigeringActions()) {
            if (agb.isSupported(ata.action)) {
                result.addAll(agb.build(ata, objectNames));
                continue;
            }
            this._logger.error((Object)("Alarm builder not found for: " + ata));
        }
        return result;
    }
}

