/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.configuration;

import com.google.common.base.Joiner;
import com.vmware.opsmgmt.client.extension.alarms.configuration.DefaultTrigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.MetricTrigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.StateTrigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.Trigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.TriggerGroup;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="alarmConfiguration")
public class AlarmConfiguration {
    private static final String STATE_PATH_SEPARATOR_ESC = "\\.";
    private static final String STATE_PATH_SEPARATOR = ".";
    private List<StateTrigger> _stateTriggers;
    private List<MetricTrigger> _metricTriggers;
    private List<DefaultTrigger> _defaultTriggers;
    private List<TriggerGroup> _triggerGroups;
    private List<String> _serverCollections = new ArrayList<String>();

    public AlarmConfiguration() {
        this._stateTriggers = new ArrayList<StateTrigger>();
        this._metricTriggers = new ArrayList<MetricTrigger>();
        this._defaultTriggers = new ArrayList<DefaultTrigger>();
        this._triggerGroups = new ArrayList<TriggerGroup>();
    }

    @XmlElementWrapper(name="triggerGroups")
    @XmlElement(name="TriggerGroup")
    public void setTriggerGroups(List<TriggerGroup> triggerGroups) {
        this._triggerGroups = triggerGroups;
    }

    @XmlElementWrapper(name="stateTriggers")
    @XmlElement(name="Trigger")
    public void setStateTriggers(List<StateTrigger> stateTriggers) {
        this._stateTriggers = stateTriggers;
    }

    @XmlElementWrapper(name="metricTriggers")
    @XmlElement(name="Trigger")
    public void setMetricTriggers(List<MetricTrigger> metricTriggers) {
        this._metricTriggers = metricTriggers;
    }

    @XmlElementWrapper(name="defaultTriggers")
    @XmlElement(name="DefaultTrigger")
    public void setDefaultTriggers(List<DefaultTrigger> defaultTriggers) {
        this._defaultTriggers = defaultTriggers;
    }

    public List<StateTrigger> getStateTriggers() {
        return this._stateTriggers;
    }

    public List<MetricTrigger> getMetricTriggers() {
        return this._metricTriggers;
    }

    public List<DefaultTrigger> getDefaultTriggers() {
        return this._defaultTriggers;
    }

    public List<TriggerGroup> getTriggerGroups() {
        return this._triggerGroups;
    }

    public List<String> getServerCollection() {
        return this._serverCollections;
    }

    public StateTrigger getStateTrigger(StateAlarmExpression expression) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{expression});
        String monitorObjectType = this.stripPackageName(expression.type.getName());
        String statePath = expression.statePath;
        for (StateTrigger trigger : this._stateTriggers) {
            if (!trigger.monitorObjectType.equals(monitorObjectType) || !trigger.statePath.equals(statePath)) continue;
            return trigger;
        }
        return null;
    }

    public MetricTrigger getMetricTrigger(MetricAlarmExpression expression, String counter) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{expression});
        String counterInstance = expression.metric.instance;
        String monitorObjectType = this.stripPackageName(expression.type.getName());
        if (!StringUtil.isNullOrEmpty((String)counter)) {
            counter = counter.toLowerCase();
        }
        if (!StringUtil.isNullOrEmpty((String)counterInstance)) {
            counterInstance = counterInstance.toLowerCase();
        }
        for (MetricTrigger trigger : this._metricTriggers) {
            if (!trigger.monitorObjectType.equals(monitorObjectType) || !trigger.counter.equals(counter) || !trigger.counterInstance.equals(counterInstance)) continue;
            return trigger;
        }
        return null;
    }

    private String stripPackageName(String name) {
        return name.substring(name.lastIndexOf(STATE_PATH_SEPARATOR) + 1);
    }

    public Trigger getDefaultTrigger(String moType, int groupId) {
        if (groupId == -1) {
            TriggerGroup group = this._triggerGroups.get(0);
            groupId = group.id;
        }
        DefaultTrigger defTrigger = null;
        for (DefaultTrigger dt : this._defaultTriggers) {
            if (!dt.monitorObjectType.equals(moType) || dt.groupId != groupId) continue;
            defTrigger = dt;
            break;
        }
        if (defTrigger != null) {
            for (StateTrigger st : this._stateTriggers) {
                if (!st.nameResourceId.equals(defTrigger.triggerNameResourceId) || st.groupId != defTrigger.groupId) continue;
                return st;
            }
            for (MetricTrigger mt : this._metricTriggers) {
                if (!mt.nameResourceId.equals(defTrigger.triggerNameResourceId) || mt.groupId != defTrigger.groupId) continue;
                return mt;
            }
        }
        return null;
    }

    public List<Trigger> getTriggersByMoType(String moType) {
        ArrayList<Trigger> result = new ArrayList<Trigger>();
        for (StateTrigger st : this._stateTriggers) {
            if (!st.monitorObjectType.equals(moType)) continue;
            result.add(st);
        }
        for (MetricTrigger mt : this._metricTriggers) {
            if (!mt.monitorObjectType.equals(moType)) continue;
            result.add(mt);
        }
        return result;
    }

    public List<MetricTrigger> getMetricTriggersByMoType(String moType) {
        ArrayList<MetricTrigger> result = new ArrayList<MetricTrigger>();
        for (MetricTrigger mt : this._metricTriggers) {
            if (!mt.monitorObjectType.equals(moType)) continue;
            result.add(mt);
        }
        return result;
    }

    public List<StateTrigger> getStateTriggersByMoType(String moType) {
        ArrayList<StateTrigger> result = new ArrayList<StateTrigger>();
        for (StateTrigger st : this._stateTriggers) {
            if (!st.monitorObjectType.equals(moType)) continue;
            result.add(st);
        }
        return result;
    }

    private void processStateTrigger(StateTrigger trigger) {
        String serverCollection;
        Object[] properties = trigger.statePath.split(STATE_PATH_SEPARATOR_ESC);
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            if ((property = this.lowerFirstLetter(property)).charAt(property.length() - 1) == '_') {
                property = property.substring(0, property.length() - 1);
            }
            properties[i] = property;
        }
        trigger.statePath = Joiner.on((String)STATE_PATH_SEPARATOR).join(properties);
        trigger.states.serverCollection = serverCollection = this.lowerFirstLetter(trigger.states.serverCollection);
        if (serverCollection != null && !serverCollection.isEmpty()) {
            this._serverCollections.add(serverCollection);
        }
    }

    private String lowerFirstLetter(String word) {
        if (StringUtil.isNullOrEmpty((String)word)) {
            return word;
        }
        if (word.length() == 1) {
            return word.toLowerCase();
        }
        return word.substring(0, 1).toLowerCase() + word.substring(1);
    }

    private void processMetricTrigger(MetricTrigger trigger) {
        trigger.counter = trigger.counter.toLowerCase();
        if (!StringUtil.isNullOrEmpty((String)trigger.counterInstance)) {
            trigger.counterInstance = trigger.counterInstance.toLowerCase();
        }
    }

    private TriggerGroup getTriggerGroup(int groupId) {
        for (TriggerGroup group : this._triggerGroups) {
            if (group.id != groupId) continue;
            return group;
        }
        return null;
    }

    public void process() {
        this._serverCollections.clear();
        for (StateTrigger st : this._stateTriggers) {
            this.processStateTrigger(st);
        }
        for (MetricTrigger mt : this._metricTriggers) {
            this.processMetricTrigger(mt);
        }
    }
}

