/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ActionWrapper {
    private static String LOWER_RES_KEY_EXTENSION = ".lower";
    protected AlarmTriggeringAction _action;
    protected String _title;
    protected String _titleLower;

    public ActionWrapper(AlarmTriggeringAction action, String titleKey) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{action, titleKey});
        this._action = action;
        this._title = Localization.getVpxString(titleKey);
        this._titleLower = Localization.getVpxString(titleKey + LOWER_RES_KEY_EXTENSION);
    }

    public AlarmTriggeringAction getAction() {
        return this._action;
    }

    public List<ActionConfigDescription> getConfiguration() {
        return Collections.emptyList();
    }

    public void setConfiguration(List<ActionConfigDescription> conf) {
    }

    public String getConfigString() {
        return "";
    }

    public void setConfigString(String config) {
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String value) {
        this._title = value;
    }

    public String getTitleLower() {
        return this._titleLower;
    }

    public AlarmTriggeringAction.TransitionSpec getGreenToYellow() {
        return this.getTransitionForStates(ManagedEntity.Status.green, ManagedEntity.Status.yellow);
    }

    public void setGreenToYellow(AlarmTriggeringAction.TransitionSpec spec) {
        AlarmTriggeringAction.TransitionSpec oldSpec = this.getGreenToYellow();
        this.updateTransitionSpec(spec, oldSpec);
    }

    public AlarmTriggeringAction.TransitionSpec getYellowToRed() {
        return this.getTransitionForStates(ManagedEntity.Status.yellow, ManagedEntity.Status.red);
    }

    public void setYellowToRed(AlarmTriggeringAction.TransitionSpec spec) {
        AlarmTriggeringAction.TransitionSpec oldSpec = this.getYellowToRed();
        this.updateTransitionSpec(spec, oldSpec);
    }

    public AlarmTriggeringAction.TransitionSpec getRedToYellow() {
        return this.getTransitionForStates(ManagedEntity.Status.red, ManagedEntity.Status.yellow);
    }

    public void setRedToYellow(AlarmTriggeringAction.TransitionSpec spec) {
        AlarmTriggeringAction.TransitionSpec oldSpec = this.getRedToYellow();
        this.updateTransitionSpec(spec, oldSpec);
    }

    public AlarmTriggeringAction.TransitionSpec getYellowToGreen() {
        return this.getTransitionForStates(ManagedEntity.Status.yellow, ManagedEntity.Status.green);
    }

    public void setYellowToGreen(AlarmTriggeringAction.TransitionSpec spec) {
        AlarmTriggeringAction.TransitionSpec oldSpec = this.getYellowToGreen();
        this.updateTransitionSpec(spec, oldSpec);
    }

    public String validateConfigString(String config) {
        return "";
    }

    public boolean supportsConfiguration() {
        return false;
    }

    public String validateConfiguration() {
        if (this.isAllSpecsEmpty()) {
            return Localization.getString("actionWrapper.transitionspec.is.emtpty");
        }
        return this.validateConfigurationInternal();
    }

    protected String validateConfigurationInternal() {
        return "";
    }

    private boolean isAllSpecsEmpty() {
        return this.getGreenToYellow() == null && this.getYellowToRed() == null && this.getRedToYellow() == null && this.getYellowToGreen() == null;
    }

    private void updateTransitionSpec(AlarmTriggeringAction.TransitionSpec newSpec, AlarmTriggeringAction.TransitionSpec oldSpec) {
        if (this._action.transitionSpecs == null) {
            this._action.transitionSpecs = new AlarmTriggeringAction.TransitionSpec[]{newSpec};
            return;
        }
        int index = -1;
        for (int i = 0; i < this._action.transitionSpecs.length; ++i) {
            if (!this._action.transitionSpecs[i].equals(oldSpec)) continue;
            index = i;
            break;
        }
        if (newSpec == null) {
            if (oldSpec != null && index != -1) {
                ArrayList<AlarmTriggeringAction.TransitionSpec> tmp = new ArrayList<AlarmTriggeringAction.TransitionSpec>();
                for (int i = 0; i < this._action.transitionSpecs.length; ++i) {
                    if (i == index) continue;
                    tmp.add(this._action.transitionSpecs[i]);
                }
                this._action.transitionSpecs = tmp.toArray(new AlarmTriggeringAction.TransitionSpec[0]);
            }
            return;
        }
        if (oldSpec != null && index != -1) {
            this._action.transitionSpecs[index] = newSpec;
        }
    }

    private AlarmTriggeringAction.TransitionSpec getTransitionForStates(ManagedEntity.Status startState, ManagedEntity.Status finalState) {
        for (AlarmTriggeringAction.TransitionSpec spec : this._action.transitionSpecs) {
            if (spec == null || spec.startState != startState || spec.finalState != finalState) continue;
            return spec;
        }
        return null;
    }
}

