/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.action.MethodActionArgument;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

public class MigrateVmActionWrapper
extends ActionWrapper {
    public static final String RESOURCE_POOL = "resourcePool";
    public static final String HOST = "host";
    public static final String PRIORITY = "priority";
    private String _rpName;
    private String _hostName;
    private ManagedObjectReference _resourcePool;
    private ManagedObjectReference _host;
    private VirtualMachine.MovePriority _priority;
    private final MethodAction _migrateAction;

    public MigrateVmActionWrapper(AlarmTriggeringAction action) {
        super(action, "Alarm.AlarmHelper.MigrateVM");
        this._migrateAction = (MethodAction)action.action;
        this._resourcePool = (ManagedObjectReference)this.getArgumentValue(RESOURCE_POOL);
        this._host = (ManagedObjectReference)this.getArgumentValue(HOST);
        this._priority = (VirtualMachine.MovePriority)this.getArgumentValue(PRIORITY);
    }

    @Override
    public List<ActionConfigDescription> getConfiguration() {
        ArrayList<ActionConfigDescription> configs = new ArrayList<ActionConfigDescription>();
        ActionConfigDescription resourcePool = new ActionConfigDescription(RESOURCE_POOL, Localization.getString("action.migrate.resourcePool"), this._resourcePool, this._rpName);
        configs.add(resourcePool);
        ActionConfigDescription host = new ActionConfigDescription(HOST, Localization.getString("action.migrate.host"), this._host, this._hostName);
        configs.add(host);
        ActionConfigDescription priotity = new ActionConfigDescription(PRIORITY, Localization.getString("action.migrate.priority"), this._priority, this.getMigrationPriority());
        configs.add(priotity);
        return configs;
    }

    @Override
    public void setConfiguration(List<ActionConfigDescription> conf) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{conf});
        MethodAction migrateAction = (MethodAction)this._action.action;
        ArrayList<MethodActionArgument> arguments = new ArrayList<MethodActionArgument>();
        for (ActionConfigDescription descr : conf) {
            String propName;
            MethodActionArgument arg = new MethodActionArgument();
            arg.value = descr;
            arguments.add(arg);
            switch (propName = descr.getName()) {
                case "resourcePool": {
                    this._resourcePool = (ManagedObjectReference)descr.getValue();
                    this._rpName = descr.getLocalizedValue();
                    break;
                }
                case "host": {
                    this._host = (ManagedObjectReference)descr.getValue();
                    this._hostName = descr.getLocalizedValue();
                    break;
                }
                case "priority": {
                    this._priority = (VirtualMachine.MovePriority)descr.getValue();
                }
            }
        }
        migrateAction.argument = arguments.toArray(new MethodActionArgument[0]);
    }

    @Override
    public String getConfigString() {
        String priority = this.getMigrationPriority();
        String config = Localization.getFormattedString("action.migrate.config.srting", new String[]{this._rpName, this._hostName, priority});
        return config;
    }

    public ManagedObjectReference getHost() {
        return this._host;
    }

    public void setHost(ManagedObjectReference value) {
        this._host = value;
        this.setArgumentValue(HOST, value);
    }

    public String getHostName() {
        return this._hostName != null ? this._hostName : "";
    }

    public void setHostName(String value) {
        this._hostName = value;
    }

    public ManagedObjectReference getResourcePool() {
        return this._resourcePool;
    }

    public void setResourcePool(ManagedObjectReference value) {
        this._resourcePool = value;
        this.setArgumentValue(RESOURCE_POOL, value);
    }

    public String getRpName() {
        return this._rpName != null ? this._rpName : "";
    }

    public void setRpName(String value) {
        this._rpName = value;
    }

    public VirtualMachine.MovePriority getPriority() {
        return this._priority;
    }

    public void setPriority(VirtualMachine.MovePriority value) {
        this._priority = value;
        this.setArgumentValue(PRIORITY, value);
    }

    @Override
    public boolean supportsConfiguration() {
        return true;
    }

    @Override
    protected String validateConfigurationInternal() {
        if (StringUtil.isNullOrEmpty((String)this._rpName)) {
            return Localization.getString("migrateVmActionWrapper.error.configure.resource.pool");
        }
        if (StringUtil.isNullOrEmpty((String)this._hostName)) {
            return Localization.getString("migrateVmActionWrapper.error.configure.host");
        }
        String migrationPriority = this.getMigrationPriority();
        if (StringUtil.isNullOrEmpty((String)migrationPriority)) {
            return Localization.getString("migrateVmActionWrapper.error.configure.priority");
        }
        return "";
    }

    private String getMigrationPriority() {
        Object priority = this.getArgumentValue(PRIORITY);
        return this.getLocalizedMovePriority(priority);
    }

    private String getLocalizedMovePriority(Object priority) {
        String result = "";
        if (VirtualMachine.MovePriority.defaultPriority.equals(priority)) {
            result = Localization.getVpxString("VMMigration.MigrationSummaryBuilder.DefaultPriority");
        } else if (VirtualMachine.MovePriority.lowPriority.equals(priority)) {
            result = Localization.getVpxString("VMMigration.MigrationSummaryBuilder.LowPriority");
        } else if (VirtualMachine.MovePriority.highPriority.equals(priority)) {
            result = Localization.getVpxString("VMMigration.MigrationSummaryBuilder.HighPriority");
        }
        return result;
    }

    private Object getArgumentValue(String propertyName) {
        if (this._migrateAction == null || this._migrateAction.argument == null) {
            return null;
        }
        MethodActionArgument argument = null;
        switch (propertyName) {
            case "resourcePool": {
                if (this._migrateAction.argument.length <= 0) break;
                argument = this._migrateAction.argument[0];
                break;
            }
            case "host": {
                if (this._migrateAction.argument.length <= 1) break;
                argument = this._migrateAction.argument[1];
                break;
            }
            case "priority": {
                if (this._migrateAction.argument.length <= 2) break;
                argument = this._migrateAction.argument[2];
            }
        }
        return argument != null ? argument.value : null;
    }

    private void setArgumentValue(String propertyName, Object value) {
        int index = -1;
        switch (propertyName) {
            case "resourcePool": {
                index = 0;
                break;
            }
            case "host": {
                index = 1;
                break;
            }
            case "priority": {
                index = 2;
            }
        }
        if (index == -1) {
            return;
        }
        List<ActionConfigDescription> newConfiguration = this.getConfiguration();
        ActionConfigDescription descr = newConfiguration.get(index);
        descr = new ActionConfigDescription(descr.getName(), descr.getLocalizedName(), value, descr.getLocalizedValue());
        newConfiguration.set(index, descr);
        this.setConfiguration(newConfiguration);
    }
}

