/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.triggers;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.expressions.EventExpressionWrapper;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vise.util.ValidationUtil;

public class EventConditionBuilder {
    private static final String NEW_LINE = "<br />";

    public TriggerConditionGroup build(EventAlarmExpression expression, AlarmDefinitionInfo info) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{expression, info});
        EventExpressionWrapper wrapper = new EventExpressionWrapper(expression, info);
        String labelText = wrapper.getName();
        String localizedText = Localization.getVpxString(labelText);
        if (localizedText != null && localizedText.length() > 0) {
            labelText = localizedText;
        }
        String args = this.getArguments(wrapper);
        String fullLabelText = labelText + args;
        return new TriggerConditionGroup(fullLabelText, expression.status);
    }

    private String getArguments(EventExpressionWrapper wrapper) {
        EventAlarmExpression expression = wrapper.getExpression();
        if (expression.comparisons == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String key = "triggers.metric.argument";
        for (EventAlarmExpression.Comparison comparison : expression.comparisons) {
            String comparisonsAttribute = Localization.getVpxString(comparison.attributeName);
            String comparisonsValue = Localization.getVpxString(comparison.value);
            if (comparisonsAttribute == null && comparisonsAttribute.length() == 0) {
                comparisonsAttribute = wrapper.getAttributeName(comparison.attributeName);
            }
            if (comparisonsValue == null && comparisonsValue.length() == 0) {
                comparisonsValue = comparison.value;
            }
            String[] args = new String[]{comparisonsAttribute, wrapper.getOperator(comparison.operator), comparisonsValue};
            sb.append(NEW_LINE + Localization.getFormattedString(key, args));
        }
        return sb.toString();
    }
}

