/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.datacenter.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.IpPoolManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.vApp.IpPool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.datacenter.DatacenterInfo;
import com.vmware.vsphere.client.datacenter.IpPoolRemovalSpec;
import com.vmware.vsphere.client.datacenter.IpPoolUpdateSpec;
import com.vmware.vsphere.client.datacenter.util.DatacenterUtil;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatacenterMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DatacenterMutationProvider.class);
    private DataService _dataService;

    public DatacenterMutationProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public OperationResult add(DatacenterInfo spec) {
        Validate.notNull((Object)((Object)spec));
        Validate.notNull((Object)spec.name);
        OperationResult opResult = new OperationResult();
        try {
            Folder folder = this.getParent(spec);
            String escapedName = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name);
            ManagedObjectReference newDatacenter = folder.createDatacenter(escapedName);
            opResult.entity = spec.parent;
            opResult.result = newDatacenter;
            QueryUtil.waitUntilSearchable((DataService)this._dataService, (Object)newDatacenter, (String[])new String[]{"parent"});
        }
        catch (Exception e) {
            _logger.error((Object)"Error when creating datacenter", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference dcRef, IpPoolRemovalSpec spec) {
        if (dcRef == null) {
            throw new IllegalArgumentException("Datacenter reference cannot be null");
        }
        if (spec == null) {
            throw new IllegalArgumentException("IpPoolRemovalSpec cannot be null");
        }
        OperationResult result = new OperationResult();
        result.entity = dcRef;
        try {
            String serviceGuid = dcRef.getServerGuid();
            VcService vcService = VimSessionUtil.getService((String)serviceGuid);
            ServiceInstanceContent content = vcService.getServiceInstanceContent();
            ManagedObjectReference managerRef = content.getIpPoolManager();
            IpPoolManager manager = (IpPoolManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
            manager.destroyIpPool(dcRef, spec.ipPoolId, spec.useForce);
        }
        catch (Exception e) {
            _logger.error((Object)("Could not destroy the ipPool with id " + spec.ipPoolId + " in datacenter " + ManagedObjectUtil.morefToString((ManagedObjectReference)dcRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference ref, IpPoolUpdateSpec spec) {
        ManagedObjectReference dcRef = DatacenterUtil.getDc(this._dataService, ref);
        if (dcRef == null) {
            throw new IllegalArgumentException("Datacenter reference cannot be null");
        }
        if (spec == null) {
            throw new IllegalArgumentException("IpPoolUpdateSpec cannot be null");
        }
        OperationResult result = new OperationResult();
        result.entity = dcRef;
        try {
            String serviceGuid = dcRef.getServerGuid();
            VcService vcService = VimSessionUtil.getService((String)serviceGuid);
            ServiceInstanceContent content = vcService.getServiceInstanceContent();
            ManagedObjectReference managerRef = content.getIpPoolManager();
            IpPoolManager manager = (IpPoolManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
            if (spec.action == IpPoolUpdateSpec.IpPoolUpdateAction.update) {
                manager.updateIpPool(dcRef, spec.ipPool);
            } else if (spec.action == IpPoolUpdateSpec.IpPoolUpdateAction.create) {
                manager.createIpPool(dcRef, spec.ipPool);
            }
            Object[] associations = spec.ipPool.networkAssociation;
            if (!ArrayUtil.isNullOrEmpty((Object[])associations)) {
                ArrayList<ManagedObjectReference> affectedEntities = new ArrayList<ManagedObjectReference>();
                for (Object assoc : associations) {
                    ManagedObjectReference network = ((IpPool.Association)assoc).network;
                    affectedEntities.add(network);
                }
                OperationEffect effect = new OperationEffect();
                effect.affectedEntites = affectedEntities.toArray();
                result.effect = effect;
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Could not " + (spec.action == IpPoolUpdateSpec.IpPoolUpdateAction.create ? "create" : "update") + " the ipPool " + spec.ipPool.name + " in datacenter " + ManagedObjectUtil.morefToString((ManagedObjectReference)dcRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    private Folder getParent(DatacenterInfo dInfo) throws Exception {
        TypeName[] childTypes;
        Folder folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dInfo.parent);
        String errorMessage = null;
        if (folder == null) {
            errorMessage = DatacenterUtil.getLocalizedString("error.invalidDatacenterParent");
            throw new IllegalArgumentException(errorMessage);
        }
        Boolean dcSupported = false;
        for (TypeName childType : childTypes = folder.getChildType()) {
            if (childType.getName() != Datacenter.class.getName()) continue;
            dcSupported = true;
            break;
        }
        if (!dcSupported.booleanValue()) {
            errorMessage = DatacenterUtil.getLocalizedString("error.invalidDatacenterParent");
            throw new IllegalArgumentException(errorMessage);
        }
        return folder;
    }
}

