/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.model;

import com.vmware.cis.data.model.Property;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceMeterData;
import com.vmware.vsphere.client.commonservice.util.Util;

public abstract class ProviderSummaryData
extends BaseSummaryData
implements ResourceMeterData {
    @Property(value="ProviderSummaryData/usedCpuCapacity")
    private long cpuUsageMhz;
    @Property(value="ProviderSummaryData/totalCpuCapacity")
    private long cpuTotalMhz;
    @Property(value="ProviderSummaryData/usedMemoryCapacity")
    private long memoryUsage;
    @Property(value="ProviderSummaryData/totalMemoryCapacity")
    private long memoryTotal;
    @Property(value="ProviderSummaryData/usedStorageCapacity")
    private long storageUsage;
    @Property(value="ProviderSummaryData/totalStorageCapacity")
    private long storageTotal;

    protected long getStorageUnit() {
        return 1L;
    }

    @Override
    public ResourceMeterData.ResourceMeter[] getResourceMeters() {
        String freeCpu = FormatUtil.getFrequencyFormatted((Number)Math.abs(this.cpuTotalMhz - this.cpuUsageMhz), (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        String usedCpu = FormatUtil.getFrequencyFormatted((Number)this.cpuUsageMhz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        String capacityCpu = FormatUtil.getFrequencyFormatted((Number)this.cpuTotalMhz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        long storageUnit = this.getStorageUnit();
        String freeMemory = FormatUtil.getStorageFormatted((Long)Math.abs(this.memoryTotal - this.memoryUsage), (long)storageUnit, (long)-1L);
        String usedMemory = FormatUtil.getStorageFormatted((Long)this.memoryUsage, (long)storageUnit, (long)-1L);
        String capacityMemory = FormatUtil.getStorageFormatted((Long)this.memoryTotal, (long)storageUnit, (long)-1L);
        String freeStorage = FormatUtil.getStorageFormatted((Long)Math.abs(this.storageTotal - this.storageUsage), (long)storageUnit, (long)-1L);
        String usedStorage = FormatUtil.getStorageFormatted((Long)this.storageUsage, (long)storageUnit, (long)-1L);
        String capacityStorage = FormatUtil.getStorageFormatted((Long)this.storageTotal, (long)storageUnit, (long)-1L);
        return new ResourceMeterData.ResourceMeter[]{new ResourceMeterData.ResourceMeter("CpuResourceDataItem.CpuLabel", freeCpu, usedCpu, capacityCpu, Util.getPercentageUsage(this.cpuUsageMhz, this.cpuTotalMhz)), new ResourceMeterData.ResourceMeter("MemoryResourceDataItem.MemoryLabel", freeMemory, usedMemory, capacityMemory, Util.getPercentageUsage(this.memoryUsage, this.memoryTotal)), new ResourceMeterData.ResourceMeter("StorageResourceDataItem.StorageLabel", freeStorage, usedStorage, capacityStorage, Util.getPercentageUsage(this.storageUsage, this.storageTotal))};
    }
}

