/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.commonservice.util;

import com.vmware.vsphere.client.commonservice.util.Util;

public class VmToolsUtil {
    public static final String GUEST_TOOLS_NA = "guestToolsNA";
    public static final String ONLY = "Only";
    public static final String PIPE = "\\|";
    public static final String GUEST_TOOLS_NOT_RUNNING = "guestToolsNotRunning";
    public static final String GUEST_TOOLS_NOT_INSTALLED = "guestToolsNotInstalled";
    public static final String GUEST_TOOLS_NOT_RUNNING_NOT_INSTALLED = "guestToolsNotRunningNotInstalled";
    public static final String DETAILED_TOOLS_VERSION_STATUS = "detailedToolsVersionStatus";
    public static final String TEXT = ".text";

    public String getVersionStatus(String runningStatus, String versionAndVendor) {
        if (VmToolsUtil.isNullOrEmpty(runningStatus)) {
            return Util.getLocalizedString(GUEST_TOOLS_NA);
        }
        if (runningStatus.equals(GUEST_TOOLS_NOT_RUNNING) && (versionAndVendor == null || versionAndVendor.startsWith(GUEST_TOOLS_NOT_INSTALLED))) {
            return Util.getLocalizedString(GUEST_TOOLS_NOT_RUNNING_NOT_INSTALLED);
        }
        String localizedDetailedToolsVersion = VmToolsUtil.getLocalizedDetailedToolsVersion(versionAndVendor);
        if (VmToolsUtil.isNullOrEmpty(localizedDetailedToolsVersion)) {
            return Util.getLocalizedString(runningStatus + ONLY);
        }
        return Util.getLocalizedString(runningStatus, localizedDetailedToolsVersion);
    }

    private static String getLocalizedDetailedToolsVersion(String versionAndVendor) {
        if (VmToolsUtil.isNullOrEmpty(versionAndVendor)) {
            return null;
        }
        String[] toolsVersionDataParts = versionAndVendor.split(PIPE);
        String version = null;
        if (toolsVersionDataParts.length > 0) {
            version = toolsVersionDataParts[0];
        }
        String vendor = null;
        if (toolsVersionDataParts.length > 1) {
            vendor = toolsVersionDataParts[1];
        }
        return VmToolsUtil.localizeDetailedToolsVersionStatus(version, vendor);
    }

    private static String localizeDetailedToolsVersionStatus(String version, String vendor) {
        if (VmToolsUtil.isNullOrEmpty(version)) {
            return vendor;
        }
        String result = Util.getLocalizedString(version + TEXT);
        if (!VmToolsUtil.isNullOrEmpty(vendor)) {
            result = Util.getLocalizedString(DETAILED_TOOLS_VERSION_STATUS, vendor, result);
        }
        return result;
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

