/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.library.h5model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.content.library.StorageBacking;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.commonservice.util.Util;
import java.util.List;

@QueryBinding(value="com.vmware.content.LibraryModel")
public class LibrarySummaryData
extends BaseSummaryData {
    @Property(value="com.vmware.content.LibraryModel/storageBackings")
    private List storageBacking;
    @Property(value="com.vmware.content.LibraryModel/libraryType.@formatted")
    private String type;
    @Property(value="com.vmware.content.LibraryModel/fileSizeInBytes.@formatted")
    private String size;
    @Property(value="com.vmware.content.LibraryModel/numberOfOther")
    private long numOfOther;
    @Property(value="com.vmware.content.LibraryModel/numberOfTemplates")
    private long numOfTemplates;
    @Property(value="com.vmware.content.LibraryModel/optimizationInfo/optimizeRemotePublishing.@formatted")
    private String optimized;
    @Property(value="com.vmware.content.LibraryModel/creationTime.@formatted")
    private String createdTime;
    @Property(value="com.vmware.content.LibraryModel/lastModifiedTime.@formatted")
    private String modifiedTime;
    @Property(value="com.vmware.content.LibraryModel/lastSyncTime.@formatted")
    private String lastSyncTime;

    @Override
    public BaseSummaryData.LabelValue[] getSummaryItems() {
        String stbType = Util.getLocalizedString("FileSystem");
        if (this.storageBacking != null && !this.storageBacking.isEmpty() && this.storageBacking.get(0) != null) {
            Object stb = this.storageBacking.get(0);
            stbType = Util.getLocalizedString(((StorageBacking)stb).getType().getEnumValue().toString());
        }
        if (this.optimized == null) {
            this.optimized = Util.getLocalizedString("no");
        }
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("summaryView.type", this.type), new BaseSummaryData.LabelValue("library.summaryView.backing.label", stbType), new BaseSummaryData.LabelValue("library.summaryView.fileSize", this.size), new BaseSummaryData.LabelValue("library.summaryView.numberOfItems", this.numOfOther + this.numOfTemplates), new BaseSummaryData.LabelValue("library.summaryView.optimized", this.optimized), new BaseSummaryData.LabelValue("summaryView.created", this.createdTime), new BaseSummaryData.LabelValue("summaryView.lastModified", this.modifiedTime), new BaseSummaryData.LabelValue("summaryView.lastSync", this.lastSyncTime)};
    }
}

