/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.rp.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceMeterData;
import com.vmware.vsphere.client.commonservice.util.Util;

@QueryBinding(value="ResourcePool")
public final class ResourcePoolSummaryData
extends BaseSummaryData
implements ResourceMeterData {
    @Property(value="ResourcePool/normalOrTemplateOrPrimaryFTVM/length")
    private int directVmsCount;
    @Property(value="ResourcePool/normalOrTemplateOrPrimaryFTDescendantVM/length")
    private int totalVmsCount;
    @Property(value="ResourcePool/poweredOnNormalOrPrimaryFTVM/length")
    private int directPoweredOnVmsCount;
    @Relationship(value={"ResourcePool/descendantRp"})
    @Property(value="ResourcePool/poweredOnNormalOrPrimaryFTVM/length")
    private int[] descendantResPoolsPoweredOnVms;
    @Relationship(value={"ResourcePool/descendantVApp"})
    @Property(value="VirtualApp/poweredOnNormalOrPrimaryFTVM/length")
    private int[] descendantVAppsPoweredOnVms;
    @Property(value="ResourcePool/rpsLength")
    private int directResourcePoolsCount;
    @Property(value="ResourcePool/descendantRp/length")
    private int totalResourcePoolsCount;
    @Property(value="ResourcePool/vAppLength")
    private int directVAppsCount;
    @Property(value="ResourcePool/descendantVApp/length")
    private int totalVAppsCount;
    @Property(value="ResourcePool/runtime/cpu/unreservedForVm")
    private long cpuAvailableReservationMHz;
    @Property(value="ResourcePool/runtime/cpu/reservationUsed")
    private long cpuUsedReservationMHz;
    @Property(value="ResourcePool/runtime/memory/unreservedForVm")
    private long memAvailableReservationB;
    @Property(value="ResourcePool/runtime/memory/reservationUsed")
    private long memUsedReservationB;

    @Override
    public BaseSummaryData.LabelValue[] getSummaryItems() {
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("", ResourceUtil.getString((String)Util.H5_COMMON_SERVICE_STRINGS, (String)"rpSummary.properties.thisPoolAndDescendantsLabel", (ClassLoader)ResourcePoolSummaryData.class.getClassLoader())), new BaseSummaryData.LabelValue("rpSummary.properties.vmsAndTemplatesLabel", ResourcePoolSummaryData.propValueFormat(this.directVmsCount, this.totalVmsCount)), new BaseSummaryData.LabelValue("rpSummary.properties.poweredOnVmsLabel", ResourcePoolSummaryData.propValueFormat(this.directPoweredOnVmsCount, this.getTotalDescendantPoweredOnVmsCount())), new BaseSummaryData.LabelValue("rpSummary.properties.childResPoolsLabel", ResourcePoolSummaryData.propValueFormat(this.directResourcePoolsCount, this.totalResourcePoolsCount)), new BaseSummaryData.LabelValue("rpSummary.properties.childVAppsLabel", ResourcePoolSummaryData.propValueFormat(this.directVAppsCount, this.totalVAppsCount))};
    }

    @Override
    public ResourceMeterData.ResourceMeter[] getResourceMeters() {
        String freeCpu = FormatUtil.getFrequencyFormatted((Number)this.cpuAvailableReservationMHz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        String usedCpu = FormatUtil.getFrequencyFormatted((Number)this.cpuUsedReservationMHz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        long cpuTotalMhz = this.cpuAvailableReservationMHz + this.cpuUsedReservationMHz;
        String capacityCpu = FormatUtil.getFrequencyFormatted((Number)cpuTotalMhz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        String freeMemory = FormatUtil.getStorageFormatted((Long)this.memAvailableReservationB, (long)1L, (long)-1L);
        String usedMemory = FormatUtil.getStorageFormatted((Long)this.memUsedReservationB, (long)1L, (long)-1L);
        long memoryTotalB = this.memAvailableReservationB + this.memUsedReservationB;
        String capacityMemory = FormatUtil.getStorageFormatted((Long)memoryTotalB, (long)1L, (long)-1L);
        return new ResourceMeterData.ResourceMeter[]{new ResourceMeterData.ResourceMeter("CpuResourceDataItem.CpuLabel", freeCpu, usedCpu, capacityCpu, Util.getPercentageUsage(this.cpuUsedReservationMHz, cpuTotalMhz)), new ResourceMeterData.ResourceMeter("MemoryResourceDataItem.MemoryLabel", freeMemory, usedMemory, capacityMemory, Util.getPercentageUsage(this.memUsedReservationB, memoryTotalB))};
    }

    public int getTotalDescendantPoweredOnVmsCount() {
        int totalPoweredOnVmsCount = this.directPoweredOnVmsCount;
        if (this.descendantResPoolsPoweredOnVms != null) {
            for (int poweredOnVmsInChildRP : this.descendantResPoolsPoweredOnVms) {
                totalPoweredOnVmsCount += poweredOnVmsInChildRP;
            }
        }
        if (this.descendantVAppsPoweredOnVms != null) {
            for (int poweredOnVmsInChildVApp : this.descendantVAppsPoweredOnVms) {
                totalPoweredOnVmsCount += poweredOnVmsInChildVApp;
            }
        }
        return totalPoweredOnVmsCount;
    }

    private static String propValueFormat(int thisPool, int total) {
        return ResourceUtil.getString((String)Util.H5_COMMON_SERVICE_STRINGS, (String)"rpSummary.properties.thisPoolAndDescendantsValuesFormat", (String[])new String[]{String.valueOf(thisPool), String.valueOf(total)}, (ClassLoader)ResourcePoolSummaryData.class.getClassLoader());
    }
}

