/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cimmonitor.http.impl;

import com.vmware.vim.cimmonitor.http.HttpClientBuilder;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vise.vim.commons.mks.util.SslThumbprintVerifier;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;

public class CimHttpClientBuilder
implements HttpClientBuilder {
    private static final Log _logger = LogFactory.getLog(CimHttpClientBuilder.class);
    private String _schemeName;
    private int _schemePort;
    private String _thumbprint;
    private KeyStore _keyStore;

    @Override
    public void setSchemeName(String name) {
        this._schemeName = name;
    }

    @Override
    public void setSchemePort(int port) {
        this._schemePort = port;
    }

    @Override
    public void setThumbprint(String thumbprint) {
        this._thumbprint = thumbprint;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this._keyStore = keyStore;
    }

    @Override
    public HttpClient getHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        SSLSocketFactory factory = this.getSSLSocketFactory();
        Scheme scheme = new Scheme(this._schemeName, (SocketFactory)factory, this._schemePort);
        client.getConnectionManager().getSchemeRegistry().register(scheme);
        return client;
    }

    private SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            ThumbprintTrustManager trustManager = null;
            if (this._keyStore != null) {
                trustManager = new ThumbprintTrustManager(this._keyStore, null);
            } else {
                SslThumbprintVerifier thumbVerifier = new SslThumbprintVerifier();
                thumbVerifier.setThumbprint(this._thumbprint);
                trustManager = new ThumbprintTrustManager(null, (ThumbprintVerifier)thumbVerifier);
            }
            context.init(null, new TrustManager[]{trustManager}, null);
            SSLSocketFactory factory = new SSLSocketFactory(context);
            factory.setHostnameVerifier((X509HostnameVerifier)new ThumbprintTrustManager.HostnameVerifier(trustManager));
            return factory;
        }
        catch (GeneralSecurityException exception) {
            _logger.error((Object)"Failure in initializing SecurityContext.", (Throwable)exception);
            throw new IllegalStateException(exception.getMessage());
        }
    }
}

