/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cimmonitor.http.impl;

import com.vmware.cis.common.sso.SsoOverRestHelper;
import com.vmware.cis.common.sso.SsoOverRestRequest;
import com.vmware.vim.cimmonitor.http.CimHttpGetBuilder;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class DefaultCimHttpGetBuilder
implements CimHttpGetBuilder {
    private static final Log _logger = LogFactory.getLog(DefaultCimHttpGetBuilder.class);
    private static final String PARAM_SOCKET_TIMEOUT = "http.socket.timeout";
    private static final Integer SOCKET_TIMEOUT_MILLIS = new Integer(30000);
    private URL _serviceUrl;
    private String _hostId;
    private String _vcSessionId;
    private String _operation;
    private SsoService _ssoService;

    @Override
    public void setServiceUrl(URL serviceUrl) {
        this._serviceUrl = serviceUrl;
    }

    @Override
    public void setHostId(String hostId) {
        this._hostId = hostId;
    }

    @Override
    public void setVcSessionId(String vcSessionId) {
        this._vcSessionId = vcSessionId;
    }

    @Override
    public void setOperation(String operation) {
        this._operation = operation;
    }

    @Override
    public void setSsoService(SsoService ssoService) {
        this._ssoService = ssoService;
    }

    @Override
    public HttpGet getHttpGet() {
        URI requestUri = null;
        try {
            requestUri = this.buildRequestUri();
        }
        catch (URISyntaxException e) {
            _logger.error((Object)"Failed to build CIM request URI.", (Throwable)e);
            return null;
        }
        HttpGet method = new HttpGet(requestUri);
        method.getParams().setParameter(PARAM_SOCKET_TIMEOUT, (Object)SOCKET_TIMEOUT_MILLIS);
        Map<String, String> headers = this.getAuthHeaders(method);
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                method.setHeader(e.getKey(), e.getValue());
            }
        }
        return method;
    }

    private URI buildRequestUri() throws URISyntaxException {
        if (this._serviceUrl == null) {
            throw new URISyntaxException("_serviceUrl", "Service URL is not set.");
        }
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        if (this._hostId != null) {
            parameters.add(new BasicNameValuePair("host", this._hostId));
        }
        if (this._vcSessionId != null) {
            parameters.add(new BasicNameValuePair("vcSessionId", this._vcSessionId));
        }
        if (this._operation != null) {
            parameters.add(new BasicNameValuePair("op", this._operation));
        }
        String query = URLEncodedUtils.format(parameters, (String)"UTF-8");
        URI requestUri = new URI(this._serviceUrl.getProtocol(), this._serviceUrl.getUserInfo(), this._serviceUrl.getHost(), this._serviceUrl.getPort(), this._serviceUrl.getPath(), query, null);
        _logger.debug((Object)("CIM request URI: " + requestUri.toString()));
        return requestUri;
    }

    private Map<String, String> getAuthHeaders(HttpGet httpGet) {
        if (this._ssoService == null) {
            return null;
        }
        try {
            SsoOverRestRequest req = new SsoOverRestRequest(httpGet);
            PrivateKey key = this._ssoService.getHokPrivateKey();
            Map authHeaders = SsoOverRestHelper.calcAuthHeader((SsoOverRestRequest)req, (PrivateKey)key, (SamlToken)AuthSessionUtil.getSsoToken(), (int)1024);
            return authHeaders;
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to get authentication headers.", (Throwable)e);
            return null;
        }
    }
}

