/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cimmonitor.cimdataadapter.impl;

import com.vmware.vim.binding.vim.host.BIOSInfo;
import com.vmware.vim.binding.vim.host.HealthStatusSystem;
import com.vmware.vim.binding.vim.host.NumericSensorInfo;
import com.vmware.vim.binding.vim.host.SystemEventInfo;
import com.vmware.vim.binding.vim.host.SystemIdentificationInfo;
import com.vmware.vim.binding.vim.host.SystemInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.cimmonitor.cimdataadapter.CimData;
import com.vmware.vsphere.client.cimmonitor.cimdataadapter.utils.SensorGroup;
import com.vmware.vsphere.client.cimmonitor.util.CimMonitorUtil;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class HealthInfoToCimDataAdapter
implements CimData {
    private static String GREEN = "green";
    private static String YELLOW = "yellow";
    private static String RED = "red";
    public static final int CIM_HEALTH_STATE_UNKNOWN = 0;
    public static final int CIM_HEALTH_STATE_OK = 5;
    public static final int CIM_HEALTH_STATE_WARNING = 10;
    public static final int CIM_HEALTH_STATE_FAILURE = 15;
    private static final String HOST_NAME = "name";
    private static final String HOST_HW_SENSORS = "runtime.healthSystemRuntime.systemHealthInfo.numericSensorInfo";
    private static final String HOST_SYSTEM_INFO = "hardware.systemInfo";
    private static final String HOST_BIOS_INFO = "hardware.biosInfo";
    private static final String TAG_GROUP_NAME = "group";
    private static final String TAG_HARDWARE_HEALTH = "HardwareHealth";
    private static final String TAG_NUMERIC_SENSOR = "CIM_NumericSensor";
    private static final String TAG_HOST = "host";
    private static final String TAG_NAME_CAMEL_CASE = "Name";
    private static final String TAG_HEALTH_STATE = "HealthState";
    private static final String TAG_CURRENT_READING = "CurrentReading";
    private static final String TAG_UNIT_MODIFIER = "UnitModifier";
    private static final String TAG_BASE_UNITS = "BaseUnits";
    private static final String TAG_RATE_UNITS = "RateUnits";
    private static final String TAG_ELEMENT_NAME = "ElementName";
    private static final String TAG_CAPTION = "Caption";
    private static final String TAG_CIM_LOG_RECORD = "CIM_LogRecord";
    private static final String TAG_MESSAGE_TIMESTAMP = "MessageTimestamp";
    private static final String TAG_CIM_CHASSIS = "CIM_Chassis";
    private static final String TAG_MODEL = "Model";
    private static final String TAG_TAG = "Tag";
    private static final String TAG_SERIAL_NUMBER = "SerialNumber";
    private static final String TAG_VERSION_STRING = "VersionString";
    private static final String TAG_OTHER_IDENTIFYING_INFO = "OtherIdentifyingInfo";
    private static final String TAG_OMC_SMASH_FIRMWARE_IDENTITY = "OMC_SMASHFirmwareIdentity";
    private static final String TAG_MANUFACTURER = "Manufacturer";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_MOID = "moid";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_HEALTH_STATE = "HealthState";
    private static final String SYSTEM_BIOS = "System BIOS";
    private static final String SERVICE_TAG = "ServiceTag";
    private static final String ASSET_TAG = "AssetTag";
    private static final String CHASSIS = "Chassis";
    private static final String ASSET_TAG_REPORTING_STRING = "Asset Tag: ";
    private static final String IPMI_SEL = "IPMI SEL";
    private static final String NAME_DELIM = "---";
    private static final Log _logger = LogFactory.getLog(HealthInfoToCimDataAdapter.class);
    private QueryExecutor _queryExecutor;
    private String _hostName;
    private String _hostMoid;
    private Document _cimXmlDocument;
    private NumericSensorInfo[] _hostNumericSensors;
    private SystemEventInfo[] _hostSystemEventInfo;
    private SystemInfo _systemInfo;
    private BIOSInfo _biosInfo;

    @Override
    public String getData(ManagedObjectReference host) {
        this.initHostInfo(host);
        this.createCimXMLReport();
        return this.getStringFromDoc();
    }

    public void setQueryExecutor(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    private void createXmlDocument() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this._cimXmlDocument = docBuilder.newDocument();
        }
        catch (ParserConfigurationException excp) {
            _logger.error((Object)("Unable to create XML document " + excp));
        }
    }

    private Element createElement(String name) {
        return this._cimXmlDocument.createElement(name);
    }

    private Element createElement(String name, String text) {
        Element element = this.createElement(name);
        element.setTextContent(text);
        return element;
    }

    private String getStringFromDoc() {
        if (this._cimXmlDocument == null) {
            return "";
        }
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)this._cimXmlDocument.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        String cimXML = lsSerializer.writeToString(this._cimXmlDocument);
        return cimXML;
    }

    void initSystemEventInfo(ManagedObjectReference hostRef) {
        try {
            HealthStatusSystem hss = CimMonitorUtil.getHealthStatusSystem(hostRef);
            this._hostSystemEventInfo = hss.FetchSystemEventLog();
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to get system event info. ", (Throwable)e);
        }
    }

    private void initHostInfo(ManagedObjectReference hostRef) {
        try {
            this._hostMoid = null;
            this._hostName = null;
            this._hostNumericSensors = null;
            this._cimXmlDocument = null;
            this._hostSystemEventInfo = null;
            this._systemInfo = null;
            this._biosInfo = null;
            PropertyValue[] pvs = this._queryExecutor.getProperties((Object)hostRef, new String[]{"name", HOST_HW_SENSORS, HOST_SYSTEM_INFO, HOST_BIOS_INFO});
            this._hostMoid = hostRef.getValue();
            for (PropertyValue pv : pvs) {
                if (pv.propertyName == "name") {
                    this._hostName = (String)pv.value;
                    continue;
                }
                if (pv.propertyName == HOST_HW_SENSORS) {
                    this._hostNumericSensors = (NumericSensorInfo[])pv.value;
                    continue;
                }
                if (pv.propertyName == HOST_SYSTEM_INFO) {
                    this._systemInfo = (SystemInfo)pv.value;
                    continue;
                }
                if (pv.propertyName != HOST_BIOS_INFO) continue;
                this._biosInfo = (BIOSInfo)pv.value;
            }
            this.initSystemEventInfo(hostRef);
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to get numeric sensors. ", (Throwable)e);
        }
    }

    private int getHealthStateNumericValue(NumericSensorInfo sensor) {
        if (sensor == null || sensor.getHealthState() == null || sensor.getHealthState().getKey() == null) {
            return 0;
        }
        String healthState = sensor.getHealthState().getKey();
        if (healthState.equalsIgnoreCase(GREEN)) {
            return 5;
        }
        if (healthState.equalsIgnoreCase(YELLOW)) {
            return 10;
        }
        if (healthState.equalsIgnoreCase(RED)) {
            return 15;
        }
        return 0;
    }

    private Integer compareHealthState(Integer parent, Integer child) {
        if (parent == null) {
            return child;
        }
        if (child == null) {
            return parent;
        }
        if (child == 0) {
            return child;
        }
        if (parent == 0 || parent >= child) {
            return parent;
        }
        return child;
    }

    private String baseUnitsToUI(String unit) {
        if (unit.equalsIgnoreCase("")) {
            return "";
        }
        if (unit.equalsIgnoreCase("degrees c")) {
            return "2";
        }
        if (unit.equalsIgnoreCase("degrees f")) {
            return "3";
        }
        if (unit.equalsIgnoreCase("degrees k")) {
            return "4";
        }
        if (unit.equalsIgnoreCase("volts")) {
            return "5";
        }
        if (unit.equalsIgnoreCase("amps")) {
            return "6";
        }
        if (unit.equalsIgnoreCase("watts")) {
            return "7";
        }
        if (unit.equalsIgnoreCase("rpm")) {
            return "19";
        }
        if (unit.equalsIgnoreCase("joules")) {
            return "8";
        }
        if (unit.equalsIgnoreCase("coulombs")) {
            return "9";
        }
        if (unit.equalsIgnoreCase("va")) {
            return "10";
        }
        if (unit.equalsIgnoreCase("percentage")) {
            return "65";
        }
        if (unit.equalsIgnoreCase("Nits")) {
            return "11";
        }
        if (unit.equalsIgnoreCase("lumen")) {
            return "12";
        }
        if (unit.equalsIgnoreCase("lux")) {
            return "13";
        }
        if (unit.equalsIgnoreCase("Candela")) {
            return "14";
        }
        if (unit.equalsIgnoreCase("kPa")) {
            return "15";
        }
        if (unit.equalsIgnoreCase("PSI")) {
            return "16";
        }
        if (unit.equalsIgnoreCase("Newton")) {
            return "17";
        }
        if (unit.equalsIgnoreCase("CFM")) {
            return "18";
        }
        if (unit.equalsIgnoreCase("Hz")) {
            return "20";
        }
        if (unit.equalsIgnoreCase("microsecond")) {
            return "";
        }
        if (unit.equalsIgnoreCase("millisecond")) {
            return "";
        }
        if (unit.equalsIgnoreCase("second")) {
            return "21";
        }
        if (unit.equalsIgnoreCase("minute")) {
            return "22";
        }
        if (unit.equalsIgnoreCase("hour")) {
            return "23";
        }
        if (unit.equalsIgnoreCase("day")) {
            return "24";
        }
        if (unit.equalsIgnoreCase("week")) {
            return "25";
        }
        if (unit.equalsIgnoreCase("mil")) {
            return "26";
        }
        if (unit.equalsIgnoreCase("inches")) {
            return "27";
        }
        if (unit.equalsIgnoreCase("feet")) {
            return "28";
        }
        if (unit.equalsIgnoreCase("cu in")) {
            return "29";
        }
        if (unit.equalsIgnoreCase("cu feet")) {
            return "30";
        }
        if (unit.equalsIgnoreCase("mm")) {
            return "";
        }
        if (unit.equalsIgnoreCase("cm")) {
            return "";
        }
        if (unit.equalsIgnoreCase("m")) {
            return "31";
        }
        if (unit.equalsIgnoreCase("cu cm")) {
            return "";
        }
        if (unit.equalsIgnoreCase("cu m")) {
            return "33";
        }
        if (unit.equalsIgnoreCase("liters")) {
            return "34";
        }
        if (unit.equalsIgnoreCase("fluid ounce")) {
            return "35";
        }
        if (unit.equalsIgnoreCase("radians")) {
            return "36";
        }
        if (unit.equalsIgnoreCase("steradians")) {
            return "37";
        }
        if (unit.equalsIgnoreCase("revolutions")) {
            return "38";
        }
        if (unit.equalsIgnoreCase("cycles")) {
            return "39";
        }
        if (unit.equalsIgnoreCase("gravities")) {
            return "40";
        }
        if (unit.equalsIgnoreCase("ounce")) {
            return "41";
        }
        if (unit.equalsIgnoreCase("pound")) {
            return "42";
        }
        if (unit.equalsIgnoreCase("ft-lb")) {
            return "43";
        }
        if (unit.equalsIgnoreCase("oz-in")) {
            return "44";
        }
        if (unit.equalsIgnoreCase("gauss")) {
            return "45";
        }
        if (unit.equalsIgnoreCase("gilberts")) {
            return "46";
        }
        if (unit.equalsIgnoreCase("henry")) {
            return "47";
        }
        if (unit.equalsIgnoreCase("millihenry")) {
            return "";
        }
        if (unit.equalsIgnoreCase("farad")) {
            return "48";
        }
        if (unit.equalsIgnoreCase("microfarad")) {
            return "";
        }
        if (unit.equalsIgnoreCase("ohms")) {
            return "49";
        }
        if (unit.equalsIgnoreCase("siemens")) {
            return "50";
        }
        if (unit.equalsIgnoreCase("mole")) {
            return "51";
        }
        if (unit.equalsIgnoreCase("becquerel")) {
            return "52";
        }
        if (unit.equalsIgnoreCase("PPM")) {
            return "53";
        }
        if (unit.equalsIgnoreCase("reserved")) {
            return "";
        }
        if (unit.equalsIgnoreCase("Decibels")) {
            return "54";
        }
        if (unit.equalsIgnoreCase("DbA")) {
            return "55";
        }
        if (unit.equalsIgnoreCase("DbC")) {
            return "56";
        }
        if (unit.equalsIgnoreCase("gray")) {
            return "57";
        }
        if (unit.equalsIgnoreCase("sievert")) {
            return "58";
        }
        if (unit.equalsIgnoreCase("color temp deg K")) {
            return "59";
        }
        if (unit.equalsIgnoreCase("bit")) {
            return "60";
        }
        if (unit.equalsIgnoreCase("kilobit")) {
            return "";
        }
        if (unit.equalsIgnoreCase("megabit")) {
            return "";
        }
        if (unit.equalsIgnoreCase("gigabit")) {
            return "";
        }
        if (unit.equalsIgnoreCase("byte")) {
            return "61";
        }
        if (unit.equalsIgnoreCase("kilobyte")) {
            return "";
        }
        if (unit.equalsIgnoreCase("megabyte")) {
            return "";
        }
        if (unit.equalsIgnoreCase("gigabyte")) {
            return "";
        }
        if (unit.equalsIgnoreCase("word")) {
            return "62";
        }
        if (unit.equalsIgnoreCase("dword")) {
            return "63";
        }
        if (unit.equalsIgnoreCase("qword")) {
            return "64";
        }
        if (unit.equalsIgnoreCase("line")) {
            return "";
        }
        if (unit.equalsIgnoreCase("hit")) {
            return "";
        }
        if (unit.equalsIgnoreCase("miss")) {
            return "";
        }
        if (unit.equalsIgnoreCase("retry")) {
            return "";
        }
        if (unit.equalsIgnoreCase("reset")) {
            return "";
        }
        if (unit.equalsIgnoreCase("overflow")) {
            return "";
        }
        if (unit.equalsIgnoreCase("underrun")) {
            return "";
        }
        if (unit.equalsIgnoreCase("collision")) {
            return "";
        }
        if (unit.equalsIgnoreCase("packets")) {
            return "";
        }
        if (unit.equalsIgnoreCase("messages")) {
            return "";
        }
        if (unit.equalsIgnoreCase("characters")) {
            return "";
        }
        if (unit.equalsIgnoreCase("error")) {
            return "";
        }
        if (unit.equalsIgnoreCase("correctable error")) {
            return "";
        }
        if (unit.equalsIgnoreCase("uncorrectable error")) {
            return "";
        }
        _logger.error((Object)("returning unknown, unexpected rateUnit value: " + unit));
        return "0";
    }

    private String rateUnitsToUI(String unit) {
        if (unit == null) {
            return "";
        }
        if (unit.equalsIgnoreCase("")) {
            return "";
        }
        if (unit.equalsIgnoreCase("per microsecond")) {
            return "1";
        }
        if (unit.equalsIgnoreCase("per millisecond")) {
            return "2";
        }
        if (unit.equalsIgnoreCase("per second")) {
            return "3";
        }
        if (unit.equalsIgnoreCase("per minute")) {
            return "4";
        }
        if (unit.equalsIgnoreCase("per hour")) {
            return "5";
        }
        if (unit.equalsIgnoreCase("per day")) {
            return "6";
        }
        if (unit.equalsIgnoreCase("per week")) {
            return "7";
        }
        if (unit.equalsIgnoreCase("per month")) {
            return "8";
        }
        if (unit.equalsIgnoreCase("per year")) {
            return "9";
        }
        return "0";
    }

    private Element createSensorElement(NumericSensorInfo sensor) {
        Element sensorElem = this.createElement(TAG_NUMERIC_SENSOR);
        sensorElem.setAttribute(ATTR_KEY, sensor.getId());
        String name = sensor.getName();
        if (name.contains(NAME_DELIM)) {
            String[] nameArr = name.split(NAME_DELIM);
            name = nameArr[0].trim();
        }
        sensorElem.appendChild(this.createElement(TAG_NAME_CAMEL_CASE, name));
        String currentHealth = Long.valueOf(this.getHealthStateNumericValue(sensor)).toString();
        sensorElem.appendChild(this.createElement("HealthState", currentHealth));
        sensorElem.appendChild(this.createElement(TAG_CURRENT_READING, Long.valueOf(sensor.getCurrentReading()).toString()));
        sensorElem.appendChild(this.createElement(TAG_UNIT_MODIFIER, Integer.valueOf(sensor.getUnitModifier()).toString()));
        sensorElem.appendChild(this.createElement(TAG_BASE_UNITS, this.baseUnitsToUI(sensor.getBaseUnits())));
        sensorElem.appendChild(this.createElement(TAG_RATE_UNITS, this.rateUnitsToUI(sensor.getRateUnits())));
        sensorElem.appendChild(this.createElement(TAG_ELEMENT_NAME, name));
        return sensorElem;
    }

    private Element createSysEventInfoElement(SystemEventInfo sysEventInfo) {
        Element sysEventElem = this.createElement(TAG_CIM_LOG_RECORD);
        sysEventElem.setAttribute(ATTR_KEY, String.valueOf(sysEventInfo.getSelType()));
        sysEventElem.appendChild(this.createElement(TAG_ELEMENT_NAME, IPMI_SEL));
        sysEventElem.appendChild(this.createElement(TAG_CAPTION, sysEventInfo.getMessage()));
        sysEventElem.appendChild(this.createElement(TAG_MESSAGE_TIMESTAMP, sysEventInfo.getWhen()));
        return sysEventElem;
    }

    private Element createSystemBoardInfoElement() {
        Element chassisInfo = this.createElement(TAG_CIM_CHASSIS);
        chassisInfo.appendChild(this.createElement(TAG_ELEMENT_NAME, CHASSIS));
        chassisInfo.appendChild(this.createElement(TAG_MODEL, this._systemInfo.getModel()));
        chassisInfo.appendChild(this.createElement(TAG_TAG, this._systemInfo.getUuid()));
        Object[] sysIdentificationInfos = this._systemInfo.getOtherIdentifyingInfo();
        if (ArrayUtils.isNotEmpty((Object[])sysIdentificationInfos)) {
            for (Object sysIdentificationInfo : sysIdentificationInfos) {
                if (((SystemIdentificationInfo)sysIdentificationInfo).identifierType.getKey().equalsIgnoreCase(SERVICE_TAG)) {
                    chassisInfo.appendChild(this.createElement(TAG_SERIAL_NUMBER, sysIdentificationInfo.getIdentifierValue()));
                    continue;
                }
                if (!((SystemIdentificationInfo)sysIdentificationInfo).identifierType.getKey().equalsIgnoreCase(ASSET_TAG)) continue;
                chassisInfo.appendChild(this.createElement(TAG_OTHER_IDENTIFYING_INFO, ASSET_TAG_REPORTING_STRING + sysIdentificationInfo.getIdentifierValue()));
            }
        }
        Element systemBoard = this.createGroupElement(SensorGroup.SYSTEMBOARD);
        systemBoard.appendChild(chassisInfo);
        return systemBoard;
    }

    private Element createBIOSInfoElement() {
        Element firmwareIdentity = this.createElement(TAG_OMC_SMASH_FIRMWARE_IDENTITY);
        firmwareIdentity.appendChild(this.createElement(TAG_NAME_CAMEL_CASE, SYSTEM_BIOS));
        firmwareIdentity.appendChild(this.createElement(TAG_ELEMENT_NAME, SYSTEM_BIOS));
        firmwareIdentity.appendChild(this.createElement(TAG_MANUFACTURER, this._biosInfo.getVendor()));
        firmwareIdentity.appendChild(this.createElement(TAG_VERSION_STRING, this._biosInfo.getBiosVersion()));
        Element biosInfo = this.createGroupElement(SensorGroup.BIOS);
        biosInfo.appendChild(firmwareIdentity);
        return biosInfo;
    }

    private Element createGroupElement(String groupName) {
        Element groupTag = this.createElement(TAG_GROUP_NAME);
        groupTag.setAttribute("name", groupName);
        return groupTag;
    }

    private Element getHostElement() {
        Element elemHost = this.createElement(TAG_HOST);
        elemHost.setAttribute("name", this._hostName);
        elemHost.setAttribute(ATTR_MOID, this._hostMoid);
        return elemHost;
    }

    private Map<String, Element> createSensorGroups() {
        TreeMap<String, Element> groups = new TreeMap<String, Element>(String.CASE_INSENSITIVE_ORDER);
        groups.put(SensorGroup.BMC, this.createGroupElement(SensorGroup.BMC));
        groups.put(SensorGroup.SEL, this.createGroupElement(SensorGroup.SEL));
        groups.put(SensorGroup.SELRECORDS, this.createGroupElement(SensorGroup.SELRECORDS));
        groups.put(SensorGroup.TEMPERATURE, this.createGroupElement(SensorGroup.TEMPERATURE));
        groups.put(SensorGroup.POWER, this.createGroupElement(SensorGroup.POWER));
        groups.put(SensorGroup.BATTERY, this.createGroupElement(SensorGroup.BATTERY));
        groups.put(SensorGroup.STORAGE, this.createGroupElement(SensorGroup.STORAGE));
        groups.put(SensorGroup.PCI, this.createGroupElement(SensorGroup.PCI));
        groups.put(SensorGroup.FAN, this.createGroupElement(SensorGroup.FAN));
        groups.put(SensorGroup.VOLTAGE, this.createGroupElement(SensorGroup.VOLTAGE));
        groups.put(SensorGroup.MEMORY, this.createGroupElement(SensorGroup.MEMORY));
        groups.put(SensorGroup.WATCHDOG, this.createGroupElement(SensorGroup.WATCHDOG));
        groups.put(SensorGroup.SOFTWARE_COMP, this.createGroupElement(SensorGroup.SOFTWARE_UI_TAG));
        groups.put(SensorGroup.PROCESSORS, this.createGroupElement(SensorGroup.PROCESSOR_UI_TAG));
        groups.put(SensorGroup.CABLE, this.createGroupElement(SensorGroup.CABLE));
        groups.put(SensorGroup.NETWORK, this.createGroupElement(SensorGroup.NETWORK));
        groups.put(SensorGroup.OTHER, this.createGroupElement(SensorGroup.OTHER));
        return groups;
    }

    private Element createNumericSensorReport() {
        Element group;
        Map<String, Element> groups = this.createSensorGroups();
        TreeMap<String, Integer> groupHealthState = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        for (NumericSensorInfo numericSensorInfo : this._hostNumericSensors) {
            String sensorGroup = numericSensorInfo.getSensorType();
            group = groups.get(sensorGroup);
            if (group == null) {
                sensorGroup = SensorGroup.OTHER;
                group = groups.get(sensorGroup);
            }
            Element sensor = this.createSensorElement(numericSensorInfo);
            group.appendChild(sensor);
            int sensorHealth = this.getHealthStateNumericValue(numericSensorInfo);
            Integer groupHealth = (Integer)groupHealthState.get(sensorGroup);
            groupHealth = this.compareHealthState(groupHealth, sensorHealth);
            groupHealthState.put(sensorGroup, groupHealth);
        }
        if (ArrayUtils.isNotEmpty((Object[])this._hostSystemEventInfo)) {
            for (NumericSensorInfo numericSensorInfo : this._hostSystemEventInfo) {
                Element sysEvenInfoElem = this.createSysEventInfoElement((SystemEventInfo)numericSensorInfo);
                group = groups.get(SensorGroup.SELRECORDS);
                group.appendChild(sysEvenInfoElem);
            }
        }
        if (this._systemInfo != null) {
            Element systemBoardInfoElement = this.createSystemBoardInfoElement();
            groups.put(SensorGroup.SYSTEMBOARD, systemBoardInfoElement);
        }
        if (this._biosInfo != null) {
            Element biosInfoElement = this.createBIOSInfoElement();
            groups.put(SensorGroup.BIOS, biosInfoElement);
        }
        Element hostElement = this.getHostElement();
        Integer hostHealth = null;
        for (String string : groups.keySet()) {
            Integer groupHealth = (Integer)groupHealthState.get(string);
            String attrHealth = groupHealth != null ? Integer.toString(groupHealth) : "";
            Element group2 = groups.get(string);
            group2.setAttribute("HealthState", attrHealth);
            hostElement.appendChild(group2);
            hostHealth = this.compareHealthState(hostHealth, groupHealth);
        }
        String hostHealthStr = hostHealth != null ? Integer.toString(hostHealth) : "";
        hostElement.setAttribute("HealthState", hostHealthStr);
        return hostElement;
    }

    private void createCimXMLReport() {
        if (ArrayUtils.isEmpty((Object[])this._hostNumericSensors) || this._hostName == null || this._hostMoid == null) {
            _logger.debug((Object)"Something went wrong getting sensor information");
            return;
        }
        this.createXmlDocument();
        if (this._cimXmlDocument == null) {
            return;
        }
        Element hostElement = this.createNumericSensorReport();
        Element hardwareHealth = this.createElement(TAG_HARDWARE_HEALTH);
        hardwareHealth.appendChild(hostElement);
        this._cimXmlDocument.appendChild(hardwareHealth);
    }
}

