/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cimmonitor.impl;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.lookup.LookupService;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMSServiceLocator {
    private static final String PRODUCT_ID = "com.vmware.vws";
    private static final String TYPE_ID = "vws.health";
    private static final String VWS_HEALTH_ENDPOINT_TYPE_ID = "vws.health";
    private static final Log _logger = LogFactory.getLog(CMSServiceLocator.class);
    private LookupService _lookupService;

    public CMSServiceLocator(LookupService ls) {
        this._lookupService = ls;
    }

    public URL getCMSUrl(String vcServerGuid) {
        ServiceRegistration.Filter filterCriteria = new ServiceRegistration.Filter();
        ServiceRegistration.ServiceType serviceType = new ServiceRegistration.ServiceType(PRODUCT_ID, "vws.health");
        filterCriteria.setServiceType(serviceType);
        Object[] services = this._lookupService.getServiceRegistrationInfos(filterCriteria);
        if (ArrayUtil.isNullOrEmpty((Object[])services)) {
            _logger.debug((Object)"vws poller url is not registered, using vc apis.");
            return null;
        }
        if (services.length > 1) {
            _logger.error((Object)"Found more than 1 vws service.");
        }
        URL result = this.getVwsHealthEndpointURL((ServiceRegistration.Info)services[0]);
        return result;
    }

    private URL getVwsHealthEndpointURL(ServiceRegistration.Info vwsService) {
        ServiceRegistration.Endpoint[] vwsEndpoints = vwsService.getServiceEndpoints();
        try {
            for (ServiceRegistration.Endpoint se : vwsEndpoints) {
                if (!"vws.health".equalsIgnoreCase(se.getEndpointType().getType())) continue;
                URI vwsURI = se.getUrl();
                _logger.debug((Object)String.format("Found vws Service from LookupService: {0}", vwsURI));
                return vwsURI.toURL();
            }
        }
        catch (MalformedURLException ex) {
            _logger.error((Object)"Failed to extract vws service enpoint url.", (Throwable)ex);
        }
        return null;
    }
}

