/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.cluster.AntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.cluster.RuleSpec;
import com.vmware.vim.binding.vim.option.ArrayUpdateSpec;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vim.storageDrs.ConfigSpec;
import com.vmware.vim.binding.vim.storageDrs.PodConfigSpec;
import com.vmware.vim.binding.vim.storageDrs.VirtualDiskAntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vim.storageDrs.VmConfigSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.dscluster.DatastoreClusterNameValidationSpec;
import com.vmware.vsphere.client.dscluster.DefaultVmAffinityValidationSpec;
import com.vmware.vsphere.client.dscluster.DsClusterValidationResult;
import com.vmware.vsphere.client.dscluster.SdrsRuleSpec;
import com.vmware.vsphere.client.dscluster.VmOverrideData;
import com.vmware.vsphere.client.dscluster.VmOverridesReconfigureSpec;
import com.vmware.vsphere.client.dscluster.services.sdrs.DatastoreClusterRecommendationSpec;
import com.vmware.vsphere.client.dscluster.util.SdrsRulesHelper;
import com.vmware.vsphere.client.dscluster.util.SdrsRulesHelperBuilder;
import com.vmware.vsphere.client.dscluster.util.Util;
import com.vmware.vsphere.client.dscluster.validation.impl.DatastoreClusterValidator;
import com.vmware.vsphere.client.dscluster.validation.impl.SdrsRuleValidator;
import com.vmware.vsphere.client.storagedrs.DatastoreClusterSpec;
import com.vmware.vsphere.client.storagedrs.rules.IntraVmAffinity;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleValidationResult;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleValidationSpec;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DsClusterMutationProvider
implements MutationProvider {
    private static final String DATASTORE_FOLDER_PROPERTY_NAME = "datastoreFolder";
    private static final String DATASTORE_CLUSTER_NAME_PROPERTY_NAME = "name";
    private static final Log _logger = LogFactory.getLog(DsClusterMutationProvider.class);
    private final DataService _dataService;
    private final TaskMonitor _taskMonitor;
    private final MutationService _mutationService;

    public DsClusterMutationProvider(DataService dataService, TaskMonitor taskMonitor, MutationService mutationService) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._mutationService = mutationService;
    }

    public OperationResult add(DatastoreClusterSpec spec) {
        OperationResult result = new OperationResult();
        try {
            Folder datastoreFolder;
            if (spec == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.nullSpec", new String[0]));
            }
            if (spec.parent == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.specParentNull", new String[0]));
            }
            result.entity = spec.parent;
            if (Datacenter.class.getSimpleName().equals(spec.parent.getType())) {
                ManagedObjectReference dsFolderMoref = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)spec.parent, (String)DATASTORE_FOLDER_PROPERTY_NAME);
                datastoreFolder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dsFolderMoref);
            } else if (Folder.class.getSimpleName().equals(spec.parent.getType())) {
                datastoreFolder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.parent);
            } else {
                throw new IllegalArgumentException(Util.getLocalizedString("error.unknownSpecParentType", new String[0]));
            }
            ManagedObjectReference newDsClusterRef = datastoreFolder.createStoragePod(spec.name);
            result.result = newDsClusterRef;
            ManagedObjectReference taskRef = this.configureSdrsForDsCluster(newDsClusterRef, spec.configSpec, spec.modify);
            TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
            if (taskInfo.error != null) {
                result.task = taskRef;
                this.removeDsCluster(newDsClusterRef);
                throw taskInfo.error;
            }
            taskRef = this.moveDatastoresToDsCluster(newDsClusterRef, spec.datastores);
            taskInfo = this._taskMonitor.monitorTask(taskRef);
            if (taskInfo.error != null) {
                result.task = taskRef;
                this.removeDsCluster(newDsClusterRef);
                throw taskInfo.error;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not create new datastore cluster.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference datastoreClusterRef, DatastoreClusterSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = datastoreClusterRef;
        try {
            if (spec.configSpec == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.nullConfigSpec", new String[0]));
            }
            MethodFault fault = this.checkDsClusterExistence(datastoreClusterRef);
            if (fault != null) {
                result.error = fault;
                return result;
            }
            ManagedObjectReference taskRef = this.configureSdrsForDsCluster(datastoreClusterRef, spec.configSpec, spec.modify);
            result.task = taskRef;
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot reconfigure datastore cluster.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult applyDeferred(ManagedObjectReference rpRef, DatastoreClusterSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        OperationResult result = new OperationResult();
        try {
            ManagedObjectReference schTaskRef = null;
            schTaskRef = scheduleSpec.scheduledTask != null ? this.editScheduleTaskForEditSdrsConfig(rpRef, spec, scheduleSpec) : this.createScheduleTaskForEditSdrsConfig(rpRef, spec, scheduleSpec);
            result.entity = schTaskRef;
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not update the scheduled task for Edit SDRS", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dsClusterRef, DatastoreClusterRecommendationSpec recommendationSpec) {
        OperationResult result = new OperationResult();
        result.entity = dsClusterRef;
        try {
            if (recommendationSpec.operation != DatastoreClusterRecommendationSpec.Operation.refresh && (recommendationSpec.keys == null || recommendationSpec.keys.length == 0)) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.dsClusterRecommSpecInvalid", new String[0]));
            }
            StorageResourceManager resMgr = Util.getStorageManager(dsClusterRef);
            switch (recommendationSpec.operation) {
                case apply: {
                    for (String key : recommendationSpec.keys) {
                        ManagedObjectReference taskRef = resMgr.applyRecommendationToPod(dsClusterRef, key);
                        TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
                        if (taskInfo.error == null) continue;
                        throw taskInfo.error;
                    }
                    break;
                }
                case cancel: {
                    if (!VcServiceUtil.isMNnextVcOrLater((String)dsClusterRef.getServerGuid())) break;
                    resMgr.cancelRecommendation(recommendationSpec.keys);
                    break;
                }
                case refresh: {
                    resMgr.refreshRecommendation(dsClusterRef);
                    OperationEffect opEffect = OperationEffect.newDelayedEffect();
                    opEffect.affectedEntites = new Object[]{dsClusterRef};
                    result.effect = opEffect;
                    break;
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)String.format("Cannot execute datastore cluster's recommendation related operation: %s", recommendationSpec.operation.toString()), (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference datastoreClusterRef, VmOverridesReconfigureSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = datastoreClusterRef;
        try {
            MethodFault fault = this.checkDsClusterExistence(datastoreClusterRef);
            if (fault != null) {
                result.error = fault;
                return result;
            }
            ConfigSpec configSpec = Util.buildSdrsConfigSpecForVmOverrides(datastoreClusterRef, this._dataService, spec);
            result.task = this.configureSdrsForDsCluster(datastoreClusterRef, configSpec, true);
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not configure sdrs for datastore cluster.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dsClusterRef, SdrsRuleSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = dsClusterRef;
        try {
            ManagedObjectReference task = null;
            MethodFault fault = this.checkDsClusterExistence(dsClusterRef);
            if (fault != null) {
                result.error = fault;
                return result;
            }
            if (spec.ruleInfo.rule instanceof AntiAffinityRuleSpec) {
                task = this.applyVmAntiAffinityRule(dsClusterRef, spec.ruleInfo.rule, spec.operation);
            } else if (spec.ruleInfo.rule instanceof VirtualDiskAntiAffinityRuleSpec) {
                ManagedObjectReference vm = spec.ruleInfo.vm;
                PropertyValue[] propertiesResult = QueryUtil.getProperties((DataService)this._dataService, (Object)dsClusterRef, (String[])new String[]{"podStorageDrsEntry.storageDrsConfig.vmConfig"});
                VmConfigInfo vmConfigInfo = Util.getVmConfigInfo(propertiesResult, vm);
                task = this.applyVmdkAntiAffinityRule(dsClusterRef, spec, vmConfigInfo);
            }
            result.task = task;
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not configure sdrs for datastore cluster.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private ManagedObjectReference applyVmAntiAffinityRule(ManagedObjectReference datastoreClusterRef, RuleInfo spec, SdrsRuleSpec.SdrsRuleSpecOperation operation) throws Exception {
        ConfigSpec configSpec = new ConfigSpec();
        configSpec.podConfigSpec = new PodConfigSpec();
        configSpec.podConfigSpec.rule = new RuleSpec[1];
        configSpec.podConfigSpec.rule[0] = new RuleSpec();
        if (SdrsRuleSpec.SdrsRuleSpecOperation.remove == operation) {
            configSpec.podConfigSpec.rule[0].setOperation(ArrayUpdateSpec.Operation.remove);
            configSpec.podConfigSpec.rule[0].setRemoveKey((Object)spec.key);
        } else {
            configSpec.podConfigSpec.rule[0].setOperation(SdrsRuleSpec.SdrsRuleSpecOperation.apply == operation ? ArrayUpdateSpec.Operation.edit : ArrayUpdateSpec.Operation.add);
            configSpec.podConfigSpec.rule[0].setInfo(spec);
        }
        return this.configureSdrsForDsCluster(datastoreClusterRef, configSpec, true);
    }

    private ManagedObjectReference applyVmdkAntiAffinityRule(ManagedObjectReference datastoreClusterRef, SdrsRuleSpec spec, VmConfigInfo existingVmConfigInfo) throws Exception {
        ConfigSpec configSpec = new ConfigSpec();
        configSpec.vmConfigSpec = new VmConfigSpec[1];
        configSpec.vmConfigSpec[0] = new VmConfigSpec();
        configSpec.vmConfigSpec[0].setOperation(ArrayUpdateSpec.Operation.add);
        VmConfigInfo vmConfigInfo = existingVmConfigInfo;
        if (vmConfigInfo == null) {
            vmConfigInfo = new VmConfigInfo();
            vmConfigInfo.setVm(spec.ruleInfo.vm);
        }
        if (SdrsRuleSpec.SdrsRuleSpecOperation.remove == spec.operation && vmConfigInfo.enabled == null && vmConfigInfo.behavior == null && vmConfigInfo.intraVmAffinity == null) {
            configSpec.vmConfigSpec[0].setOperation(ArrayUpdateSpec.Operation.remove);
            configSpec.vmConfigSpec[0].setRemoveKey((Object)spec.ruleInfo.vm);
        } else {
            configSpec.vmConfigSpec[0].setInfo(vmConfigInfo);
            VirtualDiskAntiAffinityRuleSpec rule = null;
            if (SdrsRuleSpec.SdrsRuleSpecOperation.remove != spec.operation) {
                rule = (VirtualDiskAntiAffinityRuleSpec)spec.ruleInfo.rule;
            }
            vmConfigInfo.setIntraVmAntiAffinity(rule);
        }
        return this.configureSdrsForDsCluster(datastoreClusterRef, configSpec, true);
    }

    public ValidationResult validate(ManagedObjectReference container, DatastoreClusterNameValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = container;
        try {
            if (container == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.validation.noTargetEntitySpecified", new String[0]));
            }
            if (spec == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.validation.noNameValidationSpec", new String[0]));
            }
            if (StringUtil.isNullOrEmpty((String)spec.datastoreClusterName)) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.validation.emptyName", new String[0]));
            }
            validationResult.result = DatastoreClusterValidator.isDatastoreClusterNameUnique(this._dataService, container, spec);
        }
        catch (Exception e) {
            _logger.error((Object)"Error when validating datastore cluster name uniqueness", (Throwable)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference dsClusterRef, SdrsRuleInfo ruleInfo) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = dsClusterRef;
        try {
            ArrayList<ManagedObjectReference> relevantVms = new ArrayList<ManagedObjectReference>();
            if (ruleInfo.vm != null) {
                relevantVms.add(ruleInfo.vm);
            }
            SdrsRuleValidator sdrsRuleValidator = Util.createSdrsRuleValidator(this._dataService, dsClusterRef, relevantVms);
            validationResult.result = sdrsRuleValidator.validateRule(ruleInfo);
        }
        catch (Exception e) {
            _logger.error((Object)"Error when validating SDRS rule validity", (Throwable)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference dsClusterRef, VmOverridesReconfigureSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = dsClusterRef;
        try {
            ArrayList<ManagedObjectReference> relevantVms = new ArrayList<ManagedObjectReference>();
            ArrayList conflictingRules = new ArrayList();
            for (VmOverrideData vmOverrideData : spec.vmOverrides) {
                ManagedObjectReference vmSor = vmOverrideData.vmSor;
                if (vmSor == null) continue;
                relevantVms.add(vmSor);
            }
            SdrsRuleValidator sdrsRuleValidator = Util.createSdrsRuleValidator(this._dataService, dsClusterRef, relevantVms);
            for (VmOverrideData vmOverrideData : spec.vmOverrides) {
                SdrsRuleValidationResult validationRes = sdrsRuleValidator.validateVMDKAffinityOverride(vmOverrideData.vmSor, vmOverrideData.intraVmAffinity);
                conflictingRules.addAll(validationRes.conflictingRules);
            }
            validationResult.result = conflictingRules;
        }
        catch (Exception e) {
            _logger.error((Object)"Error when validating SDRS rule validity", (Throwable)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference dsClusterRef, SdrsRuleValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = dsClusterRef;
        try {
            SdrsRuleValidationResult theResult;
            switch (spec.targetRuleType) {
                case VM_ANTIAFFINITY_RULE_TYPE: {
                    SdrsRulesHelper validatorHelper = new SdrsRulesHelperBuilder().forDatastoreCluster(dsClusterRef).andNotPersistedVmAntiAffinityRules(spec.notPersistedVmAntiAffinityRuleInfos).andNotPersistedVmConfigInfo(spec.vmConfig).includingEnabledRulesOnly().setIsVmProvisioning().build(this._dataService);
                    SdrsRuleValidator sdrsRuleValidator = new SdrsRuleValidator(validatorHelper);
                    theResult = sdrsRuleValidator.validateRule(spec.ruleInfo);
                    break;
                }
                case VIRTUAL_DISK_ANTI_AFFINITY_RULE_TYPE: {
                    HashSet<ManagedObjectReference> vmsToResolve = new HashSet<ManagedObjectReference>();
                    if (spec.ruleInfo.vm != null) {
                        vmsToResolve.add(spec.ruleInfo.vm);
                    }
                    SdrsRulesHelper validatorHelper = new SdrsRulesHelperBuilder().forDatastoreCluster(dsClusterRef).andNotPersistedVmAntiAffinityRules(spec.notPersistedVmAntiAffinityRuleInfos).andNotPersistedVmConfigInfo(spec.vmConfig).includingEnabledRulesOnly().setIsVmProvisioning().buildAndResolveNamesForVms(this._dataService, vmsToResolve);
                    SdrsRuleValidator sdrsRuleValidator = new SdrsRuleValidator(validatorHelper);
                    theResult = sdrsRuleValidator.validateRule(spec.ruleInfo);
                    break;
                }
                case VIRTUAL_DISK_AFFINITY_RULE_TYPE: {
                    VmConfigInfo validVmConfigInfo = new VmConfigInfo();
                    validVmConfigInfo.vm = spec.vmConfig.vm;
                    validVmConfigInfo.intraVmAffinity = spec.vmConfig.intraVmAffinity;
                    if (spec.vmConfig.intraVmAntiAffinity != null && spec.vmConfig.intraVmAntiAffinity.enabled.booleanValue()) {
                        validVmConfigInfo.intraVmAntiAffinity = spec.vmConfig.intraVmAntiAffinity;
                    }
                    SdrsRulesHelper validatorHelper = new SdrsRulesHelperBuilder().forDatastoreCluster(dsClusterRef).andNotPersistedVmAntiAffinityRules(spec.notPersistedVmAntiAffinityRuleInfos).andNotPersistedVmConfigInfo(validVmConfigInfo).setIsVmProvisioning().includingEnabledRulesOnly().build(this._dataService);
                    SdrsRuleValidator sdrsRuleValidator = new SdrsRuleValidator(validatorHelper);
                    IntraVmAffinity intraVmAffinity = SdrsRulesHelper.getIntraVmAffinity(spec.vmConfig);
                    theResult = sdrsRuleValidator.validateVMDKAffinityOverride(spec.vmConfig.vm, intraVmAffinity);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Util.getLocalizedString("error.unsupportedRuleType", new String[0]));
                }
            }
            validationResult.result = theResult;
        }
        catch (Exception e) {
            _logger.error((Object)"Error when validating SDRS rule validity", (Throwable)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference dsClusterRef, DefaultVmAffinityValidationSpec vmAffSpec) {
        ValidationResult valRes = new ValidationResult();
        valRes.entity = dsClusterRef;
        try {
            DatastoreClusterValidator dscVal = Util.createDsClusterDefVmAffValidator(this._dataService, dsClusterRef);
            DsClusterValidationResult dscValRes = dscVal.validateDefVmAffinity(vmAffSpec.defaultIntraVmAffinity);
            valRes.result = dscValRes;
        }
        catch (Exception e) {
            _logger.error((Object)"Error validating ds cluster default intra vm affinity", (Throwable)e);
            valRes.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return valRes;
    }

    private ManagedObjectReference moveDatastoresToDsCluster(ManagedObjectReference dsClusterRef, ManagedObjectReference[] datastores) throws Exception {
        StoragePod dsCluster = (StoragePod)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dsClusterRef);
        return dsCluster.moveInto(datastores);
    }

    private ManagedObjectReference configureSdrsForDsCluster(ManagedObjectReference dsClusterRef, ConfigSpec spec, boolean modify) throws Exception {
        StorageResourceManager storageManager = Util.getStorageManager(dsClusterRef);
        return storageManager.configureStorageDrsForPod(dsClusterRef, spec, modify);
    }

    private void removeDsCluster(ManagedObjectReference dsClusterRef) {
        OperationResult result = this._mutationService.remove((Object)dsClusterRef, null);
        if (result.task == null) {
            _logger.error((Object)"Error when removing datastore cluster, no task started.");
            return;
        }
        ManagedObjectReference removeDsClusterTaskRef = (ManagedObjectReference)result.task;
        try {
            TaskInfo removeDsClusterTaskInfo = this._taskMonitor.monitorTask(removeDsClusterTaskRef);
            if (removeDsClusterTaskInfo.error != null) {
                _logger.error((Object)"Error when removing datastore cluster", (Throwable)removeDsClusterTaskInfo.error);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Error when removing datastore cluster", (Throwable)ex);
        }
    }

    private ManagedObjectReference createScheduleTaskForEditSdrsConfig(ManagedObjectReference dsClusterRef, DatastoreClusterSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ServiceInstanceContent serviceContent = Util.getServiceInstanceContent(dsClusterRef);
        ManagedObjectReference storageManagerRef = serviceContent.getStorageResourceManager();
        ScheduledTaskSpec vcTaskSpec = this.createEditSdrsScheduledTaskSpec(dsClusterRef, spec, scheduleSpec);
        return SchedulingUtil.createVcScheduledTaskForObject((DataService)this._dataService, (ManagedObjectReference)storageManagerRef, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ManagedObjectReference editScheduleTaskForEditSdrsConfig(ManagedObjectReference dsClusterRef, DatastoreClusterSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = this.createEditSdrsScheduledTaskSpec(dsClusterRef, spec, scheduleSpec);
        return SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ScheduledTaskSpec createEditSdrsScheduledTaskSpec(ManagedObjectReference dsClusterRef, DatastoreClusterSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        MethodAction action = SchedulingUtil.newMethodAction((String)"ConfigureStorageDrsForPod_Task", (Object[])new Object[]{dsClusterRef, spec.configSpec, spec.modify});
        vcTaskSpec.action = action;
        return vcTaskSpec;
    }

    private MethodFault checkDsClusterExistence(ManagedObjectReference dsClusterRef) throws Exception {
        MethodFault fault = null;
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)QueryUtil.createObjectIdentityConstraint((Object)dsClusterRef), (String[])new String[]{DATASTORE_CLUSTER_NAME_PROPERTY_NAME});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        if (resultSet == null || resultSet.items == null || resultSet.items.length == 0) {
            fault = new MethodFault(Util.getLocalizedString("error.dsClusterNotAvailable", new String[0]));
        }
        return fault;
    }
}

