/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.util;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.option.ArrayUpdateSpec;
import com.vmware.vim.binding.vim.storageDrs.ConfigSpec;
import com.vmware.vim.binding.vim.storageDrs.PodConfigInfo;
import com.vmware.vim.binding.vim.storageDrs.VirtualDiskAntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vim.storageDrs.VmConfigSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.dscluster.VmOverrideData;
import com.vmware.vsphere.client.dscluster.VmOverridesReconfigureSpec;
import com.vmware.vsphere.client.dscluster.util.SdrsRulesHelper;
import com.vmware.vsphere.client.dscluster.util.SdrsRulesHelperBuilder;
import com.vmware.vsphere.client.dscluster.validation.impl.DatastoreClusterValidator;
import com.vmware.vsphere.client.dscluster.validation.impl.SdrsRuleValidator;
import com.vmware.vsphere.client.storagedrs.rules.IntraVmAffinity;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    public static final String VM_NAME = "name";
    public static final String STORAGE_MGR_CONFIGURE_SDRS_FOR_POD_TASK_NAME = "ConfigureStorageDrsForPod_Task";
    public static final String SDRS_CONFIG_POD_CONFIG_DEFAULT_INTRA_VM_AFFINITY = "podStorageDrsEntry.storageDrsConfig.podConfig.defaultIntraVmAffinity";
    public static final String SDRS_CONFIG_VM_CONFIG = "podStorageDrsEntry.storageDrsConfig.vmConfig";
    public static final String SDRS_CONFIG_POD_CONFIG_RULE = "podStorageDrsEntry.storageDrsConfig.podConfig.rule";
    private static final Log _logger = LogFactory.getLog(Util.class);
    private static final String DS_CLUSTER_SERVICE_STRINGS = "dsclusterservice";

    public static String getLocalizedString(String key, String ... params) {
        return ResourceUtil.getString((String)DS_CLUSTER_SERVICE_STRINGS, (String)key, (String[])params, (ClassLoader)Util.class.getClassLoader());
    }

    public static StorageResourceManager getStorageManager(ManagedObjectReference moRef) throws Exception {
        ServiceInstanceContent serviceContent = Util.getServiceInstanceContent(moRef);
        if (serviceContent == null) {
            _logger.error((Object)"Could not retrieve ServiceInstanceContent");
            return null;
        }
        return (StorageResourceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getStorageResourceManager());
    }

    public static ServiceInstanceContent getServiceInstanceContent(ManagedObjectReference moRef) throws Exception {
        if (moRef == null) {
            _logger.error((Object)"Null moRef encountered.");
            return null;
        }
        VcService service = VimSessionUtil.getService((String)moRef.getServerGuid());
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return null;
        }
        return service.getServiceInstanceContent();
    }

    public static VmConfigInfo[] getActualVmOverridesInfos(VmConfigInfo[] vmConfigInfos) {
        LinkedList<VmConfigInfo> actualVmOverrides = new LinkedList<VmConfigInfo>();
        if (vmConfigInfos != null && vmConfigInfos.length > 0) {
            for (VmConfigInfo vmConfigInfo : vmConfigInfos) {
                if (!Util.isVmOverride(vmConfigInfo)) continue;
                actualVmOverrides.add(vmConfigInfo);
            }
        }
        return actualVmOverrides.toArray(new VmConfigInfo[actualVmOverrides.size()]);
    }

    private static boolean isVmOverride(VmConfigInfo vmConfigInfo) {
        assert (vmConfigInfo != null);
        VmOverrideData.SdrsAutomationLevel automationLevel = Util.getSdrsAutomationLevel(vmConfigInfo);
        IntraVmAffinity intraVmAffinity = Util.getIntraVmAffinity(vmConfigInfo);
        return !automationLevel.equals((Object)VmOverrideData.SdrsAutomationLevel.ClusterDefault) || !intraVmAffinity.equals((Object)IntraVmAffinity.ClusterDefault);
    }

    public static VmOverrideData.SdrsAutomationLevel getSdrsAutomationLevel(VmConfigInfo vmConfigInfo) {
        if (vmConfigInfo == null) {
            _logger.error((Object)"vmConfigInfo is null");
            throw new IllegalArgumentException("vmConfigInfo is null");
        }
        if (vmConfigInfo.enabled != null && !vmConfigInfo.enabled.booleanValue()) {
            return VmOverrideData.SdrsAutomationLevel.Disabled;
        }
        if (vmConfigInfo.behavior != null) {
            return Util.getSdrsAutomationLevel(vmConfigInfo.behavior);
        }
        return VmOverrideData.SdrsAutomationLevel.ClusterDefault;
    }

    public static VmOverrideData.SdrsAutomationLevel getSdrsAutomationLevel(String behavior) {
        if (behavior == null) {
            _logger.error((Object)"behavior is null");
            throw new IllegalArgumentException("behavior is null");
        }
        if (behavior.equals(PodConfigInfo.Behavior.automated.name())) {
            return VmOverrideData.SdrsAutomationLevel.Automated;
        }
        if (behavior.equals(PodConfigInfo.Behavior.manual.name())) {
            return VmOverrideData.SdrsAutomationLevel.Manual;
        }
        throw new IllegalArgumentException(Util.getLocalizedString("error.unknownSdrsLevel", new String[0]));
    }

    public static IntraVmAffinity getIntraVmAffinity(VmConfigInfo vmConfigInfo) {
        if (vmConfigInfo == null) {
            _logger.error((Object)"vmConfigInfo is null");
            throw new IllegalArgumentException("vmConfigInfo is null");
        }
        return Util.getIntraVmAffinity(vmConfigInfo.intraVmAffinity);
    }

    public static IntraVmAffinity getIntraVmAffinity(Boolean intraVmAffinity) {
        if (intraVmAffinity == null) {
            return IntraVmAffinity.ClusterDefault;
        }
        if (intraVmAffinity.booleanValue()) {
            return IntraVmAffinity.KeepVmdksTogether;
        }
        return IntraVmAffinity.DoNotKeepVmdksTogether;
    }

    public static ManagedObjectReference[] getVmRefsFromVmConfigInfos(VmConfigInfo[] vmConfigInfos) {
        if (vmConfigInfos == null) {
            _logger.error((Object)"vmConfigInfos array is null");
            throw new IllegalArgumentException("vmConfigInfos array is null");
        }
        if (vmConfigInfos.length == 0) {
            _logger.error((Object)"vmConfigInfos array is empty");
            throw new IllegalArgumentException("vmConfigInfos array is empty");
        }
        ManagedObjectReference[] vmRefs = new ManagedObjectReference[vmConfigInfos.length];
        int index = 0;
        for (VmConfigInfo vmInfo : vmConfigInfos) {
            vmRefs[index] = vmInfo.vm;
            ++index;
        }
        return vmRefs;
    }

    public static VmOverrideData[] buildVmOverridesData(VmConfigInfo[] vmConfigInfos, PropertyValue[] vmProperties) {
        VmOverrideData vmData;
        if (vmConfigInfos == null) {
            _logger.error((Object)"vmConfigInfos array is null");
            throw new IllegalArgumentException("vmConfigInfos array is null");
        }
        if (vmProperties == null) {
            _logger.error((Object)"vmProperties array is null");
            throw new IllegalArgumentException("vmProperties array is null");
        }
        if (vmConfigInfos.length == 0) {
            _logger.error((Object)"vmConfigInfos array is empty");
            throw new IllegalArgumentException("vmConfigInfos array is empty");
        }
        if (vmProperties.length == 0) {
            _logger.error((Object)"vmProperties array is empty");
            throw new IllegalArgumentException("vmProperties array is empty");
        }
        HashMap<ManagedObjectReference, VmOverrideData> vmDataByMor = new HashMap<ManagedObjectReference, VmOverrideData>();
        for (VmConfigInfo vmConfigInfo : vmConfigInfos) {
            vmData = new VmOverrideData();
            vmData.vmSor = vmConfigInfo.vm;
            vmDataByMor.put(vmData.vmSor, vmData);
            vmData.sdrsAutomationLevel = Util.getSdrsAutomationLevel(vmConfigInfo);
            vmData.intraVmAffinity = Util.getIntraVmAffinity(vmConfigInfo);
        }
        for (VmConfigInfo vmConfigInfo : vmProperties) {
            vmData = (VmOverrideData)((Object)vmDataByMor.get(vmConfigInfo.resourceObject));
            if (vmConfigInfo.propertyName.equals(VM_NAME)) {
                vmData.vmName = (String)vmConfigInfo.value;
            }
            if (!vmConfigInfo.propertyName.equals("ftRole")) continue;
            vmData.isPrimary = (Integer)vmConfigInfo.value == 1;
        }
        Collection vmsDataSet = vmDataByMor.values();
        return vmsDataSet.toArray(new VmOverrideData[vmsDataSet.size()]);
    }

    public static ConfigSpec buildSdrsConfigSpecForVmOverrides(ManagedObjectReference datastoreClusterRef, DataService dataService, VmOverridesReconfigureSpec vmOverridesSpec) throws Exception {
        if (vmOverridesSpec == null) {
            _logger.error((Object)"vmOverridesSpec is null");
            throw new IllegalArgumentException("vmOverridesSpec is null");
        }
        SdrsRulesHelper sdrsIntraVmRuleHelper = new SdrsRulesHelperBuilder().forDatastoreCluster(datastoreClusterRef).includingEnabledRulesOnly().build(dataService);
        VmConfigSpec[] vmConfigSpecs = new VmConfigSpec[vmOverridesSpec.vmOverrides.length];
        int index = 0;
        for (VmOverrideData vmOverride : vmOverridesSpec.vmOverrides) {
            vmConfigSpecs[index++] = Util.buildVmConfigSpecForVmOverride(vmOverride, vmOverridesSpec.operation, sdrsIntraVmRuleHelper);
        }
        ConfigSpec configSpec = new ConfigSpec();
        configSpec.vmConfigSpec = vmConfigSpecs;
        return configSpec;
    }

    public static VmConfigInfo getVmConfigInfo(PropertyValue[] propertiesResult, ManagedObjectReference vm) {
        VmConfigInfo[] vmConfig;
        if (ArrayUtil.isNullOrEmpty((Object[])propertiesResult) || !(propertiesResult[0].value instanceof VmConfigInfo[])) {
            return null;
        }
        VmConfigInfo theVmConfigInfo = null;
        for (VmConfigInfo vmConfigInfo : vmConfig = (VmConfigInfo[])propertiesResult[0].value) {
            if (vmConfigInfo == null || !ManagedObjectUtil.morefToString((ManagedObjectReference)vmConfigInfo.vm).equals(ManagedObjectUtil.morefToString((ManagedObjectReference)vm))) continue;
            theVmConfigInfo = vmConfigInfo;
            break;
        }
        return theVmConfigInfo;
    }

    public static SdrsRuleValidator createSdrsRuleValidator(DataService dataService, ManagedObjectReference dsClusterRef, Collection<ManagedObjectReference> vms) throws Exception {
        SdrsRulesHelper validatorHelper = new SdrsRulesHelperBuilder().forDatastoreCluster(dsClusterRef).includingEnabledRulesOnly().buildAndResolveNamesForVms(dataService, vms);
        SdrsRuleValidator sdrsRuleValidator = new SdrsRuleValidator(validatorHelper);
        return sdrsRuleValidator;
    }

    private static VmConfigSpec buildVmConfigSpecForVmOverride(VmOverrideData vmOverride, VmOverridesReconfigureSpec.Operation operation, SdrsRulesHelper sdrsIntraVmRuleHelper) {
        assert (vmOverride != null);
        VmConfigSpec vmConfigSpec = new VmConfigSpec();
        VmConfigInfo vmConfigInfo = sdrsIntraVmRuleHelper.getVmConfigInfo(vmOverride.vmSor);
        if (vmConfigInfo == null) {
            vmConfigInfo = new VmConfigInfo();
            vmConfigInfo.vm = vmOverride.vmSor;
        }
        vmConfigSpec.info = vmConfigInfo;
        if (operation == VmOverridesReconfigureSpec.Operation.Add) {
            vmConfigSpec.operation = ArrayUpdateSpec.Operation.add;
        } else if (operation == VmOverridesReconfigureSpec.Operation.Edit || operation == VmOverridesReconfigureSpec.Operation.Remove) {
            vmConfigSpec.operation = ArrayUpdateSpec.Operation.edit;
        }
        vmConfigSpec.operation = ArrayUpdateSpec.Operation.add;
        if (operation == VmOverridesReconfigureSpec.Operation.Remove) {
            vmConfigInfo.behavior = null;
            vmConfigInfo.enabled = null;
            vmConfigInfo.intraVmAffinity = null;
            Util.disableIntraVmAntiAffinity(vmConfigInfo.intraVmAntiAffinity);
        } else {
            if (vmOverride.sdrsAutomationLevel == VmOverrideData.SdrsAutomationLevel.Automated) {
                vmConfigInfo.behavior = PodConfigInfo.Behavior.automated.name();
                vmConfigInfo.enabled = true;
            } else if (vmOverride.sdrsAutomationLevel == VmOverrideData.SdrsAutomationLevel.Manual) {
                vmConfigInfo.behavior = PodConfigInfo.Behavior.manual.name();
                vmConfigInfo.enabled = true;
            } else if (vmOverride.sdrsAutomationLevel == VmOverrideData.SdrsAutomationLevel.Disabled) {
                vmConfigInfo.behavior = null;
                vmConfigInfo.enabled = false;
            } else if (vmOverride.sdrsAutomationLevel == VmOverrideData.SdrsAutomationLevel.ClusterDefault) {
                vmConfigInfo.behavior = null;
                vmConfigInfo.enabled = null;
            }
            if (vmOverride.intraVmAffinity == IntraVmAffinity.ClusterDefault) {
                vmConfigInfo.intraVmAffinity = null;
                Util.disableIntraVmAntiAffinity(vmConfigInfo.intraVmAntiAffinity);
            } else if (vmOverride.intraVmAffinity == IntraVmAffinity.KeepVmdksTogether) {
                vmConfigInfo.intraVmAffinity = true;
                Util.disableIntraVmAntiAffinity(vmConfigInfo.intraVmAntiAffinity);
            } else if (vmOverride.intraVmAffinity == IntraVmAffinity.DoNotKeepVmdksTogether) {
                vmConfigInfo.intraVmAffinity = false;
            } else {
                throw new IllegalArgumentException(Util.getLocalizedString("error.unknownIntraVmAffinity", new String[0]));
            }
        }
        return vmConfigSpec;
    }

    private static void disableIntraVmAntiAffinity(VirtualDiskAntiAffinityRuleSpec intraVmAntiAffinity) {
        if (intraVmAntiAffinity == null) {
            return;
        }
        intraVmAntiAffinity.enabled = false;
    }

    public static DatastoreClusterValidator createDsClusterDefVmAffValidator(DataService dataService, ManagedObjectReference dsClusterRef) throws Exception {
        SdrsRulesHelper ruleHelper = new SdrsRulesHelperBuilder().forDatastoreCluster(dsClusterRef).includingEnabledRulesOnly().build(dataService);
        DatastoreClusterValidator dscValidator = new DatastoreClusterValidator(ruleHelper);
        return dscValidator;
    }
}

