/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.impl;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseAvailabilityPropertyProvider {
    private final Log _logger = LogFactory.getLog(LicenseAvailabilityPropertyProvider.class);
    private QueryService _queryService;

    public LicenseAvailabilityPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="Folder/licenses")
    public License[] getLicenses(ManagedObjectReference vcRef) {
        License[] licenses = null;
        try {
            PropertyPredicate[] vcLicensePredicates = new PropertyPredicate[]{new PropertyPredicate("scope", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vcRef.getServerGuid()), new PropertyPredicate("licenseType", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"SERIAL_KEY")};
            ResultSet set = this._queryService.select(new String[]{"license"}).from(new String[]{"License"}).where(new Filter(Arrays.asList(vcLicensePredicates), LogicalOperator.AND)).fetch();
            ArrayList<License> licenseList = new ArrayList<License>();
            for (ResourceItem resourceItem : set.getItems()) {
                for (Object object : resourceItem.getPropertyValues()) {
                    licenseList.add((License)object);
                }
            }
            licenses = licenseList.toArray(new License[0]);
        }
        catch (Throwable t) {
            this._logger.warn((Object)("Error when retrieving license: " + t));
        }
        return licenses;
    }
}

