/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.notifications;

import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.h5.notifications.LicensingNotificationUtil;

public class VcLicensingExpirationNotification {
    private String name;
    private long licenseExpirationDate;
    private String licenseFormattedExpirationDate;
    private boolean subscription;
    private long licenseExpirationRemainingDays;

    VcLicensingExpirationNotification(String assetName, License license) {
        this.name = assetName;
        this.subscription = license.isSubscription();
        if (license.getExpirationDate() != null) {
            this.licenseExpirationDate = license.getExpirationDate().getTime();
        }
        this.licenseFormattedExpirationDate = license.getFormattedExpirationDate();
        this.licenseExpirationRemainingDays = LicensingNotificationUtil.calculateLicensingRemainingDays(license.getExpirationTime());
    }

    public String getName() {
        return this.name;
    }

    public String getLicenseFormattedExpirationDate() {
        return this.licenseFormattedExpirationDate;
    }

    public long getLicenseExpirationRemainingDays() {
        return this.licenseExpirationRemainingDays;
    }

    public boolean isSubscription() {
        return this.subscription;
    }

    public long getLicenseExpirationDate() {
        return this.licenseExpirationDate;
    }
}

