/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.perfstats.impl.util;

import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vise.util.session.SessionUtil;
import java.util.HashMap;
import java.util.Map;

public class CounterInfoUtil {
    public static int getIdByName(PerformanceManager perfManager, String vcUid, String metricName) {
        Integer counterId;
        HashMap<String, Integer> vcCache = (HashMap<String, Integer>)SessionUtil.getData((String)vcUid);
        if (vcCache == null) {
            vcCache = new HashMap<String, Integer>();
        }
        if ((counterId = (Integer)vcCache.get(metricName)) == null) {
            if (perfManager == null) {
                return -1;
            }
            for (PerformanceManager.CounterInfo counterInfo : perfManager.getPerfCounter()) {
                if (!counterInfo.getNameInfo().getKey().equals(metricName)) continue;
                counterId = counterInfo.getKey();
                vcCache.put(metricName, counterId);
                SessionUtil.setData((String)vcUid, vcCache);
                break;
            }
        }
        return counterId;
    }

    public static String getNameById(PerformanceManager perfManager, String vcUid, int counterId) {
        HashMap<String, Integer> vcCache = (HashMap<String, Integer>)SessionUtil.getData((String)vcUid);
        if (vcCache == null) {
            vcCache = new HashMap<String, Integer>();
        }
        String metricName = null;
        for (Map.Entry cacheEntry : vcCache.entrySet()) {
            if ((Integer)cacheEntry.getValue() != counterId) continue;
            metricName = (String)cacheEntry.getKey();
            break;
        }
        if (metricName == null) {
            if (perfManager == null) {
                return null;
            }
            for (PerformanceManager.CounterInfo counterInfo : perfManager.getPerfCounter()) {
                if (counterInfo.getKey() != counterId) continue;
                metricName = counterInfo.getNameInfo().getKey();
                vcCache.put(metricName, counterId);
                SessionUtil.setData((String)vcUid, vcCache);
                break;
            }
        }
        return metricName;
    }
}

