/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.compositecommand.commands;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.cluster.ConfigInfoEx;
import com.vmware.vim.binding.vim.cluster.ConfigSpecEx;
import com.vmware.vim.binding.vim.cluster.DasConfigInfo;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.TaskCommand;
import com.vmware.vsphere.client.host.compositecommand.specs.SetClusterAdvancedOptionsCommandSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SetClusterAdvancedOptionsCommand
extends TaskCommand {
    public SetClusterAdvancedOptionsCommand(SetClusterAdvancedOptionsCommandSpec commandSpec) {
        this.setCommandSpec(commandSpec);
    }

    protected Task launch() throws Exception {
        SetClusterAdvancedOptionsCommandSpec commandSpec = (SetClusterAdvancedOptionsCommandSpec)this.getCommandSpec();
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)commandSpec.mor);
        ConfigInfoEx clusterConfig = (ConfigInfoEx)cluster.getConfigurationEx();
        OptionValue[] rawClusterOptions = new OptionValue[]{};
        if (clusterConfig != null && clusterConfig.dasConfig != null && clusterConfig.dasConfig.option != null) {
            rawClusterOptions = clusterConfig.dasConfig.option;
        }
        Map<String, Object> clusterOptions = this.optionValuesToMap(rawClusterOptions);
        clusterOptions.putAll(commandSpec.options);
        ConfigSpecEx clusterConfigSpec = new ConfigSpecEx();
        clusterConfigSpec.dasConfig = new DasConfigInfo();
        clusterConfigSpec.dasConfig.option = this.mapToOptionValues(clusterOptions);
        ManagedObjectReference taskRef = cluster.reconfigureEx((ComputeResource.ConfigSpec)clusterConfigSpec, true);
        Task task = (Task)ManagedObjectUtil.getManagedObject((ManagedObjectReference)taskRef);
        return task;
    }

    private Map<String, Object> optionValuesToMap(OptionValue[] options) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (OptionValue option : options) {
            result.put(option.key, option.value);
        }
        return result;
    }

    private OptionValue[] mapToOptionValues(Map<String, Object> options) {
        ArrayList<OptionValue> result = new ArrayList<OptionValue>(options.size());
        for (Map.Entry<String, Object> option : options.entrySet()) {
            result.add(new OptionValue(option.getKey(), option.getValue()));
        }
        return result.toArray(new OptionValue[0]);
    }
}

