/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vim.vm.VirtualHardware;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualPCIPassthrough;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.host.config.PciDeviceToVmMapping;
import java.util.ArrayList;

public class PciPassthruPropertyProvider
implements PropertyProviderBean {
    @type(value="HostSystem")
    public PciDeviceToVmMapping[] getDeviceToVMMapping(ManagedObjectReference hostSystemRef) throws Exception {
        ArrayList<PciDeviceToVmMapping> results = new ArrayList<PciDeviceToVmMapping>();
        HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
        if (host == null) {
            return new PciDeviceToVmMapping[0];
        }
        ManagedObjectReference[] vms = host.getVm();
        if (vms == null) {
            return new PciDeviceToVmMapping[0];
        }
        for (ManagedObjectReference vmRef : vms) {
            VirtualDevice[] devices;
            VirtualHardware vHardware;
            ConfigInfo confInfo;
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            if (vm == null || (confInfo = vm.getConfig()) == null || (vHardware = confInfo.getHardware()) == null || (devices = vHardware.getDevice()) == null) continue;
            for (VirtualDevice device : devices) {
                VirtualPCIPassthrough pciDevice;
                if (!(device instanceof VirtualPCIPassthrough) || !((pciDevice = (VirtualPCIPassthrough)device).getBacking() instanceof VirtualPCIPassthrough.DeviceBackingInfo)) continue;
                PciDeviceToVmMapping mapping = new PciDeviceToVmMapping();
                mapping.bsfId = ((VirtualPCIPassthrough.DeviceBackingInfo)pciDevice.getBacking()).id;
                mapping.vmName = vm.getName();
                mapping.vmRef = vmRef;
                results.add(mapping);
            }
        }
        return results.toArray(new PciDeviceToVmMapping[0]);
    }
}

