/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.host.PowerSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.host.config.PowerConfigHardwareSpec;
import com.vmware.vsphere.client.host.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PowerConfigHardwareProvider
implements PropertyProviderBean,
MutationProvider {
    private static final Log _logger = LogFactory.getLog(PowerConfigHardwareProvider.class);
    private DataService _dataService;
    private LegacyAuthorizationService _authService;

    public void setDataService(DataService dataService) {
        this._dataService = dataService;
    }

    public void setAuthorizationService(LegacyAuthorizationService authService) {
        this._authService = authService;
    }

    @type(value="HostSystem")
    public DynamicObject getPowerConfigHardware(ManagedObjectReference hostRef) throws Exception {
        ObjectIdentityConstraint hostConstraint = QueryUtil.createObjectIdentityConstraint((Object)hostRef);
        Constraint psConstraint = QueryUtil.createConstraintForRelationship((Object)hostRef, (String)"configManager.powerSystem", (String)"HostPowerSystem");
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{hostConstraint, psConstraint}, (Conjoiner)Conjoiner.OR);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"hardware.cpuPowerManagementInfo.hardwareSupport", "info.currentPolicy.name"});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        if (resultSet.error != null) {
            _logger.error((Object)resultSet.error);
        }
        Object[] resultItems = resultSet.items;
        String hardwareSupportTechnology = "";
        String powerSystemCurrentPolicy = "";
        if (!ArrayUtil.isNullOrEmpty((Object[])resultItems)) {
            for (Object resultItem : resultItems) {
                Object[] propValues = ((ResultItem)resultItem).properties;
                if (ArrayUtil.isNullOrEmpty((Object[])propValues)) continue;
                for (Object propValue : propValues) {
                    String propName = ((PropertyValue)propValue).propertyName;
                    if ("hardware.cpuPowerManagementInfo.hardwareSupport".equals(propName)) {
                        hardwareSupportTechnology = (String)((PropertyValue)propValue).value;
                        continue;
                    }
                    if (!"info.currentPolicy.name".equals(propName)) continue;
                    String policyName = (String)((PropertyValue)propValue).value;
                    powerSystemCurrentPolicy = LocalizationUtil.getLocalizedMessage((String)policyName);
                }
            }
        }
        DynamicObject result = new DynamicObject();
        result.properties = new NameValuePair[]{new NameValuePair("technology", (Object)hardwareSupportTechnology), new NameValuePair("powerSystemCurrentPolicy", (Object)powerSystemCurrentPolicy)};
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, property="powerConfigHardware.@info.immutable")
    public boolean getPowerConfigHardwareImmutable(ManagedObjectReference hostRef) {
        boolean immutable = !Util.checkHostAvailability(hostRef, new String[]{"Host.Config.Power"}, this._dataService, this._authService);
        return immutable;
    }

    public OperationResult apply(ManagedObjectReference hostRef, PowerConfigHardwareSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            ManagedObjectReference psMor = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"configManager.powerSystem");
            if (psMor != null) {
                PowerSystem powerSystem = (PowerSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)psMor);
                powerSystem.configurePolicy(spec.policyKey);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Boot device mutation failed", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

