/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.fault.HostConfigFault;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.DateTimeSystem;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.FirewallSystem;
import com.vmware.vim.binding.vim.host.Ruleset;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vim.binding.vim.host.ServiceSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.host.config.TimeConfigSpec;
import com.vmware.vsphere.client.host.util.Util;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeConfigMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(TimeConfigMutationProvider.class);
    private static final String RESOURCE_BUNDLE_NAME = "hostservice";
    private static final String NTP_SERVICE_KEY = "ntpd";
    private static final String NTP_RULESET_KEY = "ntp";

    public OperationResult apply(ManagedObjectReference mor, TimeConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = mor;
        if (spec == null) {
            String nullSpecMsg = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)"error.nullTimeConfigSpec", (ClassLoader)this.getClass().getClassLoader());
            result.error = new IllegalArgumentException(nullSpecMsg);
            return result;
        }
        try {
            ConfigManager manager = Util.getHostConfigManager(mor);
            ServiceSystem system = (ServiceSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)manager.getServiceSystem());
            Service ntpService = TimeConfigMutationProvider.getNtpService(system);
            FirewallSystem firewall = null;
            if (manager.getFirewallSystem() == null) {
                String nullFirewallMsg = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)"error.nullFirewall", (ClassLoader)this.getClass().getClassLoader());
                throw new NullPointerException(nullFirewallMsg);
            }
            firewall = (FirewallSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)manager.getFirewallSystem());
            DateTimeSystem dateTimeSystem = null;
            if (manager.getDateTimeSystem() != null) {
                dateTimeSystem = (DateTimeSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)manager.getDateTimeSystem());
            }
            if (spec.serviceId != null && spec.servicePolicy != null) {
                system.updatePolicy(spec.serviceId, spec.servicePolicy.toString());
            }
            TimeConfigMutationProvider.updateNtpServerListAndTimeZone(spec, dateTimeSystem);
            if (spec.enableNtpClient.booleanValue()) {
                TimeConfigMutationProvider.enableNtpService(true, firewall, ntpService);
                if (spec.action != null) {
                    TimeConfigMutationProvider.changeNtpServiceState(spec.serviceId, spec.action, system);
                }
            } else {
                TimeConfigMutationProvider.updateDateTime(spec, dateTimeSystem);
                TimeConfigMutationProvider.enableNtpService(false, firewall, ntpService);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Time configuration failed", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static void updateDateTime(TimeConfigSpec spec, DateTimeSystem dateTimeSystem) throws Exception {
        if (spec == null || dateTimeSystem == null) {
            return;
        }
        Calendar greg = GregorianCalendar.getInstance();
        greg.setTime(spec.targetTime);
        dateTimeSystem.updateDateTime(greg);
    }

    private static void updateNtpServerListAndTimeZone(TimeConfigSpec spec, DateTimeSystem dateTimeSystem) throws Exception {
        if (spec == null || dateTimeSystem == null) {
            return;
        }
        dateTimeSystem.updateConfig(spec.dateTimeConfig);
    }

    private static void enableNtpService(boolean enabled, FirewallSystem firewall, Service ntpService) throws Exception {
        int i;
        Boolean currentlyEnabled = ntpService.running;
        FirewallInfo info = firewall.getFirewallInfo();
        if (info != null) {
            for (i = 0; i < info.ruleset.length; ++i) {
                Ruleset ruleSet = info.ruleset[i];
                if (!ruleSet.key.toLowerCase().contains(NTP_RULESET_KEY)) continue;
                currentlyEnabled = ruleSet.enabled;
                break;
            }
        }
        if (enabled == currentlyEnabled) {
            return;
        }
        for (i = 0; i < ntpService.ruleset.length; ++i) {
            String rule = ntpService.ruleset[i];
            if (enabled) {
                firewall.enableRuleset(rule);
                continue;
            }
            firewall.disableRuleset(rule);
        }
    }

    private static Service getNtpService(ServiceSystem system) throws Exception {
        Service result = null;
        ServiceInfo info = system.getServiceInfo();
        for (int i = 0; i < info.service.length; ++i) {
            Service s = info.service[i];
            if (!s.key.equalsIgnoreCase(NTP_SERVICE_KEY)) continue;
            result = s;
            break;
        }
        if (result == null) {
            String errorMsg = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)"error.timeConfigNtpServiceIsNull", (ClassLoader)TimeConfigMutationProvider.class.getClassLoader());
            throw new Exception(errorMsg);
        }
        return result;
    }

    private static void changeNtpServiceState(String serviceId, TimeConfigSpec.Action action, ServiceSystem system) throws InvalidState, NotFound, HostConfigFault {
        if (action == TimeConfigSpec.Action.start) {
            system.start(serviceId);
        } else if (action == TimeConfigSpec.Action.stop) {
            system.stop(serviceId);
        } else if (action == TimeConfigSpec.Action.restart) {
            system.restart(serviceId);
        }
    }
}

