/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.maintenance;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.host.impl.HostMutationProvider;
import com.vmware.vsphere.client.host.maintenance.HostMaintenanceSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostMaintenanceOpManager {
    private static final Log _logger = LogFactory.getLog(HostMutationProvider.class);

    public static OperationResult applyMaintenanceOp(ManagedObjectReference hostRef, HostMaintenanceSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            result = HostMaintenanceOpManager.applyMaintenanceOp(host, spec, result);
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static OperationResult applyMaintenanceOp(HostSystem host, HostMaintenanceSpec spec, OperationResult result) {
        try {
            if (spec.maintenanceOpType == HostMaintenanceSpec.MaintenanceOpType.enter) {
                result.task = host.enterMaintenanceMode(spec.timeout, spec.evacuatePoweredOffVms, spec.maintenanceSpec);
            } else if (spec.maintenanceOpType == HostMaintenanceSpec.MaintenanceOpType.exit) {
                result.task = host.exitMaintenanceMode(spec.timeout);
            }
            result.effect = new OperationEffect();
            result.effect.isDelayed = true;
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

