/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.util;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.event.DrsExitedStandbyModeEvent;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.ExitedStandbyModeEvent;
import com.vmware.vim.binding.vim.event.LastEventFilterSpec;
import com.vmware.vim.binding.vim.host.ActiveDirectoryAuthentication;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.HostAccessManager;
import com.vmware.vim.binding.vim.host.PowerSystem;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.host.standbyinfo.HostStandbyInfo;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    private static final Log _logger = LogFactory.getLog(Util.class);
    public static String HOST_SERVICE_STRINGS = "hostservice";
    public static int KILOBYTE = 1024;
    public static String UNITBASE_BYTE = "B";
    public static String VERSION_DELIMITER = "\\.";
    public static String VERSION_VALIDATOR = "\\d+(" + VERSION_DELIMITER + "\\d+)*";
    private static String EXIT_STANDBY_FAILED_EVENT = "vim.event.ExitStandbyModeFailedEvent";
    private static String DRS_EXIT_STANDBY_FAILED_EVENT = "vim.event.DrsExitStandbyModeFailedEvent";
    private static String EXIT_STANDBY_EVENT = "vim.event.ExitedStandbyModeEvent";
    private static String DRS_EXIT_STANDBY_EVENT = "vim.event.DrsExitedStandbyModeEvent";

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)HOST_SERVICE_STRINGS, (String)key, (ClassLoader)Util.class.getClassLoader());
    }

    public static DatastoreSystem getHostDatastoreSystem(ManagedObjectReference hostRef) throws Exception {
        ConfigManager cfgManager = Util.getHostConfigManager(hostRef);
        if (cfgManager == null) {
            _logger.error((Object)"getHostDatastoreSystem: failed to retrieve host's ConfigManager.");
            throw new IllegalArgumentException(Util.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        ManagedObjectReference datastoreSystemRef = cfgManager.getDatastoreSystem();
        if (datastoreSystemRef == null) {
            throw new NullPointerException("Datastore system is null for the host " + hostRef.getServerGuid());
        }
        return (DatastoreSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datastoreSystemRef);
    }

    public static ConfigManager getHostConfigManager(ManagedObjectReference hostRef) throws Exception {
        HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        if (host == null) {
            return null;
        }
        return host.getConfigManager();
    }

    public static OptionManager getHostOptionManager(ManagedObjectReference hostRef) throws Exception {
        ConfigManager cfg = Util.getHostConfigManager(hostRef);
        if (cfg == null) {
            return null;
        }
        ManagedObjectReference optionManagerRef = cfg.getAdvancedOption();
        OptionManager manager = (OptionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)optionManagerRef);
        return manager;
    }

    public static HostAccessManager getHostAccessManager(ManagedObjectReference hostRef) throws Exception {
        ConfigManager configMgr = Util.getHostConfigManager(hostRef);
        if (configMgr == null || configMgr.hostAccessManager == null) {
            return null;
        }
        return (HostAccessManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configMgr.hostAccessManager);
    }

    public static ManagedObjectReference lookupDatastoreRef(ManagedObjectReference hostRef, String datastoreName, DataService dataService) throws Exception {
        PropertyConstraint nameConstraint = new PropertyConstraint();
        nameConstraint.targetType = "Datastore";
        nameConstraint.propertyName = "name";
        nameConstraint.comparator = Comparator.EQUALS;
        nameConstraint.comparableValue = datastoreName;
        RelationalConstraint dsConstraint = QueryUtil.createRelationalConstraint((String)"datastore", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)hostRef), (Boolean)true, (String)"Datastore");
        CompositeConstraint cc = new CompositeConstraint();
        cc.nestedConstraints = new Constraint[]{dsConstraint, nameConstraint};
        cc.conjoiner = Conjoiner.AND;
        QuerySpec query = new QuerySpec();
        query.resourceSpec = QueryUtil.createEmptyResourceSpec();
        query.resourceSpec.constraint = cc;
        ResultSet resultSet = QueryUtil.getData((DataService)dataService, (QuerySpec)query);
        if (resultSet.items.length == 0) {
            return null;
        }
        return (ManagedObjectReference)resultSet.items[0].resourceObject;
    }

    public static ManagedObjectReference lookupNetworkRef(ManagedObjectReference hostRef, String networkName, DataService dataService) throws Exception {
        PropertyConstraint nameConstraint = new PropertyConstraint();
        nameConstraint.targetType = "AnyNetwork";
        nameConstraint.propertyName = "name";
        nameConstraint.comparator = Comparator.EQUALS;
        nameConstraint.comparableValue = networkName;
        RelationalConstraint nwConstraint = QueryUtil.createRelationalConstraint((String)"allNetwork", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)hostRef), (Boolean)true, (String)"AnyNetwork");
        CompositeConstraint cc = new CompositeConstraint();
        cc.nestedConstraints = new Constraint[]{nwConstraint, nameConstraint};
        cc.conjoiner = Conjoiner.AND;
        QuerySpec query = new QuerySpec();
        query.resourceSpec = QueryUtil.createEmptyResourceSpec();
        query.resourceSpec.constraint = cc;
        ResultSet resultSet = QueryUtil.getData((DataService)dataService, (QuerySpec)query);
        if (resultSet.items.length == 0) {
            return null;
        }
        return (ManagedObjectReference)resultSet.items[0].resourceObject;
    }

    public static Event[] getLastExitStandbyEvents(ManagedObjectReference hostRef) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"getLastStandbyEvents: Null moRef encountered.");
            return null;
        }
        EventManager eventManager = Util.getEventManager(hostRef);
        if (eventManager == null) {
            _logger.error((Object)"Could not retrieve EventManager");
            return null;
        }
        ManagedObjectReference[] hostEntity = new ManagedObjectReference[]{hostRef};
        String[] standByEvents = new String[]{EXIT_STANDBY_FAILED_EVENT, DRS_EXIT_STANDBY_FAILED_EVENT, EXIT_STANDBY_EVENT, DRS_EXIT_STANDBY_EVENT};
        LastEventFilterSpec lastEventFilterSpec = new LastEventFilterSpec();
        lastEventFilterSpec.entity = hostEntity;
        lastEventFilterSpec.type = standByEvents;
        return eventManager.queryLastEvent(lastEventFilterSpec);
    }

    public static EventManager getEventManager(ManagedObjectReference hostRef) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"getEventManager: Null moRef encountered.");
            return null;
        }
        VcService service = VimSessionUtil.getService((String)hostRef.getServerGuid());
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return null;
        }
        ServiceInstanceContent serviceContent = service.getServiceInstanceContent();
        if (serviceContent == null) {
            _logger.error((Object)"Could not retrieve ServiceInstanceContent");
            return null;
        }
        return (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getEventManager());
    }

    public static HostStandbyInfo getHostStandbyInfo(ManagedObjectReference hostRef) throws Exception {
        Event[] lastExitStandbyEvents = Util.getLastExitStandbyEvents(hostRef);
        if (lastExitStandbyEvents == null || lastExitStandbyEvents.length == 0) {
            return null;
        }
        Arrays.sort(lastExitStandbyEvents, new java.util.Comparator<Event>(){

            @Override
            public int compare(Event e1, Event e2) {
                return e1.createdTime.compareTo(e2.createdTime);
            }
        });
        Event mostRecentEvent = lastExitStandbyEvents[lastExitStandbyEvents.length - 1];
        HostStandbyInfo standByInfo = new HostStandbyInfo();
        standByInfo.lastTimeExit = mostRecentEvent.createdTime.getTime();
        standByInfo.lastExitSucceeded = mostRecentEvent instanceof DrsExitedStandbyModeEvent || mostRecentEvent instanceof ExitedStandbyModeEvent ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return standByInfo;
    }

    public static PowerSystem.PowerPolicy localizePowerPolicy(PowerSystem.PowerPolicy targetPolicy) {
        if (targetPolicy == null) {
            return null;
        }
        PowerSystem.PowerPolicy result = new PowerSystem.PowerPolicy();
        result.key = targetPolicy.key;
        result.description = LocalizationUtil.getLocalizedMessage((String)targetPolicy.description);
        result.name = LocalizationUtil.getLocalizedMessage((String)targetPolicy.name);
        result.shortName = LocalizationUtil.getLocalizedMessage((String)targetPolicy.shortName);
        return result;
    }

    public static boolean isEsxVersion40OrHigher(String version) {
        if (version == null) {
            return false;
        }
        String[] versionNumbers = version.split("\\.");
        return version == "e.x.p" || versionNumbers.length > 0 && !versionNumbers[0].equals("") && versionNumbers[0].charAt(0) >= '4';
    }

    public static boolean isEsxVersion41OrHigher(String version) {
        if (version == null || !Util.isEsxVersion40OrHigher(version)) {
            return false;
        }
        String[] versionNumbers = version.split("\\.");
        return versionNumbers.length >= 2 && versionNumbers[0] != "" && versionNumbers[1].length() > 0 && versionNumbers[1].charAt(0) >= '1' || versionNumbers[0].length() > 0 && versionNumbers[0].charAt(0) > '4';
    }

    public static boolean isEsxVersionEqualOrHigher(String esxVersion, String comparedVersion) throws IllegalArgumentException {
        String[] compVerArr;
        if (!Util.validateVersion(esxVersion)) {
            _logger.error((Object)"Invalid format for host version parameter");
            throw new IllegalArgumentException();
        }
        if (!Util.validateVersion(comparedVersion)) {
            _logger.error((Object)"Invalid format for compare version parameter");
            throw new IllegalArgumentException();
        }
        if (esxVersion.equals(comparedVersion)) {
            return true;
        }
        String[] esxVerArr = esxVersion.split(VERSION_DELIMITER);
        int maxLen = esxVerArr.length > (compVerArr = comparedVersion.split(VERSION_DELIMITER)).length ? esxVerArr.length : compVerArr.length;
        for (int i = 0; i < maxLen; ++i) {
            int compVersionPartInt;
            int esxVersionPartInt = i < esxVerArr.length ? Integer.parseInt(esxVerArr[i]) : 0;
            int n = compVersionPartInt = i < compVerArr.length ? Integer.parseInt(compVerArr[i]) : 0;
            if (esxVersionPartInt == compVersionPartInt) continue;
            return esxVersionPartInt > compVersionPartInt;
        }
        return true;
    }

    public static boolean validateVersion(String version) {
        return version.matches(VERSION_VALIDATOR);
    }

    public static HostSystem.ConnectionState getConnectionStateForHost(ManagedObjectReference hostRef, DataService dataService) throws Exception {
        return (HostSystem.ConnectionState)QueryUtil.getProperty((DataService)dataService, (Object)hostRef, (String)"runtime.connectionState");
    }

    public static boolean checkHostAvailability(ManagedObjectReference hostRef, String[] privilegeIds, DataService dataService, LegacyAuthorizationService authService) {
        boolean available = false;
        try {
            HostSystem.ConnectionState connectionState = Util.getConnectionStateForHost(hostRef, dataService);
            if (connectionState == HostSystem.ConnectionState.connected) {
                available = true;
            }
            if (available) {
                available = authService.checkPrivileges(new ManagedObjectReference[]{hostRef}, privilegeIds);
            }
        }
        catch (Exception ex) {
            _logger.fatal((Object)("Exception caught when retrieving data for " + hostRef.getValue()), (Throwable)ex);
            available = false;
        }
        return available;
    }

    public static ActiveDirectoryAuthentication getActiveDirectoryAuthentication(ManagedObjectReference hostRef, QueryExecutor queryExecutor) throws Exception {
        ManagedObjectReference[] supportedStores;
        Object[] pv = queryExecutor.getPropertiesForRelatedObjects((Object)hostRef, "configManager.authenticationManager", null, new String[]{"supportedStore"});
        if (ArrayUtil.isNullOrEmpty((Object[])pv)) {
            return null;
        }
        for (ManagedObjectReference mor : supportedStores = (ManagedObjectReference[])((PropertyValue)pv[0]).value) {
            if (!ManagedObjectUtil.isOfType((ManagedObjectReference)mor, (String)"HostActiveDirectoryAuthentication")) continue;
            return (ActiveDirectoryAuthentication)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
        }
        return null;
    }
}

