/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5.remediate;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.util.HostProfileComplianceDataUtil;

@QueryBinding(value="HostSystem")
public abstract class RemediateHostDataModel
extends IdentifiableQueryBinding {
    @Property(value="HostSystem/name")
    public String hostName;
    @Property(value="HostSystem/primaryIconId")
    public String hostPrimaryIconId;
    @Property(value="HostSystem/runtime/connectionState")
    public HostSystem.ConnectionState connectionState;
    @Property(value="HostSystem/hp")
    public ManagedObjectReference hp;
    @Property(value="HostSystem/cluster")
    public ManagedObjectReference clusterRef;
    @Relationship(value={"HostSystem/cluster"})
    @Property(value="ClusterComputeResource/name")
    public String clusterName;

    public abstract boolean getCustomizationRequired();

    public abstract boolean getIsHpRelatedOperationRunning();

    public ManagedObjectReference getHostMor() {
        return (ManagedObjectReference)this.provider;
    }

    public String getCustomizationRequiredFormatted() {
        boolean customizationRequired = this.getCustomizationRequired();
        return customizationRequired ? HostProfileUtils.getLocalizedString("hostCompliance.column.customizationRequiredYes") : HostProfileUtils.getLocalizedString("hostCompliance.column.customizationRequiredNo");
    }

    public boolean getIsHostStateValid() {
        boolean isStatusRunning = this.getIsHpRelatedOperationRunning();
        boolean customizationRequired = this.getCustomizationRequired();
        boolean isHostConnected = this.isHostConnected();
        return HostProfileComplianceDataUtil.getIsHostStateValid(isStatusRunning, customizationRequired, isHostConnected, this.hp);
    }

    private boolean isHostConnected() {
        return HostProfileComplianceDataUtil.isHostConnected(this.connectionState);
    }
}

