/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5.remediate.util;

import com.vmware.vim.binding.vim.cluster.DrsConfigInfo;
import com.vmware.vim.binding.vim.fault.HostConfigFailed;
import com.vmware.vim.binding.vim.profile.ComplianceResult;
import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.RemediationTaskListData;
import com.vmware.vsphere.client.hostprofile.data.h5.model.H5HostComplianceData;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.HostRemediateResult;
import com.vmware.vsphere.client.hostprofile.util.HostProfileComplianceDataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HostRemediateStatusUtil {
    static String ICON_ERROR = "vx-icon-error";
    static String ICON_WARNING = "vx-icon-warn";
    static String ICON_SUCCESS = "vx-icon-statusCompliant";
    static String ICON_NOT_COMPLIANT = "vx-icon-statusNotCompliant";
    static String ICON_UNKNOWN = "vsphere-icon-status-unknown";
    static final String REMEDIATION_CANNOT_START = "precheckResultsDialog.reviewRemediateTasksList.error";
    static final String HOST_NOT_IN_MM = "precheckResultsDialog.reviewRemediateTasksList.hostNotInMMode";
    static final String REBOOT_REQUIRED = "precheckResultsDialog.reviewRemediateTasksList.rebootRequired";

    public static HostRemediateResult get60PrecheckResult(RemediationTaskListData remediationTaskListData, H5HostComplianceData complianceResult, String hostName, boolean isHostInMaintenanceMode) {
        HostRemediateResult hostRemediateResult = new HostRemediateResult();
        if (remediationTaskListData != null) {
            if (remediationTaskListData.error != null) {
                String errorMessage = remediationTaskListData.error.getMessage();
                String localizedErrorMessage = HostProfileUtils.getLocalizedString(REMEDIATION_CANNOT_START, errorMessage);
                hostRemediateResult.setStatusText(localizedErrorMessage);
                hostRemediateResult.setStatusIcon(ICON_WARNING);
                hostRemediateResult.setIsHostAvailableForRemediation(false);
            } else if (HostRemediateStatusUtil.isPutInMaintenanceModeRequired(remediationTaskListData.remediationRequirements) && !isHostInMaintenanceMode) {
                hostRemediateResult.setStatusIcon(ICON_WARNING);
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString(HOST_NOT_IN_MM));
                hostRemediateResult.setIsHostAvailableForRemediation(false);
            } else {
                String statusIcon = HostRemediateStatusUtil.getComplianceStatusIcon(complianceResult.getComplianceStatus());
                String complianceStatusMessage = HostProfileComplianceDataUtil.getComplianceStatusLocalized(complianceResult.getComplianceStatus());
                hostRemediateResult.setStatusText(complianceStatusMessage);
                hostRemediateResult.setStatusIcon(statusIcon);
                if (HostRemediateStatusUtil.isRebootRequired(remediationTaskListData.remediationRequirements)) {
                    hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString(REBOOT_REQUIRED, hostName));
                }
                hostRemediateResult.setIsHostAvailableForRemediation(true);
            }
            ArrayList<String> tasks = new ArrayList<String>();
            if (remediationTaskListData.remediationTasks != null) {
                for (String task : remediationTaskListData.remediationTasks) {
                    tasks.add(task);
                }
            }
            hostRemediateResult.setMessages(tasks);
        } else {
            hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.readyToCompletePage.error"));
            hostRemediateResult.setStatusIcon(ICON_ERROR);
            hostRemediateResult.setIsHostAvailableForRemediation(false);
        }
        return hostRemediateResult;
    }

    public static HostRemediateResult getPrecheckResult(ProfileManager.ApplyHostConfigSpec precheckRemediationResult, Boolean clusterDrsEnabled, DrsConfigInfo.DrsBehavior defaultDrsBehavior, boolean inMaintenanceMode) {
        HostRemediateResult hostPrecheckResult = new HostRemediateResult();
        if (precheckRemediationResult != null) {
            MethodFault error = MixedUtil.getMethodFault((Throwable)precheckRemediationResult.getFaultData());
            if (error != null) {
                hostPrecheckResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.readyToCompletePage.error"));
                hostPrecheckResult.setStatusIcon(ICON_ERROR);
                if (error instanceof HostConfigFailed) {
                    ExecuteResult.ExecuteError[] hostConfigError = (ExecuteResult.ExecuteError[])error;
                    HostRemediateStatusUtil.addHostConfigFaultMessages(hostPrecheckResult.getMessages(), (HostConfigFailed)hostConfigError);
                } else {
                    HostRemediateStatusUtil.addFaultMessages(hostPrecheckResult.getMessages(), error);
                }
                if (hostPrecheckResult.getMessages().isEmpty()) {
                    hostPrecheckResult.getMessages().add(error.getMessage());
                }
                if (ExecuteResult.Status.needInput.name().equals(precheckRemediationResult.status)) {
                    hostPrecheckResult.getMessages().add(HostProfileUtils.getLocalizedString("deferredSettings.executeErrorsNeedInput"));
                }
                if (precheckRemediationResult.error != null) {
                    for (ExecuteResult.ExecuteError executeError : precheckRemediationResult.error) {
                        if (executeError == null || executeError.message == null) continue;
                        hostPrecheckResult.getMessages().add(HostProfileUtils.getLocalizedMessage(executeError.message));
                    }
                }
            } else {
                if (precheckRemediationResult.taskDescription != null) {
                    for (LocalizableMessage taskDescription : precheckRemediationResult.taskDescription) {
                        hostPrecheckResult.getMessages().add(HostProfileUtils.getLocalizedMessage(taskDescription));
                    }
                }
                boolean isInFullyAutomatedDrsCluster = HostRemediateStatusUtil.isHostInFullyAutomatedDrsCluster(clusterDrsEnabled, defaultDrsBehavior);
                HostRemediateStatusUtil.setHostPrecheckState(hostPrecheckResult, precheckRemediationResult.taskListRequirement, isInFullyAutomatedDrsCluster, inMaintenanceMode);
            }
        } else {
            hostPrecheckResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.readyToCompletePage.errorNoData"));
            hostPrecheckResult.setStatusIcon(ICON_ERROR);
        }
        return hostPrecheckResult;
    }

    public static HostRemediateResult getRemediateResult(ProfileManager.ApplyHostConfigResult remediationResult) {
        HostRemediateResult hostRemediateResult = new HostRemediateResult();
        if (remediationResult != null && remediationResult.status != null) {
            HostRemediateStatusUtil.setRemediateStatus(hostRemediateResult, remediationResult.status);
            if (remediationResult.errors != null) {
                for (Exception error : remediationResult.errors) {
                    if (error instanceof HostConfigFailed) {
                        HostConfigFailed hostConfigError = (HostConfigFailed)error;
                        HostRemediateStatusUtil.addHostConfigFaultMessages(hostRemediateResult.getMessages(), hostConfigError);
                        continue;
                    }
                    if (error instanceof MethodFault) {
                        MethodFault methodFault = (MethodFault)error;
                        HostRemediateStatusUtil.addFaultMessages(hostRemediateResult.getMessages(), methodFault);
                        continue;
                    }
                    if (error instanceof InvalidArgument && StringUtil.isNullOrEmpty((String)error.getLocalizedMessage())) {
                        InvalidArgument invalidArgument = (InvalidArgument)error;
                        HostRemediateStatusUtil.addInvalidArgumentErrorMessage(hostRemediateResult.getMessages(), invalidArgument);
                        continue;
                    }
                    HostRemediateStatusUtil.addErrorMessages(hostRemediateResult.getMessages(), error);
                }
            }
        } else {
            hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationNotAvailable"));
            hostRemediateResult.setStatusIcon(ICON_ERROR);
        }
        return hostRemediateResult;
    }

    private static void addHostConfigFaultMessages(List<String> messages, HostConfigFailed hostConfigError) {
        Exception[] failures;
        if (!StringUtil.isNullOrEmpty((String)hostConfigError.getLocalizedMessage())) {
            messages.add(hostConfigError.getLocalizedMessage());
        }
        if ((failures = hostConfigError.getFailure()) != null && failures.length > 0) {
            for (Exception failureError : failures) {
                if (!(failureError instanceof MethodFault)) continue;
                MethodFault methodFault = (MethodFault)failureError;
                HostRemediateStatusUtil.addFaultMessages(messages, methodFault);
            }
        }
    }

    private static void addErrorMessages(List<String> messages, Exception error) {
        if (!StringUtil.isNullOrEmpty((String)error.getLocalizedMessage())) {
            messages.add(error.getLocalizedMessage());
        }
    }

    private static void addInvalidArgumentErrorMessage(List<String> messages, InvalidArgument error) {
        String invalidProperty = error.getInvalidProperty();
        String localizedMessage = HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.invalidArgument", invalidProperty);
        messages.add(localizedMessage);
    }

    private static void addFaultMessages(List<String> messages, MethodFault methodFault) {
        if (!StringUtil.isNullOrEmpty((String)methodFault.getLocalizedMessage())) {
            messages.add(methodFault.getLocalizedMessage());
        } else if (!StringUtil.isNullOrEmpty((String)methodFault.getMessage())) {
            messages.add(methodFault.getMessage());
        }
        LocalizableMessage[] localizableMessages = methodFault.getFaultMessage();
        if ((localizableMessages == null || localizableMessages.length == 0) && methodFault.getFaultCause() instanceof MethodFault) {
            MethodFault faultCause = (MethodFault)methodFault.getFaultCause();
            localizableMessages = faultCause.getFaultMessage();
        }
        if (localizableMessages != null) {
            for (LocalizableMessage localizableMessage : localizableMessages) {
                messages.add(localizableMessage.getMessage());
            }
        }
    }

    private static void setHostPrecheckState(HostRemediateResult hostRemediateResult, String[] remediateRequirements, boolean isInFullyAutomatedDrsCluster, boolean hostIsInMaintenanceMode) {
        if (HostRemediateStatusUtil.hasHostToBePutInMaintenanceMode(remediateRequirements, isInFullyAutomatedDrsCluster, hostIsInMaintenanceMode)) {
            if (HostRemediateStatusUtil.isRebootRequired(remediateRequirements)) {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.readyToCompletePage.hostRequriesRebootAndMM"));
                hostRemediateResult.setStatusIcon(ICON_ERROR);
            } else {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.readyToCompletePage.hostRequriesMM"));
                hostRemediateResult.setStatusIcon(ICON_ERROR);
            }
        } else if (HostRemediateStatusUtil.isRebootRequired(remediateRequirements)) {
            if (isInFullyAutomatedDrsCluster && !hostIsInMaintenanceMode) {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.readyToCompletePage.hostInDrsClusterRequriesRebootAndMM"));
                hostRemediateResult.setStatusIcon(ICON_WARNING);
            } else {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.readyToCompletePage.hostHasRebootRequirment"));
                hostRemediateResult.setStatusIcon(ICON_WARNING);
            }
        } else if (isInFullyAutomatedDrsCluster && !hostIsInMaintenanceMode && HostRemediateStatusUtil.isPutInMaintenanceModeRequired(remediateRequirements)) {
            hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.readyToCompletePage.hostInDrsClusterMM"));
            hostRemediateResult.setStatusIcon(ICON_WARNING);
        } else {
            hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.readyToCompletePage.hostWithoutRequirmets"));
            hostRemediateResult.setStatusIcon(ICON_SUCCESS);
        }
    }

    private static boolean isHostInFullyAutomatedDrsCluster(Boolean clusterDrsEnabled, DrsConfigInfo.DrsBehavior defaultDrsBehavior) {
        return clusterDrsEnabled != null && clusterDrsEnabled != false && DrsConfigInfo.DrsBehavior.fullyAutomated.equals((Object)defaultDrsBehavior);
    }

    private static boolean hasHostToBePutInMaintenanceMode(String[] remediateRequirements, boolean hostInMaintenance, boolean hostInDrsCluster) {
        if (hostInMaintenance || hostInDrsCluster || remediateRequirements == null) {
            return false;
        }
        for (String remediateRequirement : remediateRequirements) {
            if (!ProfileManager.TaskListRequirement.maintenanceModeRequired.name().equals(remediateRequirement) && !ProfileManager.TaskListRequirement.rebootRequired.name().equals(remediateRequirement)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRebootRequired(String[] remediateRequirements) {
        if (remediateRequirements == null) {
            return false;
        }
        for (String remediateRequirement : remediateRequirements) {
            if (!ProfileManager.TaskListRequirement.rebootRequired.name().equals(remediateRequirement)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPutInMaintenanceModeRequired(String[] remediateRequirements) {
        if (remediateRequirements == null) {
            return false;
        }
        for (String remediateRequirement : remediateRequirements) {
            if (!ProfileManager.TaskListRequirement.maintenanceModeRequired.name().equals(remediateRequirement)) continue;
            return true;
        }
        return false;
    }

    private static void setRemediateStatus(HostRemediateResult hostRemediateResult, String status) {
        ProfileManager.ApplyHostConfigResult.Status statusEnum = ProfileManager.ApplyHostConfigResult.Status.valueOf((String)status);
        switch (statusEnum) {
            case success: {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationSucceed"));
                hostRemediateResult.setStatusIcon(ICON_SUCCESS);
                break;
            }
            case failed: {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationFailed"));
                hostRemediateResult.setStatusIcon(ICON_ERROR);
                break;
            }
            case reboot_failed: {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationRebootFailed"));
                hostRemediateResult.setStatusIcon(ICON_WARNING);
                break;
            }
            case stateless_reboot_failed: {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationRebootFailed"));
                hostRemediateResult.setStatusIcon(ICON_WARNING);
                break;
            }
            case check_compliance_failed: {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationFailed"));
                hostRemediateResult.setStatusIcon(ICON_ERROR);
                break;
            }
            case state_not_satisfied: {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationCanNotStarted"));
                hostRemediateResult.setStatusIcon(ICON_ERROR);
                break;
            }
            case exit_maintenancemode_failed: {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationMMExit"));
                hostRemediateResult.setStatusIcon(ICON_WARNING);
                break;
            }
            case canceled: {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationCanceled"));
                hostRemediateResult.setStatusIcon(ICON_WARNING);
                break;
            }
            default: {
                hostRemediateResult.setStatusText(HostProfileUtils.getLocalizedString("remediateHostWizard.remediationResults.remediationStatusUnknown"));
                hostRemediateResult.setStatusIcon(ICON_ERROR);
            }
        }
    }

    private static String getComplianceStatusIcon(String complianceResult) {
        HashMap<String, String> complianceResultMap = new HashMap<String, String>();
        complianceResultMap.put(ComplianceResult.Status.compliant.name(), ICON_SUCCESS);
        complianceResultMap.put(ComplianceResult.Status.nonCompliant.name(), ICON_NOT_COMPLIANT);
        complianceResultMap.put(ComplianceResult.Status.unknown.name(), ICON_UNKNOWN);
        return complianceResultMap.containsKey(complianceResult) ? (String)complianceResultMap.get(complianceResult) : ICON_UNKNOWN;
    }
}

