/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.cluster.DrsConfigInfo;
import com.vmware.vim.binding.vim.fault.InvalidProfileReferenceHost;
import com.vmware.vim.binding.vim.fault.ProfileUpdateFailed;
import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ComplianceManager;
import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.Profile;
import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.cluster.ClusterProfileComplianceCheckSpec;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import com.vmware.vsphere.client.hostprofile.data.AddProfileSpec;
import com.vmware.vsphere.client.hostprofile.data.AttachEntitiesSpec;
import com.vmware.vsphere.client.hostprofile.data.ChangeReferenceHostSpec;
import com.vmware.vsphere.client.hostprofile.data.CopyHostProfileSettingsSpec;
import com.vmware.vsphere.client.hostprofile.data.DeferredHostSettingsSpec;
import com.vmware.vsphere.client.hostprofile.data.DetachEntitiesSpec;
import com.vmware.vsphere.client.hostprofile.data.DuplicateProfileSpec;
import com.vmware.vsphere.client.hostprofile.data.ExecuteResultWrapper;
import com.vmware.vsphere.client.hostprofile.data.HostApplyConfigData;
import com.vmware.vsphere.client.hostprofile.data.HostApplyConfigSpecData;
import com.vmware.vsphere.client.hostprofile.data.HostProfileComplianceCheckSpec;
import com.vmware.vsphere.client.hostprofile.data.HostProfileNameValidationSpec;
import com.vmware.vsphere.client.hostprofile.data.HostRemediateDataModel;
import com.vmware.vsphere.client.hostprofile.data.HostRemediateStateDataModel;
import com.vmware.vsphere.client.hostprofile.data.HostRequirements;
import com.vmware.vsphere.client.hostprofile.data.PreRemediationSpec;
import com.vmware.vsphere.client.hostprofile.data.ProfileAssociatedEntitiesCheckComplianceSpec;
import com.vmware.vsphere.client.hostprofile.data.ProfileConfigSpec;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.data.RemediateHostConfigData;
import com.vmware.vsphere.client.hostprofile.data.RemediatePreCheckError;
import com.vmware.vsphere.client.hostprofile.data.RemediationSpec;
import com.vmware.vsphere.client.hostprofile.data.RemoveProfileSpec;
import com.vmware.vsphere.client.hostprofile.data.ResetHostCustomizationsSpec;
import com.vmware.vsphere.client.hostprofile.impl.DeferredHostSettingsMutationProvider;
import com.vmware.vsphere.client.hostprofile.impl.PostProcessUtil;
import com.vmware.vsphere.client.hostprofile.impl.ProcessUtil;
import com.vmware.vsphere.client.hostprofile.impl.ProfileProcessor;
import com.vmware.vsphere.client.hostprofile.impl.ProfileWrapperUtil;
import com.vmware.vsphere.client.hostprofile.impl.Unwrapper;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostApplyConfigService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostProfileMutationProvider
implements MutationProvider {
    private static final String CHECK_COMPLIANCE_WSDL_NAME = "CheckProfileCompliance_Task";
    private static final Log _logger = LogFactory.getLog(HostProfileMutationProvider.class);
    private static final String NEW_LINE_STRING = "\n";
    private static final String COLON_STRING = ":";
    private static final String LIST_ITEM_PREFIX_STRING = "* ";
    private static final String LIST_ITEM_PADDING_STRING = "\t";
    private static final String HOST_PROFILE_NAME_PROPERTY = "name";
    private DataService _dataService;
    private TaskMonitor _taskMonitor;
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;
    private final HostApplyConfigService hostApplyConfigService;
    private final DeferredHostSettingsMutationProvider deferredHostSettingsMutationProvider;

    public HostProfileMutationProvider(DataService dataService, TaskMonitor taskMonitor, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, DeferredHostSettingsMutationProvider deferredHostSettingsMutationProvider, HostApplyConfigService hostApplyConfigService) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this.deferredHostSettingsMutationProvider = deferredHostSettingsMutationProvider;
        this.hostApplyConfigService = hostApplyConfigService;
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    public OperationResult apply(ManagedObjectReference hpRef, ProfileConfigSpec spec) throws Exception {
        OperationResult result;
        block3: {
            result = new OperationResult();
            result.entity = hpRef;
            HostProfile.CompleteConfigSpec updateSpec = null;
            try {
                updateSpec = spec.getCompleteConfigSpec();
                HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hpRef);
                if (updateSpec.applyProfile != null) {
                    PolicyMetadata[] policyMetadata = HostProfileUtils.getHostProfileMetadata((ManagedObjectReference)hpRef, (ProfileManager.MetadataTypes[])new ProfileManager.MetadataTypes[]{ProfileManager.MetadataTypes.policy}).policyMetadata;
                    PostProcessUtil.postProcessProfile(updateSpec.applyProfile, policyMetadata);
                }
                profile.update((HostProfile.ConfigSpec)updateSpec);
            }
            catch (Exception e) {
                _logger.error((Object)"The HostProfile update has failed.", (Throwable)e);
                result.error = MixedUtil.getMethodFault((Throwable)e);
                if (!(result.error instanceof ProfileUpdateFailed) || updateSpec == null) break block3;
                ProfileManager.HostProfileMetadata hostProfileMeta = HostProfileUtils.getHostProfileMetadata(hpRef, ProfileManager.MetadataTypes.profile, ProfileManager.MetadataTypes.policy, ProfileManager.MetadataTypes.category, ProfileManager.MetadataTypes.component);
                ProfileWrapper pwResult = HostProfileUtils.placeErrorsInProfileTree(updateSpec.applyProfile, hostProfileMeta.profileMetadata, hostProfileMeta.policyMetadata, (ProfileUpdateFailed)result.error, true);
                pwResult = ProcessUtil.addCategoriesAndComponents(pwResult, hostProfileMeta.profileCategoryMetadata, hostProfileMeta.profileComponentMetadata);
                result.result = pwResult;
            }
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference hpRef, ProfileConfigSpec spec) throws Exception {
        ValidationResult result = new ValidationResult();
        result.entity = hpRef;
        ProfileWrapper missingDefaultValuesResult = null;
        HostProfile.CompleteConfigSpec updateSpec = null;
        try {
            updateSpec = spec.getCompleteConfigSpec();
            HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hpRef);
            ProfileManager.HostProfileMetadata hostProfileMeta = HostProfileUtils.getHostProfileMetadata(hpRef, ProfileManager.MetadataTypes.profile, ProfileManager.MetadataTypes.policy);
            missingDefaultValuesResult = HostProfileUtils.placeErrorsInProfileTree(updateSpec.applyProfile, hostProfileMeta.profileMetadata, hostProfileMeta.policyMetadata, null, false);
            if (missingDefaultValuesResult.hasErrors()) {
                String errorMsg = HostProfileUtils.getLocalizedString("editProfile.missingRequiredParameters");
                throw new IllegalArgumentException(errorMsg);
            }
            PostProcessUtil.postProcessProfile(updateSpec.applyProfile, hostProfileMeta.policyMetadata);
            if (HostProfileUtils.isVc51OrLater(hpRef)) {
                profile.validate((HostProfile.ConfigSpec)updateSpec);
            }
        }
        catch (IllegalArgumentException illegal) {
            _logger.error((Object)"The HostProfile required parameters validation completed with errors", (Throwable)illegal);
            result.error = MixedUtil.getMethodFault((Throwable)illegal);
            ProfileManager.HostProfileMetadata hostProfileMeta = HostProfileUtils.getHostProfileMetadata(hpRef, ProfileManager.MetadataTypes.category, ProfileManager.MetadataTypes.component);
            result.result = ProcessUtil.addCategoriesAndComponents(missingDefaultValuesResult, hostProfileMeta.profileCategoryMetadata, hostProfileMeta.profileComponentMetadata);
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)"The HostProfile validation completed with errors", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            if (result.error instanceof ProfileUpdateFailed && updateSpec != null) {
                ProfileManager.HostProfileMetadata hostProfileMeta = HostProfileUtils.getHostProfileMetadata(hpRef, ProfileManager.MetadataTypes.profile, ProfileManager.MetadataTypes.policy, ProfileManager.MetadataTypes.category, ProfileManager.MetadataTypes.component);
                ProfileWrapper pwResult = HostProfileUtils.placeErrorsInProfileTree(updateSpec.applyProfile, hostProfileMeta.profileMetadata, hostProfileMeta.policyMetadata, (ProfileUpdateFailed)result.error, true);
                pwResult = ProcessUtil.addCategoriesAndComponents(pwResult, hostProfileMeta.profileCategoryMetadata, hostProfileMeta.profileComponentMetadata);
                result.result = pwResult;
            }
            return result;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference hpRef, AttachEntitiesSpec attachSpec) {
        OperationResult result = new OperationResult();
        result.entity = hpRef;
        try {
            HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hpRef);
            if (!ArrayUtil.isNullOrEmpty((Object[])attachSpec.entitiesToDetach)) {
                this.detachEntities(attachSpec.entitiesToDetach);
            }
            if (!ArrayUtil.isNullOrEmpty((Object[])attachSpec.entitiesToAttach)) {
                profile.associateEntities(attachSpec.entitiesToAttach);
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"The HostProfile attach process has failed. ", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] entities, DetachEntitiesSpec spec) {
        OperationResult[] result = this.detachEntities(entities);
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, HostProfile.SerializedHostProfileSpec spec) {
        OperationResult result = new OperationResult();
        try {
            ProfileManager profileManager = HostProfileUtils.getProfileManager(vcRef.getServerGuid());
            spec.validating = true;
            ManagedObjectReference newProfile = null;
            try {
                newProfile = profileManager.createProfile((Profile.CreateSpec)spec);
            }
            catch (InvalidProfileReferenceHost noRefHostError) {
                spec.validating = false;
                newProfile = profileManager.createProfile((Profile.CreateSpec)spec);
            }
            result.entity = newProfile;
            result.result = newProfile;
            this._queryExecutor.waitUntilSearchable((Object)newProfile);
        }
        catch (Exception e) {
            _logger.error((Object)"Import profile failed", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public static Map<ManagedObjectReference, Set<ManagedObjectReference>> splitByAssociatedProfile(QueryExecutor queryExecutor, ManagedObjectReference[] entities) {
        HashMap<ManagedObjectReference, Set<ManagedObjectReference>> result = new HashMap<ManagedObjectReference, Set<ManagedObjectReference>>();
        try {
            PropertyValue[] profileValues;
            for (PropertyValue profileValue : profileValues = queryExecutor.getProperties((Object[])entities, new String[]{"associatedHostProfile"})) {
                ManagedObjectReference[] hosts;
                ManagedObjectReference entity = (ManagedObjectReference)profileValue.resourceObject;
                ManagedObjectReference profileRef = (ManagedObjectReference)profileValue.value;
                if (profileRef == null) {
                    _logger.warn((Object)"Trying to detach an entity without a profile is a bug.");
                    continue;
                }
                HashSet<ManagedObjectReference> associated = (HashSet<ManagedObjectReference>)result.get(profileRef);
                if (associated == null) {
                    associated = new HashSet<ManagedObjectReference>();
                    result.put(profileRef, associated);
                }
                associated.add(entity);
                if (!entity.getType().equals(ClusterComputeResource.class.getSimpleName()) || (hosts = (ManagedObjectReference[])queryExecutor.getProperty((Object)entity, "host")) == null || hosts.length <= 0) continue;
                associated.addAll(Arrays.asList(hosts));
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Could not extract association profiles.", (Throwable)e);
        }
        return result;
    }

    private OperationResult[] detachEntities(ManagedObjectReference[] entities) {
        Map<ManagedObjectReference, Set<ManagedObjectReference>> associatedEntities = HostProfileMutationProvider.splitByAssociatedProfile(this._queryExecutor, entities);
        OperationResult[] results = new OperationResult[associatedEntities.size()];
        int resultIndex = 0;
        for (Map.Entry<ManagedObjectReference, Set<ManagedObjectReference>> entry : associatedEntities.entrySet()) {
            OperationResult result = new OperationResult();
            result.entity = entry.getKey();
            try {
                HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entry.getKey());
                Collection morSet = entry.getValue();
                assert (morSet != null);
                profile.dissociateEntities(morSet.toArray(new ManagedObjectReference[morSet.size()]));
            }
            catch (Exception e) {
                _logger.warn((Object)"The HostProfile detach process has failed. ", (Throwable)e);
                result.error = MixedUtil.getMethodFault((Throwable)e);
            }
            results[resultIndex++] = result;
        }
        return results;
    }

    public OperationResult add(HostProfile.HostBasedConfigSpec createSpec) {
        if (createSpec.host == null) {
            _logger.warn((Object)"The reference host is undefined");
            throw new RuntimeException(HostProfileUtils.getLocalizedString("error.noReferenceHost"));
        }
        OperationResult result = new OperationResult();
        try {
            ProfileManager profileManager = HostProfileUtils.getProfileManager(createSpec.host.getServerGuid());
            ManagedObjectReference newProfileRef = profileManager.createProfile((Profile.CreateSpec)createSpec);
            HostProfile newProfile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)newProfileRef);
            newProfile.updateReferenceHost(createSpec.host);
            result.entity = newProfileRef;
            result.result = newProfileRef;
            this._queryExecutor.waitUntilSearchable((Object)newProfileRef);
        }
        catch (Exception e) {
            _logger.warn((Object)("The HostProfile could not be created. Arg = " + ObjectUtil.prettyPrint((Object)createSpec)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult add(DuplicateProfileSpec cloneSpec) {
        if (cloneSpec.profileRef == null) {
            _logger.warn((Object)"The reference profile is undefined");
            throw new RuntimeException(HostProfileUtils.getLocalizedString("error.noReferenceProfile"));
        }
        OperationResult result = new OperationResult();
        try {
            HostProfile.ConfigInfo oldConfigInfo = cloneSpec.configInfo;
            if (oldConfigInfo == null) {
                HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cloneSpec.profileRef);
                oldConfigInfo = (HostProfile.ConfigInfo)profile.getConfig();
            }
            HostProfile.CompleteConfigSpec duplicateSpec = new HostProfile.CompleteConfigSpec();
            duplicateSpec.applyProfile = oldConfigInfo.applyProfile;
            duplicateSpec.customComplyProfile = oldConfigInfo.customComplyProfile;
            duplicateSpec.disabledExpressionList = oldConfigInfo.disabledExpressionList;
            duplicateSpec.name = cloneSpec.profileName;
            duplicateSpec.annotation = cloneSpec.profileDescription;
            duplicateSpec.validatorHost = cloneSpec.referenceHost;
            duplicateSpec.validating = true;
            duplicateSpec.enabled = true;
            ProfileManager profileManager = HostProfileUtils.getProfileManager(cloneSpec.profileRef.getServerGuid());
            ManagedObjectReference newProfileRef = null;
            try {
                newProfileRef = profileManager.createProfile((Profile.CreateSpec)duplicateSpec);
            }
            catch (InvalidProfileReferenceHost noRefHostError) {
                duplicateSpec.validating = false;
                newProfileRef = profileManager.createProfile((Profile.CreateSpec)duplicateSpec);
            }
            HostProfile newProfile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)newProfileRef);
            newProfile.updateReferenceHost(cloneSpec.referenceHost);
            result.entity = newProfileRef;
            result.result = newProfileRef;
            this._queryExecutor.waitUntilSearchable((Object)newProfileRef);
        }
        catch (Exception e) {
            _logger.warn((Object)"The HostProfile could not be duplicated. ", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference profileRef, RemoveProfileSpec spec) {
        OperationResult[] results = this.removeOnMultiEntity(new ManagedObjectReference[]{profileRef}, spec);
        return results[0];
    }

    public OperationResult[] removeOnMultiEntity(ManagedObjectReference[] profiles, RemoveProfileSpec spec) {
        OperationResult[] results = new OperationResult[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            OperationResult result = new OperationResult();
            result.entity = profiles[i];
            try {
                HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profiles[i]);
                profile.destroy();
            }
            catch (Exception e) {
                _logger.warn((Object)"The HostProfile could not be removed. ", (Throwable)e);
                result.error = MixedUtil.getMethodFault((Throwable)e);
            }
            results[i] = result;
        }
        for (ManagedObjectReference profile : profiles) {
            this._queryExecutor.waitUntilNotSearchable((Object)profile);
        }
        return results;
    }

    public OperationResult apply(ManagedObjectReference profileRef, ChangeReferenceHostSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = profileRef;
        try {
            HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profileRef);
            profile.updateReferenceHost(spec.host);
            HostProfile.HostBasedConfigSpec updateSpec = new HostProfile.HostBasedConfigSpec();
            updateSpec.host = spec.host;
            updateSpec.useHostProfileEngine = true;
            profile.update((HostProfile.ConfigSpec)updateSpec);
        }
        catch (Exception e) {
            _logger.warn((Object)"Change reference host failed. ", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference profileRef, AddProfileSpec addSpec) {
        OperationResult result = new OperationResult();
        result.entity = profileRef;
        try {
            ProfileManager profileManager = HostProfileUtils.getProfileManager(profileRef.getServerGuid());
            ApplyProfile apResult = this.createDefaultProfile(profileRef, addSpec, profileManager);
            ProfileWrapper pwResult = this.wrapProfile(profileManager, profileRef, apResult);
            pwResult.profileTypeName = addSpec.profileType;
            if (StringUtil.isNullOrEmpty((String)pwResult.label)) {
                pwResult.label = addSpec.profileType;
            }
            result.result = pwResult;
        }
        catch (Exception e) {
            _logger.warn((Object)"Adding host sub-profile failed", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    private ApplyProfile createDefaultProfile(ManagedObjectReference profileRef, AddProfileSpec addSpec, ProfileManager profileManager) {
        ApplyProfile result = profileManager.createDefaultProfile(addSpec.profileTypeName, addSpec.profileType, profileRef);
        return result;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] hpRefs, ProfileAssociatedEntitiesCheckComplianceSpec checkComplianceSpec) {
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        for (ManagedObjectReference hpRef : hpRefs) {
            try {
                HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hpRef);
                ManagedObjectReference[] associatedEntities = profile.getEntity();
                HostProfileComplianceCheckSpec spec = new HostProfileComplianceCheckSpec();
                spec.hostProfile = hpRef;
                OperationResult[] operationResults = this.applyOnMultiEntity(associatedEntities, spec);
                results.addAll(Arrays.asList(operationResults));
            }
            catch (Exception e) {
                _logger.error((Object)e);
                OperationResult result = new OperationResult();
                result.entity = hpRef;
                result.error = e;
                results.add(result);
            }
        }
        return results.toArray(new OperationResult[results.size()]);
    }

    public OperationResult[] applyOnMultiEntityDeferred(ManagedObjectReference[] profiles, ProfileAssociatedEntitiesCheckComplianceSpec checkComplianceSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec deferredSpec) throws Exception {
        OperationResult[] result = null;
        ScheduledTaskSpec scheduleSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)deferredSpec);
        scheduleSpec.action = SchedulingUtil.newMethodAction((String)CHECK_COMPLIANCE_WSDL_NAME, (Object[])new Object[]{null});
        if (deferredSpec.scheduledTask != null) {
            OperationResult operationResult = new OperationResult();
            try {
                ManagedObjectReference scheduleTask = SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)deferredSpec, (ScheduledTaskSpec)scheduleSpec);
                operationResult.entity = scheduleTask;
            }
            catch (Exception e) {
                operationResult.error = MixedUtil.getMethodFault((Throwable)e);
            }
            result = new OperationResult[]{operationResult};
            return result;
        }
        String specName = deferredSpec.name;
        result = new OperationResult[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            scheduleSpec.name = SchedulingUtil.formatTaskNameForBatch((String)specName, (int)i, (int)result.length);
            OperationResult operationResult = new OperationResult();
            try {
                ManagedObjectReference scheduleTask = SchedulingUtil.createVcScheduledTaskForObject((DataService)this._dataService, (ManagedObjectReference)profiles[i], (ScheduledTaskSpec)scheduleSpec);
                operationResult.entity = scheduleTask;
            }
            catch (Exception e) {
                operationResult.error = MixedUtil.getMethodFault((Throwable)e);
            }
            result[i] = operationResult;
        }
        return result;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] entities, HostProfileComplianceCheckSpec spec) {
        OperationResult[] results = new OperationResult[entities.length];
        int resultIndex = 0;
        for (ManagedObjectReference entity : entities) {
            OperationResult result = this.apply(entity, spec);
            results[resultIndex++] = result;
        }
        return results;
    }

    public OperationResult apply(ManagedObjectReference entityRef, HostProfileComplianceCheckSpec spec) {
        assert (entityRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        try {
            if (entityRef == null || spec == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("profile.error.invalidArguments"));
            }
            ManagedObjectReference hostProfileRef = spec.hostProfile;
            if (hostProfileRef == null) {
                hostProfileRef = (ManagedObjectReference)this._queryExecutor.getProperty((Object)entityRef, "associatedHostProfile");
            }
            if (hostProfileRef == null) {
                return result;
            }
            result.entity = hostProfileRef;
            ArrayList<ManagedObjectReference> profilesList = new ArrayList<ManagedObjectReference>();
            if (hostProfileRef != null) {
                profilesList.add(hostProfileRef);
            }
            ManagedObjectReference[] profiles = profilesList.toArray(new ManagedObjectReference[profilesList.size()]);
            ComplianceManager manager = HostProfileUtils.getComplianceManager(entityRef.getServerGuid());
            result.task = manager.checkCompliance(profiles, new ManagedObjectReference[]{entityRef});
        }
        catch (Exception e) {
            _logger.error((Object)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterRef, ClusterProfileComplianceCheckSpec spec) {
        assert (clusterRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = clusterRef;
        try {
            if (clusterRef == null || spec == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("profile.error.invalidArguments"));
            }
            ServiceInstanceContent serviceContent = Util.getServiceInstanceContent(clusterRef);
            ManagedObjectReference clusterProfileRef = spec.clusterProfile;
            ManagedObjectReference hostProfileRef = spec.hostProfile;
            if (clusterProfileRef == null) {
                clusterProfileRef = Util.findAssociatedClusterProfile(serviceContent, clusterRef);
            }
            if (hostProfileRef == null) {
                hostProfileRef = Util.findAssociatedHostProfile(serviceContent, clusterRef);
            }
            if (clusterProfileRef == null && hostProfileRef == null) {
                return result;
            }
            ArrayList<ManagedObjectReference> profilesList = new ArrayList<ManagedObjectReference>();
            if (clusterProfileRef != null) {
                profilesList.add(clusterProfileRef);
            }
            if (hostProfileRef != null) {
                profilesList.add(hostProfileRef);
            }
            ManagedObjectReference[] profiles = profilesList.toArray(new ManagedObjectReference[profilesList.size()]);
            ComplianceManager manager = HostProfileUtils.getComplianceManager(clusterRef.getServerGuid());
            result.task = manager.checkCompliance(profiles, new ManagedObjectReference[]{clusterRef});
        }
        catch (Exception e) {
            _logger.error((Object)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    private ProfileWrapper wrapProfile(ProfileManager profileManager, ManagedObjectReference profileRef, ApplyProfile apResult) throws Exception {
        ProfileManager.HostProfileMetadata hostProfileMeta = HostProfileUtils.getHostProfileMetadata(profileRef, ProfileManager.MetadataTypes.profile, ProfileManager.MetadataTypes.policy);
        ProfileProcessor processor = ProfileProcessor.newInstance(hostProfileMeta.profileMetadata, hostProfileMeta.policyMetadata);
        return processor.process(apResult);
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] hosts, RemediationSpec spec) {
        if (hosts == null || hosts.length == 0) {
            _logger.warn((Object)"No hosts are retrieved for remediation operation");
            return new OperationResult[0];
        }
        if (spec == null) {
            _logger.warn((Object)"The execution results are required for remediation operation.");
            return new OperationResult[0];
        }
        if (spec.deferredHostSettings != null) {
            this.updateHostCustomizations(hosts, spec);
        }
        if (this.isParallelOperationsEnabled(spec.profileReference)) {
            return this.applyHostProfileInBatch(hosts, spec);
        }
        if (spec.hostsExecutionResults == null) {
            _logger.warn((Object)"The execution results are required for remediation operation.");
            return new OperationResult[0];
        }
        return this.applyHostProfile(hosts, spec);
    }

    private OperationResult[] applyHostProfileInBatch(ManagedObjectReference[] hosts, RemediationSpec spec) {
        ProfileManager profileManager = null;
        try {
            profileManager = HostProfileUtils.getProfileManager(spec.profileReference.getServerGuid());
        }
        catch (Exception e) {
            _logger.error((Object)"Can't get ProfileManager for the apply host profile operation in batch.", (Throwable)e);
            OperationResult operationResult = new OperationResult();
            operationResult.error = MixedUtil.getMethodFault((Throwable)e);
            return new OperationResult[]{operationResult};
        }
        if (ArrayUtil.isNullOrEmpty((Object[])spec.hostRequirements) || spec.hostsExecutionResults == null) {
            return this.checkHostRemediateRequirementsAndRemediate(hosts, spec, profileManager);
        }
        return this.remediateHosts(hosts, spec, profileManager);
    }

    private Map<String, String[]> createHostRequirementsMap(HostRequirements[] list) {
        HashMap<String, String[]> hostTaskListRequirements = new HashMap<String, String[]>();
        if (list != null && list.length > 0) {
            for (HostRequirements hostData : list) {
                String hostRefString = ManagedObjectUtil.morefToString((ManagedObjectReference)hostData.hostRef);
                hostTaskListRequirements.put(hostRefString, hostData.remediationRequirements);
            }
        }
        return hostTaskListRequirements;
    }

    private OperationResult[] applyHostProfile(ManagedObjectReference[] hosts, RemediationSpec spec) {
        ArrayList<OperationResult> results = new ArrayList<OperationResult>(hosts.length);
        ProfileManager profileManager = null;
        for (ManagedObjectReference host : hosts) {
            ExecuteResult executeResult;
            String hostRefString = ManagedObjectUtil.morefToString((ManagedObjectReference)host);
            ExecuteResultWrapper executeResultWrapper = spec.hostsExecutionResults.get(hostRefString);
            ExecuteResult executeResult2 = executeResult = executeResultWrapper == null ? null : executeResultWrapper.getExecuteResult();
            if (executeResult == null) {
                _logger.warn((Object)("The execution result could not be found for host: " + host));
                continue;
            }
            if (executeResult.error != null) {
                _logger.warn((Object)("Could not execute remediation for host with has errors: " + host));
                continue;
            }
            if (ExecuteResult.Status.needInput.toString().equals(executeResult.status)) {
                _logger.warn((Object)("Could not execute remediation for host which needs customizations: " + host));
                continue;
            }
            OperationResult hostResult = new OperationResult();
            hostResult.entity = host;
            try {
                if (profileManager == null) {
                    profileManager = HostProfileUtils.getProfileManager(hosts[0].getServerGuid());
                }
                hostResult.task = profileManager.applyHostConfiguration(host, executeResult.configSpec, executeResult.requireInput);
            }
            catch (Exception e) {
                hostResult.error = e;
            }
            results.add(hostResult);
        }
        OperationResult[] result = results.toArray(new OperationResult[results.size()]);
        return result;
    }

    private static List<ManagedObjectReference> getTasks(OperationResult[] operationResults) {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        if (operationResults != null) {
            for (OperationResult operation : operationResults) {
                if (!(operation.task instanceof ManagedObjectReference)) continue;
                result.add((ManagedObjectReference)operation.task);
            }
        }
        return result;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] hosts, ResetHostCustomizationsSpec spec) {
        if (hosts == null || hosts.length == 0) {
            _logger.warn((Object)"No hosts are retrieved for reset HostCustomizations operation");
            return new OperationResult[0];
        }
        OperationResult[] results = new OperationResult[hosts.length];
        for (int idx = 0; idx < hosts.length; ++idx) {
            ManagedObjectReference host = hosts[idx];
            OperationResult hostResult = new OperationResult();
            hostResult.entity = host;
            try {
                ProfileManager profileManager = HostProfileUtils.getProfileManager(host.getServerGuid());
                ProfileManager.AnswerFileOptionsCreateSpec resetSpec = new ProfileManager.AnswerFileOptionsCreateSpec();
                resetSpec.userInput = new DeferredPolicyOptionParameter[0];
                hostResult.task = profileManager.updateAnswerFile(host, (ProfileManager.AnswerFileCreateSpec)resetSpec);
            }
            catch (Exception e) {
                _logger.warn((Object)"Exception occurred during persistence of deferred host settings ", (Throwable)e);
                hostResult.error = MixedUtil.getMethodFault((Throwable)e);
            }
            results[idx] = hostResult;
        }
        return results;
    }

    public ValidationResult validate(ManagedObjectReference entity, HostProfileNameValidationSpec spec) throws Exception {
        ResultSet resultSet;
        if (spec.profileName == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("error.noProfileName"));
        }
        String profileName = spec.profileName.trim();
        if (profileName.isEmpty()) {
            throw new IllegalArgumentException(Util.getLocalizedString("error.noProfileName"));
        }
        ValidationResult result = new ValidationResult();
        result.entity = entity;
        PropertyConstraint constraint = QueryUtil.createPropertyConstraint((String)"HostProfile", (String)HOST_PROFILE_NAME_PROPERTY, (Comparator)Comparator.EQUALS, (Object)profileName);
        QuerySpec query = this._querySpecBuilder.buildQuerySpec((Constraint)constraint, new String[]{HOST_PROFILE_NAME_PROPERTY});
        try {
            resultSet = this._queryExecutor.getData(query);
        }
        catch (Exception e) {
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
        boolean isNameUnique = true;
        if (resultSet.items.length > 0) {
            for (ResultItem item : resultSet.items) {
                if (ManagedObjectUtil.areEqual((ManagedObjectReference)((ManagedObjectReference)item.resourceObject), (ManagedObjectReference)entity).booleanValue() && !spec.isNewHostProfile) continue;
                isNameUnique = false;
                break;
            }
        }
        result.result = isNameUnique;
        return result;
    }

    public OperationResult apply(ManagedObjectReference sourceHostProfileRef, CopyHostProfileSettingsSpec spec) {
        if (sourceHostProfileRef == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("copyHostProfileSettings.emptySourceHostProfile"));
        }
        if (spec == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("copyHostProfileSettings.emptySpec"));
        }
        if (spec.targetHostProfilesRefs == null || spec.targetHostProfilesRefs.length == 0) {
            throw new IllegalArgumentException(Util.getLocalizedString("copyHostProfileSettings.emptyTargetHostProfiles"));
        }
        if (spec.profileWrapper == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("copyHostProfileSettings.emptyCopySettingsObject"));
        }
        ProfileWrapperUtil.patchHostApplyProfileWrapperToBeMerged(spec.profileWrapper, false);
        OperationResult result = new OperationResult();
        result.entity = sourceHostProfileRef;
        try {
            ProfileManager profileManager = HostProfileUtils.getProfileManager(sourceHostProfileRef.getServerGuid());
            HostApplyProfile applyProfile = Unwrapper.unwrap(spec.profileWrapper);
            result.effect = new OperationEffect();
            result.effect.isDelayed = false;
            result.effect.affectedEntites = spec.targetHostProfilesRefs;
            ManagedObjectReference compositeProfileTaskRef = profileManager.compositeProfile(sourceHostProfileRef, spec.targetHostProfilesRefs, applyProfile, null, null, null);
            TaskInfo compositeProfileTaskInfo = this._taskMonitor.monitorTask(compositeProfileTaskRef);
            PropertyValue[] targetProfilesNamePropertyValues = this._queryExecutor.getProperty((Object[])spec.targetHostProfilesRefs, HOST_PROFILE_NAME_PROPERTY);
            HashMap<ManagedObjectReference, String> targetProfileToNameMap = new HashMap<ManagedObjectReference, String>();
            if (targetProfilesNamePropertyValues != null) {
                for (PropertyValue propertyValue : targetProfilesNamePropertyValues) {
                    targetProfileToNameMap.put((ManagedObjectReference)propertyValue.resourceObject, (String)propertyValue.value);
                }
            }
            ArrayList<String> generalErrorMessages = new ArrayList<String>();
            HashMap targetProfileToErrorMessages = new HashMap();
            if (compositeProfileTaskInfo.error != null) {
                generalErrorMessages.add(compositeProfileTaskInfo.error.getMessage());
            }
            if (compositeProfileTaskInfo.result instanceof ProfileManager.CompositionResult) {
                ProfileManager.CompositionResult compositeProfileResult = (ProfileManager.CompositionResult)compositeProfileTaskInfo.result;
                if (compositeProfileResult.errors != null) {
                    for (LocalizableMessage localizableMessage : compositeProfileResult.errors) {
                        String errorMessage = HostProfileUtils.getLocalizedMessage(localizableMessage);
                        generalErrorMessages.add(errorMessage);
                    }
                }
                if (compositeProfileResult.results != null) {
                    for (ProfileManager.CompositionResult.ResultElement compositeProfileResultElement : compositeProfileResult.results) {
                        if (ArrayUtil.isNullOrEmpty((Object[])compositeProfileResultElement.errors)) continue;
                        ArrayList<String> targetProfileErrorMessages = new ArrayList<String>();
                        for (LocalizableMessage errorMessage : compositeProfileResultElement.errors) {
                            String message = HostProfileUtils.getLocalizedMessage(errorMessage);
                            targetProfileErrorMessages.add(message);
                        }
                        targetProfileToErrorMessages.put(compositeProfileResultElement.target, targetProfileErrorMessages);
                    }
                }
            }
            if (generalErrorMessages.size() == 0 && targetProfileToErrorMessages.size() == 0) {
                return result;
            }
            StringBuilder errorMessageBuilder = new StringBuilder();
            for (String generalErrorMessage : generalErrorMessages) {
                errorMessageBuilder.append(LIST_ITEM_PREFIX_STRING).append(generalErrorMessage).append(NEW_LINE_STRING);
            }
            errorMessageBuilder.append(NEW_LINE_STRING);
            for (ManagedObjectReference targetProfileRef : targetProfileToErrorMessages.keySet()) {
                String targetProfileName = (String)targetProfileToNameMap.get(targetProfileRef);
                if (targetProfileName == null) {
                    targetProfileName = targetProfileRef.toString();
                }
                errorMessageBuilder.append(targetProfileName).append(COLON_STRING).append(NEW_LINE_STRING);
                for (String targetProfileErrorMessage : (List)targetProfileToErrorMessages.get(targetProfileRef)) {
                    errorMessageBuilder.append(LIST_ITEM_PADDING_STRING).append(LIST_ITEM_PREFIX_STRING).append(targetProfileErrorMessage).append(NEW_LINE_STRING);
                }
                errorMessageBuilder.append(NEW_LINE_STRING);
            }
            String errorMessage = errorMessageBuilder.toString();
            errorMessage = StringUtils.strip((String)errorMessage);
            result.error = new Exception(errorMessage);
        }
        catch (Exception e) {
            Throwable cause;
            _logger.error((Object)"Copy Host Profile settings has failed", (Throwable)e);
            for (cause = e; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
            }
            result.error = MixedUtil.getMethodFault((Throwable)cause);
        }
        return result;
    }

    private boolean isParallelOperationsEnabled(ManagedObjectReference entity) {
        try {
            return (Boolean)this._queryExecutor.getProperty((Object)entity, "isParallelOperationsEnabled");
        }
        catch (Exception e) {
            _logger.error((Object)"Can't retrieve 'isParallelOperationsEnabled' property", (Throwable)e);
            return false;
        }
    }

    private void updateHostCustomizations(ManagedObjectReference[] hosts, RemediationSpec spec) {
        try {
            DeferredHostSettingsSpec deferredSettingsSpec = new DeferredHostSettingsSpec();
            deferredSettingsSpec.skipValidationOnHosts = hosts;
            OperationResult[] hostCustomizationResults = this.deferredHostSettingsMutationProvider.applyDeferredHostSettings(spec.profileReference, deferredSettingsSpec, spec.deferredHostSettings);
            List<ManagedObjectReference> hostCustomizationTasks = HostProfileMutationProvider.getTasks(hostCustomizationResults);
            this._taskMonitor.monitorTasks(hostCustomizationTasks);
        }
        catch (Exception e) {
            _logger.warn((Object)"Exception happens during host remediation: ", (Throwable)e);
        }
    }

    private OperationResult[] checkHostRemediateRequirementsAndRemediate(ManagedObjectReference[] hosts, RemediationSpec spec, ProfileManager profileManager) {
        Class<HostRemediateStateDataModel> queryDataModel = HostRemediateStateDataModel.class;
        DataFetchCommand fetchService = DataFetchCommandFactory.getDataFetchCommand((DataService)this._dataService);
        Collection hostStatResults = fetchService.execute(queryDataModel, (Object[])hosts);
        HostApplyConfigSpecData applyConfigSpecs = this.hostApplyConfigService.readHostApplyConfigData(hosts, null);
        Map<ManagedObjectReference, ProfileManager.ApplyHostConfigSpec> hostApplyConfigMap = applyConfigSpecs.hostApplyConfigMap;
        for (HostRemediateStateDataModel hostState : hostStatResults) {
            ProfileManager.ApplyHostConfigSpec hostApplyConfigSpec;
            if (this.canStartRemediate(hostState, hostApplyConfigSpec = hostApplyConfigMap.get((ManagedObjectReference)hostState.provider))) continue;
            OperationResult operationResult = this.createRemediatePreCheckErrorOpResult(hostStatResults, hostApplyConfigMap);
            return new OperationResult[]{operationResult};
        }
        return this.applyEntitiesConfiguration(profileManager, hostApplyConfigMap.values().toArray(new ProfileManager.ApplyHostConfigSpec[hostApplyConfigMap.size()]));
    }

    private ProfileManager.ApplyHostConfigSpec createApplyConfigSpec(ManagedObjectReference hostRef, ExecuteResult executeResult, String[] remediationRequirements, boolean rebootHosts) {
        ProfileManager.ApplyHostConfigSpec applyConfigSpec = new ProfileManager.ApplyHostConfigSpec();
        applyConfigSpec.configSpec = executeResult.configSpec;
        applyConfigSpec.host = hostRef;
        applyConfigSpec.status = executeResult.status;
        applyConfigSpec.requireInput = executeResult.requireInput;
        applyConfigSpec.rebootHost = rebootHosts;
        applyConfigSpec.taskListRequirement = remediationRequirements;
        return applyConfigSpec;
    }

    private OperationResult[] remediateHosts(ManagedObjectReference[] hosts, RemediationSpec spec, ProfileManager profileManager) {
        Map<String, String[]> hostRequirementsMap = this.createHostRequirementsMap(spec.hostRequirements);
        ArrayList<ProfileManager.ApplyHostConfigSpec> applyConfigSpecs = new ArrayList<ProfileManager.ApplyHostConfigSpec>();
        for (ManagedObjectReference host : hosts) {
            ExecuteResult executeResult;
            String hostRefString = ManagedObjectUtil.morefToString((ManagedObjectReference)host);
            ExecuteResultWrapper executeResultWrapper = spec.hostsExecutionResults.get(hostRefString);
            ExecuteResult executeResult2 = executeResult = executeResultWrapper == null ? null : executeResultWrapper.getExecuteResult();
            if (executeResult == null) {
                _logger.warn((Object)("The execution result could not be found for host: " + host));
                continue;
            }
            if (executeResult.error != null) {
                _logger.warn((Object)("Could not execute remediation for host with errors: " + host));
                continue;
            }
            if (ExecuteResult.Status.needInput.toString().equals(executeResult.status)) {
                _logger.warn((Object)("Could not execute remediation for host which needs customizations: " + host));
                continue;
            }
            ProfileManager.ApplyHostConfigSpec applyConfigSpec = this.createApplyConfigSpec(host, executeResult, hostRequirementsMap.get(hostRefString), spec.rebootHosts);
            applyConfigSpecs.add(applyConfigSpec);
        }
        if (applyConfigSpecs.isEmpty()) {
            _logger.warn((Object)"Could not execute remediation for provided hosts.");
            return new OperationResult[0];
        }
        return this.applyEntitiesConfiguration(profileManager, applyConfigSpecs.toArray(new ProfileManager.ApplyHostConfigSpec[applyConfigSpecs.size()]));
    }

    private OperationResult createRemediatePreCheckErrorOpResult(Collection<HostRemediateStateDataModel> dataQueryResults, Map<ManagedObjectReference, ProfileManager.ApplyHostConfigSpec> hostApplyConfigMap) {
        OperationResult operationResult = new OperationResult();
        ArrayList<HostApplyConfigData> hostApplyConfigList = new ArrayList<HostApplyConfigData>();
        for (HostRemediateStateDataModel model : dataQueryResults) {
            ProfileManager.ApplyHostConfigSpec hostApplyConfigSpec = hostApplyConfigMap.get((ManagedObjectReference)model.provider);
            if (hostApplyConfigSpec == null) continue;
            HostApplyConfigData hostApplyConfigData = HostProfileUtils.createHostApplyConfigData(hostApplyConfigSpec);
            hostApplyConfigList.add(hostApplyConfigData);
        }
        RemediatePreCheckError error = dataQueryResults.size() == hostApplyConfigList.size() ? new RemediatePreCheckError(Util.getLocalizedString("remediate.hostRemediateCannotStart")) : new RemediatePreCheckError(Util.getLocalizedString("remediate.hostRemediateCannotStartPreCheckError"));
        error.hostApplyConfigs = hostApplyConfigList.toArray(new HostApplyConfigData[hostApplyConfigList.size()]);
        operationResult.error = error;
        return operationResult;
    }

    private boolean canStartRemediate(HostRemediateStateDataModel hostState, ProfileManager.ApplyHostConfigSpec spec) {
        if (spec == null) {
            return false;
        }
        if (!ExecuteResult.Status.success.name().equals(spec.getStatus())) {
            return false;
        }
        if (spec.taskListRequirement == null || spec.taskListRequirement.length == 0) {
            return true;
        }
        return hostState.inMaintenanceMode != false || hostState.clusterDrsEnabled != false && DrsConfigInfo.DrsBehavior.fullyAutomated == hostState.defaultDrsBehavior;
    }

    private OperationResult[] applyEntitiesConfiguration(ProfileManager profileManager, ProfileManager.ApplyHostConfigSpec[] applyConfigSpecs) {
        OperationResult operationResult = new OperationResult();
        try {
            operationResult.task = profileManager.applyEntitiesConfiguration(applyConfigSpecs);
        }
        catch (Exception e) {
            _logger.error((Object)"Apply host profile operation in batch failed.", (Throwable)e);
            operationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        OperationResult[] result = new OperationResult[]{operationResult};
        return result;
    }

    public ValidationResult validate(ManagedObjectReference entity, PreRemediationSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = entity;
        Class<HostRemediateDataModel> queryDataModel = HostRemediateDataModel.class;
        DataFetchCommand fetchService = DataFetchCommandFactory.getDataFetchCommand((DataService)this._dataService);
        Collection hostStatResults = fetchService.execute(queryDataModel, (Object[])spec.hosts);
        HostApplyConfigSpecData applyConfigSpecs = this.hostApplyConfigService.readHostApplyConfigData(spec.hosts, spec.hostCustomizations);
        Map<ManagedObjectReference, ProfileManager.ApplyHostConfigSpec> hostApplyConfigMap = applyConfigSpecs.hostApplyConfigMap;
        ArrayList<RemediateHostConfigData> remediateHostConfigList = new ArrayList<RemediateHostConfigData>();
        for (HostRemediateDataModel hostState : hostStatResults) {
            ProfileManager.ApplyHostConfigSpec hostApplyConfigSpec = hostApplyConfigMap.get((ManagedObjectReference)hostState.provider);
            RemediateHostConfigData remediateHostConfigData = new RemediateHostConfigData();
            if (hostApplyConfigSpec != null) {
                remediateHostConfigData.hostApplyConfigData = HostProfileUtils.createHostApplyConfigData(hostApplyConfigSpec);
            }
            remediateHostConfigData.defaultDrsBehavior = hostState.defaultDrsBehavior;
            remediateHostConfigData.clusterDrsEnabled = hostState.clusterDrsEnabled;
            remediateHostConfigData.hostName = hostState.hostName;
            remediateHostConfigData.inMaintenanceMode = hostState.inMaintenanceMode;
            remediateHostConfigData.hostPrimaryIconId = hostState.hostPrimaryIconId;
            remediateHostConfigList.add(remediateHostConfigData);
        }
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = entity;
        if (applyConfigSpecs.faults.size() > 0) {
            validationResult.error = new CompositeException(applyConfigSpecs.faults);
        }
        validationResult.result = remediateHostConfigList.toArray(new RemediateHostConfigData[remediateHostConfigList.size()]);
        return validationResult;
    }
}

