/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.profile.ComplianceManager;
import com.vmware.vim.binding.vim.profile.ComplianceResult;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.HostProfileComplianceSummaryData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostProfilePropertyAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(HostProfilePropertyAdapter.class);
    private final QueryExecutor _queryExecutor;

    public HostProfilePropertyAdapter(DataServiceExtensionRegistry registry, QueryExecutor queryExecutor) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._queryExecutor = queryExecutor;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo hostProfileTypeInfo = new TypeInfo();
        hostProfileTypeInfo.type = HostProfile.class.getSimpleName();
        hostProfileTypeInfo.properties = new String[]{"associatedHostCount", "compliantHostCount", "nonCompliantHostCount", "unknownCompliantHostCount"};
        return new TypeInfo[]{hostProfileTypeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] propertySpecs = propertyRequest.properties;
        ArrayList<Exception> faults = new ArrayList<Exception>();
        ResultSet result = new ResultSet();
        boolean onlyAssociatedHostCount = false;
        if (!(HostProfileUtils.isPropertyRequested("unknownCompliantHostCount", propertySpecs) || HostProfileUtils.isPropertyRequested("compliantHostCount", propertySpecs) || HostProfileUtils.isPropertyRequested("nonCompliantHostCount", propertySpecs))) {
            if (HostProfileUtils.isPropertyRequested("associatedHostCount", propertySpecs)) {
                onlyAssociatedHostCount = true;
            } else {
                return result;
            }
        }
        Map<ManagedObjectReference, Collection<PropertyValue>> properties = HostProfilePropertyAdapter.filterSystemObjects(objects);
        this.extractComplianceCount(properties, faults, propertySpecs, onlyAssociatedHostCount);
        if (faults.size() > 0) {
            result.error = new CompositeException(faults);
        }
        result.items = HostProfilePropertyAdapter.mergeResults(properties);
        return result;
    }

    private void extractComplianceCount(Map<ManagedObjectReference, Collection<PropertyValue>> propertiesResult, List<Exception> faults, PropertySpec[] propertySpecs, boolean onlyAssociatedHostCount) {
        Map<Object, Object> summaryData = new HashMap();
        try {
            Map<String, Map<ManagedObjectReference, List<ManagedObjectReference>>> hostProfile = this.getProfilesAndAttachedHostsPerVC(propertiesResult.keySet());
            summaryData = this.extractComplianceSummaryData(faults, hostProfile, onlyAssociatedHostCount);
        }
        catch (Exception ex) {
            _logger.error((Object)"Can't get profile compliance summary data.", (Throwable)ex);
            faults.add((Exception)MixedUtil.getMethodFault((Throwable)ex));
        }
        for (ManagedObjectReference profile : propertiesResult.keySet()) {
            PropertyValue value;
            HostProfileComplianceSummaryData profileSummaryData = (HostProfileComplianceSummaryData)((Object)summaryData.get(profile));
            if (profileSummaryData == null) {
                profileSummaryData = new HostProfileComplianceSummaryData();
            }
            if (HostProfileUtils.isPropertyRequested("associatedHostCount", propertySpecs)) {
                value = new PropertyValue();
                value.resourceObject = profile;
                value.propertyName = "associatedHostCount";
                value.value = profileSummaryData.attachedHostCount;
                propertiesResult.get(profile).add(value);
            }
            if (HostProfileUtils.isPropertyRequested("compliantHostCount", propertySpecs)) {
                value = new PropertyValue();
                value.resourceObject = profile;
                value.propertyName = "compliantHostCount";
                value.value = profileSummaryData.compliantHostCount;
                propertiesResult.get(profile).add(value);
            }
            if (HostProfileUtils.isPropertyRequested("nonCompliantHostCount", propertySpecs)) {
                value = new PropertyValue();
                value.resourceObject = profile;
                value.propertyName = "nonCompliantHostCount";
                value.value = profileSummaryData.nonCompliantHostCount;
                propertiesResult.get(profile).add(value);
            }
            if (!HostProfileUtils.isPropertyRequested("unknownCompliantHostCount", propertySpecs)) continue;
            value = new PropertyValue();
            value.resourceObject = profile;
            value.propertyName = "unknownCompliantHostCount";
            value.value = profileSummaryData.unknownCompliantHostCount;
            propertiesResult.get(profile).add(value);
        }
    }

    private static Map<ManagedObjectReference, Collection<PropertyValue>> filterSystemObjects(Object[] objects) {
        HashMap<ManagedObjectReference, Collection<PropertyValue>> hostProfiles = new HashMap<ManagedObjectReference, Collection<PropertyValue>>();
        for (Object object : objects) {
            if (!(object instanceof ManagedObjectReference)) continue;
            ManagedObjectReference reference = (ManagedObjectReference)object;
            if (!HostProfile.class.getSimpleName().equals(reference.getType())) continue;
            hostProfiles.put(reference, new ArrayList());
        }
        return hostProfiles;
    }

    private static ResultItem[] mergeResults(Map<ManagedObjectReference, Collection<PropertyValue>> properties) {
        ResultItem[] result = new ResultItem[properties.size()];
        int index = 0;
        for (Map.Entry<ManagedObjectReference, Collection<PropertyValue>> entityItem : properties.entrySet()) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = entityItem.getKey();
            resultItem.properties = entityItem.getValue().toArray(new PropertyValue[0]);
            result[index++] = resultItem;
        }
        return result;
    }

    private Map<String, Map<ManagedObjectReference, List<ManagedObjectReference>>> getProfilesAndAttachedHostsPerVC(Set<ManagedObjectReference> profiles) throws Exception {
        PropertyValue[] resultSet = this._queryExecutor.getProperty((Object[])profiles.toArray(new ManagedObjectReference[profiles.size()]), "entity");
        return this.groupEntitiesByGuid(resultSet);
    }

    private Map<String, Map<ManagedObjectReference, List<ManagedObjectReference>>> groupEntitiesByGuid(PropertyValue[] profileEntities) {
        HashMap<String, Map<ManagedObjectReference, List<ManagedObjectReference>>> result = new HashMap<String, Map<ManagedObjectReference, List<ManagedObjectReference>>>();
        for (PropertyValue profileValue : profileEntities) {
            ManagedObjectReference[] entities;
            if (profileValue.resourceObject == null || profileValue.value == null) continue;
            ManagedObjectReference profileRef = (ManagedObjectReference)profileValue.resourceObject;
            for (ManagedObjectReference entity : entities = (ManagedObjectReference[])profileValue.value) {
                LinkedList<ManagedObjectReference> groupedByProfile;
                if (!HostSystem.class.getSimpleName().equals(entity.getType())) continue;
                String serverGuid = entity.getServerGuid();
                HashMap<ManagedObjectReference, LinkedList<ManagedObjectReference>> groupedByVC = (HashMap<ManagedObjectReference, LinkedList<ManagedObjectReference>>)result.get(serverGuid);
                if (groupedByVC == null) {
                    groupedByVC = new HashMap<ManagedObjectReference, LinkedList<ManagedObjectReference>>();
                    result.put(serverGuid, groupedByVC);
                }
                if ((groupedByProfile = (LinkedList<ManagedObjectReference>)groupedByVC.get(profileRef)) == null) {
                    groupedByProfile = new LinkedList<ManagedObjectReference>();
                    groupedByVC.put(profileRef, groupedByProfile);
                }
                groupedByProfile.add(entity);
            }
        }
        return result;
    }

    private HostProfileComplianceSummaryData createProfileComplianceSummaryData(ComplianceResult[] complianceResults, int attahcedHostsCount) {
        HostProfileComplianceSummaryData summaryData = new HostProfileComplianceSummaryData();
        summaryData.attachedHostCount = attahcedHostsCount;
        if (complianceResults == null) {
            summaryData.unknownCompliantHostCount = attahcedHostsCount;
            return summaryData;
        }
        if (attahcedHostsCount > complianceResults.length) {
            summaryData.unknownCompliantHostCount = attahcedHostsCount - complianceResults.length;
        }
        for (ComplianceResult complianceResult : complianceResults) {
            ComplianceResult.Status complianceStatus = null;
            if (complianceResult.complianceStatus != null) {
                complianceStatus = ComplianceResult.Status.valueOf((String)complianceResult.complianceStatus);
            }
            if (ComplianceResult.Status.compliant.equals(complianceStatus)) {
                ++summaryData.compliantHostCount;
                continue;
            }
            if (ComplianceResult.Status.nonCompliant.equals((Object)complianceStatus)) {
                ++summaryData.nonCompliantHostCount;
                continue;
            }
            ++summaryData.unknownCompliantHostCount;
        }
        return summaryData;
    }

    private Map<ManagedObjectReference, HostProfileComplianceSummaryData> extractComplianceSummaryData(List<Exception> faults, Map<String, Map<ManagedObjectReference, List<ManagedObjectReference>>> entitiesPerVC, boolean onlyAssociatedHostCount) {
        HashMap<ManagedObjectReference, HostProfileComplianceSummaryData> profileSummaryData = new HashMap<ManagedObjectReference, HostProfileComplianceSummaryData>();
        ComplianceManager complianceManager = null;
        for (Map.Entry<String, Map<ManagedObjectReference, List<ManagedObjectReference>>> groupedEntitiesPerVC : entitiesPerVC.entrySet()) {
            if (!onlyAssociatedHostCount) {
                complianceManager = this.getComplianceManagerPerVC(groupedEntitiesPerVC.getKey(), faults);
            }
            Map<ManagedObjectReference, List<ManagedObjectReference>> entitiesPerProfile = groupedEntitiesPerVC.getValue();
            for (Map.Entry<ManagedObjectReference, List<ManagedObjectReference>> groupedEntitiesPerProfile : entitiesPerProfile.entrySet()) {
                int arraySize = groupedEntitiesPerProfile.getValue().size();
                ManagedObjectReference[] entities = groupedEntitiesPerProfile.getValue().toArray(new ManagedObjectReference[arraySize]);
                ManagedObjectReference profileRef = groupedEntitiesPerProfile.getKey();
                HostProfileComplianceSummaryData compliancesummaryData = this.extractProfileComplianceSummaryData(complianceManager, entities, profileRef, faults);
                profileSummaryData.put(profileRef, compliancesummaryData);
            }
        }
        return profileSummaryData;
    }

    private ComplianceManager getComplianceManagerPerVC(String serverGuid, List<Exception> faults) {
        try {
            return HostProfileUtils.getComplianceManager(serverGuid);
        }
        catch (Exception ex) {
            _logger.error((Object)("Can't get compliance manager for server with guid:" + serverGuid), (Throwable)ex);
            faults.add((Exception)MixedUtil.getMethodFault((Throwable)ex));
            return null;
        }
    }

    private HostProfileComplianceSummaryData extractProfileComplianceSummaryData(ComplianceManager complianceManage, ManagedObjectReference[] entities, ManagedObjectReference profileRef, List<Exception> faults) {
        ComplianceResult[] complianceStatuses = null;
        if (complianceManage == null) {
            return this.createProfileComplianceSummaryData(null, entities.length);
        }
        try {
            complianceStatuses = complianceManage.queryComplianceStatus(new ManagedObjectReference[]{profileRef}, entities);
        }
        catch (Exception ex) {
            _logger.error((Object)"Can't get compliance results.", (Throwable)ex);
            faults.add((Exception)MixedUtil.getMethodFault((Throwable)ex));
        }
        return this.createProfileComplianceSummaryData(complianceStatuses, entities.length);
    }
}

