/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmfTypeRestorer {
    private static final Log _logger = LogFactory.getLog(AmfTypeRestorer.class);
    private static final Class<?>[] incompatibleFlexTypes = new Class[]{Long.class};

    private AmfTypeRestorer() {
    }

    private static boolean isFlexCompatible(Class<?> runtimeClass, Class<?> declaredType) {
        if (runtimeClass.equals(declaredType)) {
            return true;
        }
        for (Class<?> incompatibleClass : incompatibleFlexTypes) {
            if (!runtimeClass.equals(incompatibleClass)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrimitiveWrapper(Class<?> clazz) {
        try {
            Field wrappedClassField = clazz.getField("TYPE");
            Class underlinedClass = (Class)wrappedClassField.get(null);
            return underlinedClass.isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || AmfTypeRestorer.isPrimitiveWrapper(clazz);
    }

    private static void inspectObject(Object inspectedObject, Class<?> buildtimeClass, Map<String, String> incompatibleMetaData, String fieldPath) {
        if (inspectedObject == null) {
            return;
        }
        Class<?> runtimeClass = inspectedObject.getClass();
        if (!AmfTypeRestorer.isFlexCompatible(runtimeClass, buildtimeClass)) {
            incompatibleMetaData.put(fieldPath, runtimeClass.getName());
            _logger.info((Object)("Found incompatible flex object : " + fieldPath));
        }
        if (!AmfTypeRestorer.isPrimitive(runtimeClass)) {
            AmfTypeRestorer.extractIncompatibleFlexObjects(inspectedObject, incompatibleMetaData, fieldPath);
        }
    }

    public static void extractIncompatibleFlexObjects(Object rootObject, Map<String, String> incompatibleMetadata, String currentPath) {
        if (rootObject == null) {
            return;
        }
        if (incompatibleMetadata == null) {
            throw new IllegalArgumentException("incompatibleMetadata property is null");
        }
        Class<?> rooObjectClass = rootObject.getClass();
        for (Field field : rooObjectClass.getFields()) {
            Object inspectedObjectValue;
            try {
                inspectedObjectValue = field.get(rootObject);
            }
            catch (Exception e) {
                _logger.debug((Object)"Cannot get field value.", (Throwable)e);
                continue;
            }
            String fieldPath = currentPath == null ? field.getName() : String.format("%s.%s", currentPath, field.getName());
            AmfTypeRestorer.inspectObject(inspectedObjectValue, field.getType(), incompatibleMetadata, fieldPath);
        }
        if (rooObjectClass.isArray()) {
            int length = Array.getLength(rootObject);
            for (int i = 0; i < length; ++i) {
                String fieldPath = currentPath == null ? String.format("[%s]", i) : String.format("%s.[%s]", currentPath, i);
                AmfTypeRestorer.inspectObject(Array.get(rootObject, i), rooObjectClass.getComponentType(), incompatibleMetadata, fieldPath);
            }
        }
    }

    private static Object getOriginalTypeObject(Object foundValue, String originalClassName) throws Exception {
        if (foundValue == null || originalClassName == null) {
            return null;
        }
        Class<?> originalClass = Class.forName(originalClassName);
        if (Long.class.equals(originalClass)) {
            return Long.valueOf(foundValue.toString());
        }
        throw new RuntimeException(String.format("Class '%s' is not supported", originalClassName));
    }

    private static void restoreOriginalTypeValue(Object rootObject, String pathToIncompatibleObject, String originalClass) {
        if (rootObject == null) {
            _logger.warn((Object)"Cannot restore properties defined in null object");
            return;
        }
        String[] fullPath = pathToIncompatibleObject.split("\\.");
        if (fullPath == null || fullPath.length == 0) {
            _logger.warn((Object)"There is no path to the flex incompatible object");
            return;
        }
        Object parentObject = null;
        Object foundValue = rootObject;
        boolean isArrayObject = false;
        Field property = null;
        int objectIntex = 0;
        for (String propertyName : fullPath) {
            if (foundValue == null) {
                _logger.info((Object)String.format("Found null object in '%s'.'%s'. Cannnot proceed with the restoration process. The property has might been deleted.", parentObject, propertyName));
                return;
            }
            if (propertyName.startsWith("[") && propertyName.endsWith("]")) {
                isArrayObject = true;
                String indexString = propertyName.substring("[".length(), propertyName.length() - "]".length());
                try {
                    objectIntex = Integer.parseInt(indexString);
                    parentObject = foundValue;
                    foundValue = Array.get(parentObject, objectIntex);
                    continue;
                }
                catch (Exception e) {
                    _logger.info((Object)String.format("Cannot find array item%s in object '%s'. Some parent property might be deleted, or the array might be modified.", indexString, foundValue), (Throwable)e);
                    return;
                }
            }
            isArrayObject = false;
            Class<?> foundObjectClass = foundValue.getClass();
            try {
                property = foundObjectClass.getField(propertyName);
                parentObject = foundValue;
                foundValue = property.get(parentObject);
            }
            catch (Exception e) {
                _logger.info((Object)String.format("Cannot find property '%s' in class '%s'. The property might be deleted", propertyName, foundObjectClass), (Throwable)e);
                return;
            }
        }
        try {
            Object originalValue = AmfTypeRestorer.getOriginalTypeObject(foundValue, originalClass);
            if (isArrayObject) {
                Array.set(rootObject, objectIntex, originalValue);
            } else {
                property.set(parentObject, originalValue);
            }
            _logger.debug((Object)String.format("The object '%s' is properly restored", pathToIncompatibleObject));
        }
        catch (Exception e) {
            _logger.warn((Object)"Cannot restore object value", (Throwable)e);
        }
    }

    public static void restoreIncompatibleFlexObjects(Object object, Map<String, String> incompatibleValues) {
        if (incompatibleValues == null) {
            return;
        }
        for (Map.Entry<String, String> incompatibleObjectInfo : incompatibleValues.entrySet()) {
            String pathToObject = incompatibleObjectInfo.getKey();
            String runtimeClass = incompatibleObjectInfo.getValue();
            AmfTypeRestorer.restoreOriginalTypeValue(object, pathToObject, runtimeClass);
        }
    }
}

