/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.util;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.profile.ComplianceResult;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import com.vmware.vsphere.client.hostprofile.data.h5.ClusterHostProfileHostBaseData;
import com.vmware.vsphere.client.hostprofile.data.h5.model.H5HostComplianceData;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.HostProfileComplianceCount;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.RemediateHostDataModel;
import java.util.Calendar;
import java.util.HashMap;

public class HostProfileComplianceDataUtil {
    private static final String REMEDIATION_STATE_READY = HostSystem.RemediationState.State.remediationReady.name();

    public static boolean getIsHpRelatedOperationRunning(HostSystem.RemediationState remediationState, HostSystem.ComplianceCheckState complianceCheckState) {
        boolean isComplianceCheckRunning = complianceCheckState != null && ComplianceResult.Status.running.name().equals(complianceCheckState.getState());
        boolean isPrecheckRunning = remediationState != null && HostSystem.RemediationState.State.precheckRemediationRunning.name().equals(remediationState.getState());
        boolean isRemediationRunning = remediationState != null && HostSystem.RemediationState.State.remediationRunning.name().equals(remediationState.getState());
        return isComplianceCheckRunning || isPrecheckRunning || isRemediationRunning;
    }

    public static H5HostComplianceData getHostProfileComplianceData(HostSystem.RemediationState remediationState, HostSystem.ComplianceCheckState complianceCheckState) {
        String complianceStatusToSet = null;
        Calendar checkTimeToSet = null;
        if (remediationState != null) {
            String currentRemediationState = HostProfileComplianceDataUtil.getRemediationState(remediationState);
            Calendar currentRemediationCheckTime = HostProfileComplianceDataUtil.getRemediationStateOperationTime(remediationState);
            long currentRemediationCheckTimeInMillis = HostProfileComplianceDataUtil.getRemediationOperationTimeInMillis(remediationState);
            if (complianceCheckState != null) {
                boolean isRemedationCheckTimeLessThanComplianceCheckTime;
                String currentComplianceCheckState = HostProfileComplianceDataUtil.getComplianceCheckState(complianceCheckState);
                Calendar currentComplianceCheckStateTime = HostProfileComplianceDataUtil.getComplianceCheckStateCheckTime(complianceCheckState);
                long currentComplianceCheckStateTimeInMillis = HostProfileComplianceDataUtil.getComplianceCheckStateCheckTimeInMillis(complianceCheckState);
                boolean isRemediationReady = REMEDIATION_STATE_READY.equals(currentRemediationState);
                boolean bl = isRemedationCheckTimeLessThanComplianceCheckTime = currentRemediationCheckTimeInMillis < currentComplianceCheckStateTimeInMillis;
                if (isRemediationReady || isRemedationCheckTimeLessThanComplianceCheckTime) {
                    complianceStatusToSet = currentComplianceCheckState;
                    checkTimeToSet = currentComplianceCheckStateTime;
                } else {
                    complianceStatusToSet = currentRemediationState;
                    checkTimeToSet = currentRemediationCheckTime;
                }
            } else if (!REMEDIATION_STATE_READY.equals(currentRemediationState)) {
                complianceStatusToSet = currentRemediationState;
                checkTimeToSet = currentRemediationCheckTime;
            }
        } else if (complianceCheckState != null) {
            complianceStatusToSet = HostProfileComplianceDataUtil.getComplianceCheckState(complianceCheckState);
            checkTimeToSet = HostProfileComplianceDataUtil.getComplianceCheckStateCheckTime(complianceCheckState);
        }
        String rawComplianceData = complianceCheckState != null ? complianceCheckState.getState() : null;
        H5HostComplianceData hostComplianceData = new H5HostComplianceData(complianceStatusToSet, checkTimeToSet, rawComplianceData);
        return hostComplianceData;
    }

    public static boolean isHostConnected(HostSystem.ConnectionState connectionState) {
        return HostSystem.ConnectionState.connected == connectionState;
    }

    public static boolean getAreHostCustomizationsRequired(String answerFileValidationStatus) {
        return ProfileManager.AnswerFileStatus.invalid.name().equals(answerFileValidationStatus);
    }

    public static boolean getIsHostStateValid(boolean isStatusRunning, boolean customizationRequired, boolean isHostConnected, ManagedObjectReference hp) {
        return isHostConnected && !customizationRequired && !isStatusRunning && hp != null;
    }

    public static HostProfileComplianceCount getHostProfileComplianceCount(ClusterHostProfileHostBaseData[] clusterHostProfileHostBaseData) {
        int numberOfCompliantHosts = 0;
        int numberOfNonCompliantHosts = 0;
        int numberOfUnknownHosts = 0;
        if (clusterHostProfileHostBaseData != null) {
            for (ClusterHostProfileHostBaseData data2 : clusterHostProfileHostBaseData) {
                H5HostComplianceData h5HostComplianceData = data2.getH5HostComplianceData();
                String complianceStatus = h5HostComplianceData.getRawComplianceStatus();
                if (ComplianceResult.Status.compliant.name().equals(complianceStatus)) {
                    ++numberOfCompliantHosts;
                    continue;
                }
                if (ComplianceResult.Status.nonCompliant.name().equals(complianceStatus)) {
                    ++numberOfNonCompliantHosts;
                    continue;
                }
                ++numberOfUnknownHosts;
            }
        }
        return new HostProfileComplianceCount(numberOfCompliantHosts, numberOfNonCompliantHosts, numberOfUnknownHosts);
    }

    public static boolean doesEntityHaveHostsWithCustomizationsRequired(RemediateHostDataModel[] remeidateData) {
        boolean doesEntityHaveHostsWithCustomizationsRequired = false;
        for (RemediateHostDataModel remediateDataItem : remeidateData) {
            if (!remediateDataItem.getCustomizationRequired()) continue;
            doesEntityHaveHostsWithCustomizationsRequired = true;
            break;
        }
        return doesEntityHaveHostsWithCustomizationsRequired;
    }

    public static String getComplianceStatusLocalized(String complianceStatus) {
        HashMap<String, String> statuses = new HashMap<String, String>();
        statuses.put("nonCompliant", "hostComplianceStatus.notCompliant");
        statuses.put("unknown", "hostComplianceStatus.unknown");
        statuses.put("compliant", "hostComplianceStatus.compliant");
        statuses.put("running", "hostComplianceStatus.running");
        statuses.put("precheckRemediationRunning", "hostComplianceStatus.precheckRemediationRunning");
        statuses.put("precheckRemediationComplete", "hostComplianceStatus.precheckRemediationComplete");
        statuses.put("precheckRemediationFailed", "hostComplianceStatus.precheckRemediationFailed");
        statuses.put("remediationRunning", "hostComplianceStatus.remediationRunning");
        statuses.put("remediationFailed", "hostComplianceStatus.remediationFailed");
        statuses.put("remediationReady", "hostComplianceStatus.remediationReady");
        return statuses.containsKey(complianceStatus) ? Util.getLocalizedString((String)statuses.get(complianceStatus)) : Util.getLocalizedString("hostComplianceStatus.unknown");
    }

    private static String getRemediationState(HostSystem.RemediationState remediationState) {
        return remediationState.getState();
    }

    private static Calendar getRemediationStateOperationTime(HostSystem.RemediationState remediationState) {
        return remediationState.getOperationTime();
    }

    private static long getRemediationOperationTimeInMillis(HostSystem.RemediationState remediationState) {
        return remediationState.getOperationTime().getTimeInMillis();
    }

    private static String getComplianceCheckState(HostSystem.ComplianceCheckState complianceCheckState) {
        return complianceCheckState.getState();
    }

    private static Calendar getComplianceCheckStateCheckTime(HostSystem.ComplianceCheckState complianceCheckState) {
        return complianceCheckState.getCheckTime();
    }

    private static long getComplianceCheckStateCheckTimeInMillis(HostSystem.ComplianceCheckState complianceCheckState) {
        return complianceCheckState.getCheckTime().getTimeInMillis();
    }
}

