/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.host;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.Capability;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.annotation.Dto;
import com.vmware.vise.util.Version;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;

@Dto
public class HostData {
    private static final Version ESX_5_5 = new Version("5.5.0");
    private static final Version ESX_6_5 = new Version("6.5.0");
    public ManagedObjectReference hostRef;
    public String formattedName;
    public String clusterName;
    public boolean isHostConnected;
    public boolean hasConfigStoragePrivilege;
    public Boolean isNfs4Supported;
    public Boolean isIpV6NfsSupported;
    public Boolean isVMFS6Supported;
    public Boolean isInDomain;
    public Boolean areKerberosCredentialsSet;
    public Boolean isKerberos5iSupported;
    public Boolean isVvolSupported;

    public static HostData newInstance(ManagedObjectReference hostRef, String name, HostSystem.ConnectionState connectionState, HostSystem.PowerState powerState, String clusterName, boolean hasConfigStoragePrivilege, Capability capability, String esxVersion, boolean areKerberosCredentialsSet, Boolean isInDomain) {
        HostData hostData = new HostData();
        hostData.isHostConnected = HostSystem.ConnectionState.connected.equals((Object)connectionState);
        hostData.hostRef = hostRef;
        hostData.formattedName = HostSystem.ConnectionState.notResponding.equals((Object)connectionState) ? (HostSystem.PowerState.standBy.equals((Object)powerState) ? StorageStringUtil.getString("vmfsDatastore.options.hostState.standby", name) : StorageStringUtil.getString("vmfsDatastore.options.hostState.notResponding", name)) : (HostSystem.ConnectionState.disconnected.equals((Object)connectionState) ? StorageStringUtil.getString("vmfsDatastore.options.hostState.disconnected", name) : name);
        hostData.clusterName = clusterName;
        hostData.hasConfigStoragePrivilege = hasConfigStoragePrivilege;
        if (capability != null) {
            hostData.isNfs4Supported = capability.nfs41Supported;
            hostData.isVvolSupported = capability.virtualVolumeDatastoreSupported;
            hostData.isKerberos5iSupported = capability.nfs41Krb5iSupported;
        }
        hostData.isIpV6NfsSupported = Version.compare((Version)new Version(esxVersion), (Version)ESX_5_5) > 0;
        hostData.isVMFS6Supported = Version.compare((Version)new Version(esxVersion), (Version)ESX_6_5) >= 0;
        hostData.isInDomain = isInDomain;
        hostData.areKerberosCredentialsSet = areKerberosCredentialsSet;
        return hostData;
    }
}

