/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.h5.storage.data.datastore.DatastoreConnectivityData;
import com.vmware.vsphere.client.h5.storage.data.datastore.HostConnectivityData;
import com.vmware.vsphere.client.h5.storage.data.datastore.NfsVvolDatastoreConnectivityItem;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsDatastoreConnectivityItem;
import com.vmware.vsphere.client.h5.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DatastoreConnectivityPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public DatastoreConnectivityPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="connectivityWithHost", property="vmfsDatastoreConnectivity")
    public VmfsDatastoreConnectivityItem[] getVmfsDatastoreConnectivityWithHosts(ManagedObjectReference datastoreRef) {
        DatastoreConnectivityData dataserviceResponse = (DatastoreConnectivityData)((Object)this._queryBindingService.prepare(DatastoreConnectivityData.class).fetch((Object)datastoreRef));
        if (dataserviceResponse == null || dataserviceResponse.hostMounts == null || dataserviceResponse.hostsData == null) {
            return new VmfsDatastoreConnectivityItem[0];
        }
        ArrayList<VmfsDatastoreConnectivityItem> result = new ArrayList<VmfsDatastoreConnectivityItem>();
        Map<ManagedObjectReference, Datastore.HostMount> hostMountIndex = DatastoreConnectivityPropertyProvider.buildHostMountIndex(dataserviceResponse.hostMounts);
        for (HostConnectivityData connectivityData : dataserviceResponse.hostsData) {
            Datastore.HostMount hostMount = hostMountIndex.get(connectivityData.provider);
            if (hostMount == null) continue;
            VmfsDatastoreConnectivityItem currentItem = new VmfsDatastoreConnectivityItem();
            currentItem.init(StorageUtil.formatHostName(connectivityData.name, connectivityData.connectionState, connectivityData.powerState), hostMount);
            currentItem.isMounted = hostMount.mountInfo.mounted == null || Boolean.TRUE.equals(hostMount.mountInfo.mounted);
            currentItem.isHostConnected = HostSystem.ConnectionState.connected == connectivityData.connectionState;
            result.add(currentItem);
        }
        return result.toArray(new VmfsDatastoreConnectivityItem[result.size()]);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="connectivityWithHost", property="nfsVvolDatastoreConnectivity")
    public NfsVvolDatastoreConnectivityItem[] getNfsVvolDatastoreConnectivity(ManagedObjectReference datastoreRef) {
        DatastoreConnectivityData dataserviceResponse = (DatastoreConnectivityData)((Object)this._queryBindingService.prepare(DatastoreConnectivityData.class).fetch((Object)datastoreRef));
        if (dataserviceResponse == null || dataserviceResponse.hostMounts == null || dataserviceResponse.hostsData == null) {
            return new NfsVvolDatastoreConnectivityItem[0];
        }
        ArrayList<NfsVvolDatastoreConnectivityItem> result = new ArrayList<NfsVvolDatastoreConnectivityItem>();
        Map<ManagedObjectReference, Datastore.HostMount> hostMountIndex = DatastoreConnectivityPropertyProvider.buildHostMountIndex(dataserviceResponse.hostMounts);
        for (HostConnectivityData connectivityData : dataserviceResponse.hostsData) {
            Datastore.HostMount hostMount = hostMountIndex.get(connectivityData.provider);
            if (hostMount == null) continue;
            NfsVvolDatastoreConnectivityItem currentItem = new NfsVvolDatastoreConnectivityItem();
            currentItem.init(StorageUtil.formatHostName(connectivityData.name, connectivityData.connectionState, connectivityData.powerState), hostMount);
            currentItem.accessMode = StorageUtil.formatAccessMode(hostMount.mountInfo.accessMode);
            NasVolume nasVolume = StorageUtil.getNasVolumeByMountInfo(connectivityData.fileSystemVolumeInfo, hostMount.mountInfo);
            currentItem.kerberosAuthentication = StorageUtil.formatKerberosAuthentication(nasVolume);
            result.add(currentItem);
        }
        return result.toArray(new NfsVvolDatastoreConnectivityItem[result.size()]);
    }

    private static Map<ManagedObjectReference, Datastore.HostMount> buildHostMountIndex(Datastore.HostMount[] hostMounts) {
        HashMap<ManagedObjectReference, Datastore.HostMount> map = new HashMap<ManagedObjectReference, Datastore.HostMount>();
        for (Datastore.HostMount mountInfo : hostMounts) {
            map.put(mountInfo.key, mountInfo);
        }
        return map;
    }
}

