/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostDerivedPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(HostDerivedPropertyProviderAdapter.class);
    private static final String NFS_KERBEROS_USER = "nfsKerberosUser";
    private static final String IS_CLEAR_NFS_KERBEROS_CREDENTIALS_ALLOWED = "isClearNfsKerberosCredentialsAllowed";
    private static final String CONNECTION_STATE = "runtime.connectionState";
    private static final String STORAGE_SYSTEM = "storageSystem";
    private static final String IN_DOMAIN = "inDomain";
    private static final String NFS_KERBEROS_USER_EMPTY_VALUE = "";
    private final ExecutorService _threadPoolExecutor;

    public HostDerivedPropertyProviderAdapter(DataServiceExtensionRegistry extensionRegistry, ExecutorService threadPoolExecutor) {
        this._threadPoolExecutor = threadPoolExecutor;
        extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ResultSet resultSet = new ResultSet();
        if (propertyRequest == null) {
            return resultSet;
        }
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (objects == null || properties == null) {
            return resultSet;
        }
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        ArrayList<Callable<Void>> asyncTasks = new ArrayList<Callable<Void>>();
        ArrayList<ResultItemEx> resultItemsEx = new ArrayList<ResultItemEx>();
        for (Object obj : objects) {
            HashSet<String> allDerivedProperties = new HashSet<String>();
            for (PropertySpec propSpec : properties) {
                allDerivedProperties.addAll(Arrays.asList(propSpec.propertyNames));
            }
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItemEx resultItemEx = new ResultItemEx(obj, allDerivedProperties.size());
            resultItemsEx.add(resultItemEx);
            this.computeDerivedProperties(allDerivedProperties, sourcePropertyValuesMap, resultItemEx, asyncTasks);
        }
        if (!asyncTasks.isEmpty()) {
            try {
                List asyncPropertiesResult = this._threadPoolExecutor.invokeAll(asyncTasks);
                for (Future propertyValueResultFuture : asyncPropertiesResult) {
                    try {
                        propertyValueResultFuture.get();
                    }
                    catch (Exception e) {
                        _logger.error((Object)e);
                    }
                }
            }
            catch (Exception e) {
                _logger.error((Object)"No async tasks for property value computation have been run.", (Throwable)e);
            }
        }
        resultSet.items = new ResultItem[resultItemsEx.size()];
        for (int i = 0; i < resultItemsEx.size(); ++i) {
            resultSet.items[i] = ((ResultItemEx)resultItemsEx.get(i)).toResultItem();
        }
        return resultSet;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = HostSystem.class.getSimpleName();
        typeInfo.properties = new String[]{NFS_KERBEROS_USER, IS_CLEAR_NFS_KERBEROS_CREDENTIALS_ALLOWED};
        typeInfo.derivedProperties = new DerivedPropertyInfo[]{HostDerivedPropertyProviderAdapter.createDerivedPropertyInfo(NFS_KERBEROS_USER, new String[]{CONNECTION_STATE, STORAGE_SYSTEM}), HostDerivedPropertyProviderAdapter.createDerivedPropertyInfo(IS_CLEAR_NFS_KERBEROS_CREDENTIALS_ALLOWED, new String[]{CONNECTION_STATE, STORAGE_SYSTEM, IN_DOMAIN})};
        return new TypeInfo[]{typeInfo};
    }

    private void computeDerivedProperties(final Set<String> pendingDerivedProperties, final Map<String, Object> propertyValuesMap, final ResultItemEx resultItemEx, List<Callable<Void>> asyncTasks) {
        HostSystem.ConnectionState connectionState = (HostSystem.ConnectionState)HostDerivedPropertyProviderAdapter.getPropertyValue(propertyValuesMap, CONNECTION_STATE);
        final ManagedObjectReference storageSystemRef = (ManagedObjectReference)HostDerivedPropertyProviderAdapter.getPropertyValue(propertyValuesMap, STORAGE_SYSTEM);
        final HttpServletRequest httpRequestContext = SessionUtil.getHttpRequest();
        if (pendingDerivedProperties.contains(NFS_KERBEROS_USER) && (!HostSystem.ConnectionState.connected.equals((Object)connectionState) || storageSystemRef == null)) {
            resultItemEx.propertyValues.add(HostDerivedPropertyProviderAdapter.createPropValue(NFS_KERBEROS_USER, NFS_KERBEROS_USER_EMPTY_VALUE, resultItemEx.resourceObject));
            pendingDerivedProperties.remove(NFS_KERBEROS_USER);
        }
        if (pendingDerivedProperties.contains(IS_CLEAR_NFS_KERBEROS_CREDENTIALS_ALLOWED) && (!HostSystem.ConnectionState.connected.equals((Object)connectionState) || storageSystemRef == null || Boolean.FALSE.equals(HostDerivedPropertyProviderAdapter.getPropertyValue(propertyValuesMap, IN_DOMAIN)))) {
            resultItemEx.propertyValues.add(HostDerivedPropertyProviderAdapter.createPropValue(IS_CLEAR_NFS_KERBEROS_CREDENTIALS_ALLOWED, Boolean.FALSE, resultItemEx.resourceObject));
            pendingDerivedProperties.remove(IS_CLEAR_NFS_KERBEROS_CREDENTIALS_ALLOWED);
        }
        if (pendingDerivedProperties.isEmpty()) {
            return;
        }
        asyncTasks.add(new Callable<Void>(){

            @Override
            public Void call() {
                String kerberosUserValue = HostDerivedPropertyProviderAdapter.NFS_KERBEROS_USER_EMPTY_VALUE;
                SessionUtil.setHttpRequest((HttpServletRequest)httpRequestContext);
                try {
                    kerberosUserValue = HostDerivedPropertyProviderAdapter.computeKerberosUser(storageSystemRef);
                }
                catch (Exception e) {
                    _logger.error((Object)e);
                }
                if (pendingDerivedProperties.contains(HostDerivedPropertyProviderAdapter.NFS_KERBEROS_USER)) {
                    resultItemEx.propertyValues.add(HostDerivedPropertyProviderAdapter.createPropValue(HostDerivedPropertyProviderAdapter.NFS_KERBEROS_USER, kerberosUserValue, resultItemEx.resourceObject));
                }
                if (pendingDerivedProperties.contains(HostDerivedPropertyProviderAdapter.IS_CLEAR_NFS_KERBEROS_CREDENTIALS_ALLOWED)) {
                    Boolean inDomain = (Boolean)HostDerivedPropertyProviderAdapter.getPropertyValue(propertyValuesMap, HostDerivedPropertyProviderAdapter.IN_DOMAIN);
                    boolean isClearNfsKerberosCredentialsAllowed = inDomain != null && inDomain != false && kerberosUserValue != null && !kerberosUserValue.isEmpty();
                    resultItemEx.propertyValues.add(HostDerivedPropertyProviderAdapter.createPropValue(HostDerivedPropertyProviderAdapter.IS_CLEAR_NFS_KERBEROS_CREDENTIALS_ALLOWED, isClearNfsKerberosCredentialsAllowed, resultItemEx.resourceObject));
                }
                return null;
            }
        });
    }

    private static String computeKerberosUser(ManagedObjectReference storageSystemRef) throws Exception {
        NasVolume.UserInfo userInfo;
        String kerberosUserValue = NFS_KERBEROS_USER_EMPTY_VALUE;
        StorageSystem storageSystem = (StorageSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)storageSystemRef);
        if (storageSystem != null && (userInfo = storageSystem.queryNFSUser()) != null) {
            kerberosUserValue = userInfo.getUser();
        }
        return kerberosUserValue;
    }

    private static PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private static <T> T getPropertyValue(Map<String, Object> propertyValuesMap, String propName) {
        return (T)propertyValuesMap.get(propName);
    }

    private static DerivedPropertyInfo createDerivedPropertyInfo(String propName, String[] sourcePropNames) {
        DerivedPropertyInfo derivedInfo = new DerivedPropertyInfo();
        derivedInfo.propertyName = propName;
        derivedInfo.sourcePropertyNames = sourcePropNames;
        return derivedInfo;
    }

    private static class ResultItemEx {
        private final Object resourceObject;
        private final ArrayBlockingQueue<PropertyValue> propertyValues;

        private ResultItemEx(Object resourceObject, int derivedPropertiesCount) {
            this.resourceObject = resourceObject;
            this.propertyValues = new ArrayBlockingQueue(derivedPropertiesCount);
        }

        private ResultItem toResultItem() {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = this.resourceObject;
            resultItem.properties = this.propertyValues.toArray(new PropertyValue[0]);
            return resultItem;
        }
    }
}

