/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.FibreChannelHba;
import com.vmware.vim.binding.vim.host.FibreChannelOverEthernetHba;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.commonservice.util.QueryExecutorUtil;
import com.vmware.vsphere.client.h5.storage.data.adapters.FcoeConfigData;
import com.vmware.vsphere.client.h5.storage.data.adapters.FibreChannelOverEthernetStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.FibreChannelStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.HostStorageAdaptersData;
import com.vmware.vsphere.client.h5.storage.data.adapters.IscsiStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.NetworkSettingsItem;
import com.vmware.vsphere.client.h5.storage.data.adapters.StorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.multipathing.AdapterStoragePath;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterTopologyCountData;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterType;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import com.vmware.vsphere.client.storage.util.HostStoragePropertyCache;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostStorageAdaptersPropertyProvider
implements PropertyProviderBean {
    private static final String STORAGE_DEVICE_INFO_PROPERTY = "config/storageDevice";
    private static final String STORAGE_MULTIPATH_INFO_PROPERTY = "config/multipathState";
    private static final String HOST_PNIC_PROPERTY = "config/network/pnic";
    private static final String HOST_STORAGE_PRIVILEGE = "Host.Config.Storage";
    private static final String HOST_PRIVILEGES_PROPERTY = "grantedPrivileges";
    private static final String HOST_RUNTIME_CONNECTION_STATE_PROPERTY = "runtime/connectionState";
    private static final String HOST_BUS_ADAPTER_PROPERTY = "hostBusAdapter";
    private static final int INVALID_LUN_NUMBER = -1;
    private static Log _logger = LogFactory.getLog(HostStorageAdaptersPropertyProvider.class);
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;

    public HostStorageAdaptersPropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="hostStorageAdapters")
    public HostStorageAdaptersData getHostStorageAdapters(ManagedObjectReference hostRef) throws Exception {
        HostStorageAdaptersData result = new HostStorageAdaptersData();
        result.adapters = new StorageAdapterData[0];
        if (hostRef == null) {
            _logger.error((Object)"Host is null.");
            return result;
        }
        Map properties = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{STORAGE_DEVICE_INFO_PROPERTY});
        if (properties.isEmpty()) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'.", STORAGE_DEVICE_INFO_PROPERTY, hostRef));
            return result;
        }
        StorageDeviceInfo storageDeviceInfo = (StorageDeviceInfo)properties.get(STORAGE_DEVICE_INFO_PROPERTY);
        if (storageDeviceInfo == null) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'", STORAGE_DEVICE_INFO_PROPERTY, hostRef));
            return result;
        }
        result.isIScsiEnabledOnHost = storageDeviceInfo.softwareInternetScsiEnabled;
        if (storageDeviceInfo.hostBusAdapter == null) {
            return result;
        }
        StorageAdapterTopologyCountData[] adaptersCountData = StorageUtil.getStorageAdapterTopologyCountData((StorageDeviceInfo)storageDeviceInfo);
        result.adapters = this.buildAdapters(storageDeviceInfo.hostBusAdapter, adaptersCountData);
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="hostStorageAdapterPaths")
    public AdapterStoragePath[] getHostStorageAdapterPaths(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"Host is null");
            return new AdapterStoragePath[0];
        }
        Map properties = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{STORAGE_DEVICE_INFO_PROPERTY, STORAGE_MULTIPATH_INFO_PROPERTY});
        if (properties.isEmpty()) {
            _logger.error((Object)String.format("Cannot fetch '[%s, %s]' for '%s'", STORAGE_DEVICE_INFO_PROPERTY, STORAGE_MULTIPATH_INFO_PROPERTY, hostRef));
            return new AdapterStoragePath[0];
        }
        StorageDeviceInfo sdi = (StorageDeviceInfo)properties.get(STORAGE_DEVICE_INFO_PROPERTY);
        if (sdi == null) {
            _logger.error((Object)("StorageDeviceInfo for host [" + hostRef + "] is null"));
            return new AdapterStoragePath[0];
        }
        MultipathStateInfo msi = (MultipathStateInfo)properties.get(STORAGE_MULTIPATH_INFO_PROPERTY);
        if (msi == null) {
            _logger.error((Object)("MultipathStateInfo for host [" + hostRef + "] is null"));
            return new AdapterStoragePath[0];
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        PlugStoreTopology.Adapter pstAdapter = cache.getPstAdapterFromHbaKey(adapterKey);
        if (pstAdapter == null) {
            _logger.error((Object)("Invalid adapterKey passed:[" + adapterKey + "]"));
            String[] params = new String[]{adapterKey};
            throw new IllegalArgumentException(StorageUtil.getLocalizedString((String)"error.invalidAdapter", (String[])params));
        }
        PlugStoreTopology.Plugin[] pstPluginsArray = cache.pstPlugins.values().toArray(new PlugStoreTopology.Plugin[cache.pstPlugins.size()]);
        ArrayList<AdapterStoragePath> dtos = new ArrayList<AdapterStoragePath>();
        if (!ArrayUtil.isNullOrEmpty((Object[])pstAdapter.path)) {
            for (String pathKey : pstAdapter.path) {
                if (StorageUtil.isPathMasked((String)pathKey, (PlugStoreTopology.Plugin[])pstPluginsArray)) continue;
                StoragePathData storagePathData = StorageUtil.buildStoragePathData((String)pathKey, (HostStoragePropertyCache)cache);
                dtos.add(AdapterStoragePath.newInstance(storagePathData));
            }
        }
        return dtos.toArray(new AdapterStoragePath[dtos.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="fcoeConfig")
    public FcoeConfigData getFcoeConfig(ManagedObjectReference hostRef, String fcoePnicName) throws Exception {
        PhysicalNic[] physicalNics;
        FcoeConfigData result = new FcoeConfigData();
        Map hostPnicResponse = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{HOST_PNIC_PROPERTY});
        if (hostPnicResponse.get(HOST_PNIC_PROPERTY) == null) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'", HOST_PNIC_PROPERTY, hostRef));
            return result;
        }
        for (PhysicalNic currentNic : physicalNics = (PhysicalNic[])hostPnicResponse.get(HOST_PNIC_PROPERTY)) {
            if (!currentNic.device.equals(fcoePnicName) || currentNic.fcoeConfiguration == null) continue;
            result.priorityClass = currentNic.fcoeConfiguration.priorityClass;
            break;
        }
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="networkSettings")
    public NetworkSettingsItem getNetworkSettings(ManagedObjectReference hostRef, String iscsiAdapterKey) throws Exception {
        HashMap<String, String> propertyParams = new HashMap<String, String>(1);
        propertyParams.put(HOST_BUS_ADAPTER_PROPERTY, iscsiAdapterKey);
        Map hbaResponse = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)hostRef, (String[])new String[]{HOST_BUS_ADAPTER_PROPERTY}, propertyParams);
        HostBusAdapter hbaAdapter = (HostBusAdapter)hbaResponse.get(HOST_BUS_ADAPTER_PROPERTY);
        if (hbaAdapter == null) {
            _logger.error((Object)String.format("Can not fetch data for hba %s on host %s", iscsiAdapterKey, hostRef));
            return null;
        }
        if (!(hbaAdapter instanceof InternetScsiHba)) {
            _logger.error((Object)String.format("Hba %s is of type %s which is not compatible with %s on host %s", iscsiAdapterKey, hbaAdapter.getClass().getCanonicalName(), InternetScsiHba.class.getCanonicalName(), hostRef));
            return null;
        }
        InternetScsiHba iHbaAdapter = (InternetScsiHba)hbaAdapter;
        return NetworkSettingsItem.getInstance(iHbaAdapter);
    }

    @ModelMetadata(type={"Datacenter", "Folder", "ClusterComputeResource"}, propertyNamespace="storageadapter", property="getHostsApplicableForRescan")
    public ManagedObjectReference[] getHostsApplicableForRescan(ManagedObjectReference moRef) throws Exception {
        ArrayList<ManagedObjectReference> hostRefs = new ArrayList<ManagedObjectReference>();
        if (moRef == null) {
            return hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
        }
        RelationalConstraint hostsOfAContainer = QueryUtil.createRelationalConstraint((String)"host", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)moRef), (Boolean)true, (String)HostSystem.class.getSimpleName());
        ResultSet resultSet = this._queryExecutor.getData(this._querySpecBuilder.buildQuerySpec((Constraint)hostsOfAContainer, new String[]{HOST_RUNTIME_CONNECTION_STATE_PROPERTY, HOST_PRIVILEGES_PROPERTY}));
        if (resultSet.error != null) {
            _logger.error((Object)String.format("Error occurred while fetching data about hosts under %s", moRef), (Throwable)resultSet.error);
            return hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
        }
        for (ResultItem item : resultSet.items) {
            Map properties = QueryExecutorUtil.mapPropertyNamesToValues((PropertyValue[])item.properties);
            boolean isHostConnected = properties.get(HOST_RUNTIME_CONNECTION_STATE_PROPERTY).equals(HostSystem.ConnectionState.connected);
            List<String> hostPrivileges = Arrays.asList((String[])properties.get(HOST_PRIVILEGES_PROPERTY));
            boolean neededPrivilegeMet = hostPrivileges.contains(HOST_STORAGE_PRIVILEGE);
            if (!isHostConnected || !neededPrivilegeMet) continue;
            hostRefs.add((ManagedObjectReference)item.resourceObject);
        }
        return hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
    }

    private StorageAdapterData[] buildAdapters(HostBusAdapter[] hostBusAdapters, StorageAdapterTopologyCountData[] adaptersCountData) {
        StorageAdapterData[] adapters = new StorageAdapterData[hostBusAdapters.length];
        HashMap<String, StorageAdapterTopologyCountData> adaptersCountsByKey = new HashMap<String, StorageAdapterTopologyCountData>();
        if (adaptersCountData != null) {
            for (StorageAdapterTopologyCountData countData : adaptersCountData) {
                adaptersCountsByKey.put(countData.adapterKey, countData);
            }
        }
        for (int i = 0; i < hostBusAdapters.length; ++i) {
            adapters[i] = this.createAdapterData(hostBusAdapters[i]);
            StorageAdapterTopologyCountData countData = (StorageAdapterTopologyCountData)adaptersCountsByKey.get(adapters[i].key);
            if (countData == null) continue;
            adapters[i].numberOfTargets = countData.numberOfTargets;
            adapters[i].numberOfDevices = countData.numberOfDevices;
            adapters[i].numberOfPaths = countData.numberOfPaths;
        }
        return adapters;
    }

    private StorageAdapterData createAdapterData(HostBusAdapter hba) {
        StorageAdapterData result;
        StorageAdapterType adapterType = StorageAdapterType.getType((HostBusAdapter)hba);
        if (StorageAdapterType.ISCSI.equals((Object)adapterType)) {
            IscsiStorageAdapterData iscsiStorageAdapterData = new IscsiStorageAdapterData();
            InternetScsiHba iscsiHba = (InternetScsiHba)hba;
            IscsiStorageAdapterData.populateIscsiStorageAdapterData(iscsiStorageAdapterData, iscsiHba);
            result = iscsiStorageAdapterData;
        } else if (hba instanceof FibreChannelHba) {
            FibreChannelStorageAdapterData fcAdapterData;
            if (StorageAdapterType.FCOE.equals((Object)adapterType)) {
                FibreChannelOverEthernetStorageAdapterData fcoeAdapterData = new FibreChannelOverEthernetStorageAdapterData();
                FibreChannelOverEthernetHba fcoeHba = (FibreChannelOverEthernetHba)hba;
                fcoeAdapterData.isMarkedForRemoval = fcoeHba.markedForRemoval;
                fcoeAdapterData.underlyingNic = fcoeHba.underlyingNic;
                fcoeAdapterData.linkInfo = fcoeHba.linkInfo;
                fcAdapterData = fcoeAdapterData;
            } else {
                fcAdapterData = new FibreChannelStorageAdapterData();
            }
            FibreChannelHba fcHba = (FibreChannelHba)hba;
            fcAdapterData.formattedNodeWorldWideName = com.vmware.vsphere.client.h5.storage.util.StorageUtil.formatWWPN(fcHba.nodeWorldWideName);
            fcAdapterData.formattedPortWorldWideName = com.vmware.vsphere.client.h5.storage.util.StorageUtil.formatWWPN(fcHba.portWorldWideName);
            result = fcAdapterData;
        } else {
            result = new StorageAdapterData();
        }
        result.key = hba.key;
        result.device = hba.device;
        result.status = hba.status;
        result.model = hba.model;
        result.type = adapterType;
        result.identifier = com.vmware.vsphere.client.h5.storage.util.StorageUtil.formatHostStorageAdapterIdentifier(hba);
        return result;
    }
}

