/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.CacheConfigurationManager;
import com.vmware.vim.binding.vim.host.Capability;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryExecutorUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.storage.data.datastore.DatastoreCopyItem;
import com.vmware.vsphere.client.h5.storage.data.datastore.DatastoreLocatorData;
import com.vmware.vsphere.client.h5.storage.data.host.HostData;
import com.vmware.vsphere.client.h5.storage.data.host.HostSwapToSsdData;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.vm.api.model.provisioning.VirtualDiskFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoragePropertyProvider
implements PropertyProviderBean {
    private static final String NAME_PROPERTY = "name";
    private static final String HOST_POWER_STATE_PROPERTY = "runtime.powerState";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String HOST_CLUSTER_NAME = "hostClusterName";
    private static final String HOST_STORAGE_PRIVILEGE = "Host.Config.Storage";
    private static final String HOST_ADVANCED_CONFIG_PRIVILEGE = "Host.Config.AdvancedConfig";
    private static final String HOST_CAPABILITY = "capability";
    private static final String HOST_VERSION_PROPERTY = "config.product.version";
    private static final String HOST_CACHE_CONFIGURATION_INFO = "hostCacheConfigurationInfo";
    private static final String DATASTORE_ACCESSIBLE_PROPERTY = "summary/accessible";
    private static final String DATASTORE_CAPACITY_PROPERTY = "summary/capacity";
    private static final String DATASTORE_FREESPACE_PROPERTY = "info/freeSpace";
    private static final String DATASTORE_TYPE_PROPERTY = "summary/type";
    private static final String DATASTORE_SSD_PROPERTY = "info/vmfs/ssd";
    private static final String DATASTORE_HOST_MOUNT_PROPERTY = "hostMount";
    private static final String DATASTORE_HOST_KEY_PROPERTY = "hostKey";
    private static final String DATASTORE_NAME_PROPERTY = "info.name";
    private static final String DATASTORE_PROVISIONED_SPACE_PROPERTY = "provisionedSpace";
    private static final String DATASTORE_THIN_PROVISIONED_SUPPORTED_PROPERTY = "thinProvisioningSupported";
    private static final String DATASTORE_MULTIPLE_HOST_ACCESS_PROPERTY = "summary/multipleHostAccess";
    private static final String DATASTORE_VSTORAGE_PROPERTY = "vStorageSupport";
    private static final String DATASTORE_VSTORAGE_SUPPORTED_PROPERTY = "vStorageSupported";
    private static final String DATASTORE_VMFS_VERSION_PROPERTY = "info/vmfs/majorVersion";
    public static final String HOST_IN_DOMAIN_PROPERTY = "inDomain";
    public static final String HOST_NFS_KERBEROS_USER_PROP = "nfsKerberosUser";
    private static final String VMFS_DS_TYPE = "VMFS";
    private static final String DATASTORE_FILE_MANAGEMENT_PRIVILEGE = "Datastore.FileManagement";
    private static final String VMFS_TYPE = "VMFS";
    private static final String VVOL_TYPE = "VVOL";
    private static final String NFS41_TYPE = "NFS41";
    private static final String NFS3_TYPE = "NFS";
    private static final String VSAN_TYPE = "vsan";
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private QueryService _queryService;
    private static final Log _logger = LogFactory.getLog(StoragePropertyProvider.class);

    public StoragePropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, QueryServiceFactory queryServiceFactory) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"Folder"}, propertyNamespace="storage", property="allDatastoresInfo")
    public List<DatastoreLocatorData> getAllDatastoresInfo(ManagedObjectReference rootFolder) throws Exception {
        List<ResourceItem> datastoreInfos = this.queryForDatastoreProperties(rootFolder);
        boolean hasHardwareAcceleration = this.hasHardwareAccelerationEnabled(datastoreInfos);
        ArrayList<DatastoreLocatorData> datastoreItems = new ArrayList<DatastoreLocatorData>();
        for (ResourceItem datastoreInfo : datastoreInfos) {
            if (!AuthorizationUtil.isPrivilegeGranted((String[])new String[]{DATASTORE_FILE_MANAGEMENT_PRIVILEGE}, (String[])((String[])datastoreInfo.get(0)))) continue;
            datastoreItems.add(this.formatDatastoreProperties(datastoreInfo, hasHardwareAcceleration));
        }
        return datastoreItems;
    }

    @ModelMetadata(type={"HostSystem", "Datacenter", "Folder", "ClusterComputeResource"}, propertyNamespace="storage", property="availableHostsForCreateDatastore")
    public HostData[] getAvailableHostsForCreateDatastore(ManagedObjectReference moRef) throws Exception {
        QuerySpec querySpec;
        String[] properties = new String[]{NAME_PROPERTY, HOST_POWER_STATE_PROPERTY, HOST_CONNECTION_STATE_PROPERTY, HOST_CLUSTER_NAME, "grantedPrivileges", HOST_CAPABILITY, HOST_VERSION_PROPERTY, HOST_IN_DOMAIN_PROPERTY, HOST_NFS_KERBEROS_USER_PROP};
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, HostSystem.class)) {
            querySpec = this._querySpecBuilder.buildQuerySpec((Object)moRef, properties);
        } else {
            Constraint hostConstraint;
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, Folder.class)) {
                Constraint dcForFolderConstraint = this._querySpecBuilder.createConstraintForRelationship((Object)moRef, "dc", Datacenter.class.getSimpleName());
                hostConstraint = this._querySpecBuilder.createRelationalConstraint("host", dcForFolderConstraint, Boolean.valueOf(true), HostSystem.class.getSimpleName());
            } else {
                hostConstraint = this._querySpecBuilder.createConstraintForRelationship((Object)moRef, "host", HostSystem.class.getSimpleName());
            }
            querySpec = this._querySpecBuilder.buildQuerySpec(hostConstraint, properties);
        }
        com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(querySpec);
        if (resultSet == null || resultSet.items == null) {
            return new HostData[0];
        }
        ArrayList<HostData> result = new ArrayList<HostData>();
        for (ResultItem item : resultSet.items) {
            Map hostProperties = QueryExecutorUtil.mapPropertyNamesToValues((PropertyValue[])item.properties);
            String[] grantedPrivileges = (String[])hostProperties.get("grantedPrivileges");
            boolean neededPrivilegeMet = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{HOST_STORAGE_PRIVILEGE}, (String[])grantedPrivileges);
            String kerberosCredentialsUser = (String)hostProperties.get(HOST_NFS_KERBEROS_USER_PROP);
            HostData hostData = HostData.newInstance((ManagedObjectReference)item.resourceObject, (String)hostProperties.get(NAME_PROPERTY), (HostSystem.ConnectionState)hostProperties.get(HOST_CONNECTION_STATE_PROPERTY), (HostSystem.PowerState)hostProperties.get(HOST_POWER_STATE_PROPERTY), (String)hostProperties.get(HOST_CLUSTER_NAME), neededPrivilegeMet, (Capability)hostProperties.get(HOST_CAPABILITY), (String)hostProperties.get(HOST_VERSION_PROPERTY), StringUtils.isNotBlank((String)kerberosCredentialsUser), (Boolean)hostProperties.get(HOST_IN_DOMAIN_PROPERTY));
            result.add(hostData);
        }
        return result.toArray(new HostData[result.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storage", property="hostSwapToSsdData")
    public HostSwapToSsdData getHostSwapToSsdData(ManagedObjectReference hostRef) throws Exception {
        HostSwapToSsdData result = new HostSwapToSsdData();
        String[] grantedPrivileges = (String[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)hostRef, (String)"grantedPrivileges");
        result.hasAdvancedConfigPrivilege = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{HOST_ADVANCED_CONFIG_PRIVILEGE}, (String[])grantedPrivileges);
        if (!result.hasAdvancedConfigPrivilege) {
            return result;
        }
        List<ResourceItem> ssdDatastores = this.getSsdDatastoresForHost(hostRef);
        CacheConfigurationManager.CacheConfigurationInfo[] cacheConfigInfo = null;
        if (!ssdDatastores.isEmpty()) {
            cacheConfigInfo = (CacheConfigurationManager.CacheConfigurationInfo[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)hostRef, (String)HOST_CACHE_CONFIGURATION_INFO);
        }
        result.ssdDatastores = StoragePropertyProvider.buildDatastoreItems(hostRef, ssdDatastores, cacheConfigInfo);
        return result;
    }

    @ModelMetadata(type={"Folder"}, propertyNamespace="storage", property="datastoresInVc")
    public List<DatastoreCopyItem> getDatastoresInVc(ManagedObjectReference rootFolder) throws Exception {
        ResultSet datastoreInfosResultSet = this._queryService.select(new String[]{DATASTORE_NAME_PROPERTY, DATASTORE_FREESPACE_PROPERTY, DATASTORE_TYPE_PROPERTY, "grantedPrivileges"}).from(new String[]{Datastore.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolder.getServerGuid()), new PropertyPredicate(DATASTORE_ACCESSIBLE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)Boolean.TRUE)}).fetch();
        List datastoreInfos = datastoreInfosResultSet.getItems();
        ArrayList<DatastoreCopyItem> datastoreCopyItems = new ArrayList<DatastoreCopyItem>();
        for (ResourceItem datastoreInfo : datastoreInfos) {
            if (!AuthorizationUtil.isPrivilegeGranted((String[])new String[]{DATASTORE_FILE_MANAGEMENT_PRIVILEGE}, (String[])((String[])datastoreInfo.get(3)))) continue;
            datastoreCopyItems.add(new DatastoreCopyItem((ManagedObjectReference)datastoreInfo.getKey(), (String)datastoreInfo.getPropertyValues().get(0), (Long)datastoreInfo.getPropertyValues().get(1), (String)datastoreInfo.getPropertyValues().get(2)));
        }
        return datastoreCopyItems;
    }

    private List<ResourceItem> getSsdDatastoresForHost(ManagedObjectReference hostRef) {
        List datastoreItems;
        ResultSet datastoresResultSet = this._queryService.select(new String[]{NAME_PROPERTY, DATASTORE_ACCESSIBLE_PROPERTY, DATASTORE_CAPACITY_PROPERTY, DATASTORE_FREESPACE_PROPERTY, DATASTORE_HOST_MOUNT_PROPERTY, DATASTORE_SSD_PROPERTY}).from(new String[]{Datastore.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(DATASTORE_TYPE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)"VMFS"), new PropertyPredicate(DATASTORE_HOST_KEY_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef)}).fetch();
        ArrayList<ResourceItem> ssdDatastores = new ArrayList<ResourceItem>();
        if (datastoresResultSet != null && (datastoreItems = datastoresResultSet.getItems()) != null) {
            for (ResourceItem resourceItem : datastoreItems) {
                if (!Boolean.TRUE.equals(resourceItem.get(DATASTORE_SSD_PROPERTY))) continue;
                ssdDatastores.add(resourceItem);
            }
        }
        return ssdDatastores;
    }

    private static HostSwapToSsdData.DatastoreItem[] buildDatastoreItems(ManagedObjectReference hostRef, List<ResourceItem> ssdDatastores, CacheConfigurationManager.CacheConfigurationInfo[] cacheConfigInfo) {
        HostSwapToSsdData.DatastoreItem[] result = new HostSwapToSsdData.DatastoreItem[ssdDatastores.size()];
        for (int i = 0; i < result.length; ++i) {
            ResourceItem dsRsItem = ssdDatastores.get(i);
            ManagedObjectReference dsRef = (ManagedObjectReference)dsRsItem.getKey();
            CacheConfigurationManager.CacheConfigurationInfo dsCacheConfigInfo = StoragePropertyProvider.getCacheConfigurationInfo(dsRef, cacheConfigInfo);
            Datastore.HostMount hostMount = StoragePropertyProvider.getHostMount(hostRef, (Datastore.HostMount[])dsRsItem.get(DATASTORE_HOST_MOUNT_PROPERTY));
            result[i] = HostSwapToSsdData.DatastoreItem.newInstance(dsRef, (String)dsRsItem.get(NAME_PROPERTY), (Long)dsRsItem.get(DATASTORE_CAPACITY_PROPERTY), (Long)dsRsItem.get(DATASTORE_FREESPACE_PROPERTY), (Boolean)dsRsItem.get(DATASTORE_ACCESSIBLE_PROPERTY), hostMount, dsCacheConfigInfo);
        }
        return result;
    }

    private static CacheConfigurationManager.CacheConfigurationInfo getCacheConfigurationInfo(ManagedObjectReference dsRef, CacheConfigurationManager.CacheConfigurationInfo[] cacheConfigInfos) {
        if (dsRef == null || cacheConfigInfos == null) {
            return null;
        }
        for (CacheConfigurationManager.CacheConfigurationInfo info : cacheConfigInfos) {
            if (!dsRef.equals((Object)info.key)) continue;
            return info;
        }
        return null;
    }

    private static Datastore.HostMount getHostMount(ManagedObjectReference hostRef, Datastore.HostMount[] hostMounts) {
        if (hostRef == null || hostMounts == null) {
            return null;
        }
        for (Datastore.HostMount hostMount : hostMounts) {
            if (!hostRef.equals((Object)hostMount.key)) continue;
            return hostMount;
        }
        return null;
    }

    private List<ResourceItem> queryForDatastoreProperties(ManagedObjectReference rootFolder) {
        return this._queryService.select(new String[]{"grantedPrivileges", DATASTORE_NAME_PROPERTY, DATASTORE_CAPACITY_PROPERTY, DATASTORE_FREESPACE_PROPERTY, DATASTORE_PROVISIONED_SPACE_PROPERTY, DATASTORE_THIN_PROVISIONED_SUPPORTED_PROPERTY, DATASTORE_MULTIPLE_HOST_ACCESS_PROPERTY, DATASTORE_VSTORAGE_PROPERTY, DATASTORE_TYPE_PROPERTY, DATASTORE_VMFS_VERSION_PROPERTY, DATASTORE_VSTORAGE_SUPPORTED_PROPERTY}).from(new String[]{Datastore.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolder.getServerGuid()), new PropertyPredicate(DATASTORE_ACCESSIBLE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)Boolean.TRUE)}).fetch().getItems();
    }

    private DatastoreLocatorData formatDatastoreProperties(ResourceItem item, boolean hasHardwareAcceleration) {
        List values = item.getPropertyValues();
        DatastoreLocatorData response = new DatastoreLocatorData((ManagedObjectReference)item.getKey());
        response.name = (String)values.get(1);
        response.capacity = (Long)values.get(2);
        response.freeSpace = (Long)values.get(3);
        response.provisionedSpace = (Long)values.get(4);
        response.thinProvisioningSupported = (Boolean)values.get(5);
        response.multipleHostAccess = (Boolean)values.get(6);
        response.hardwareAcceleration = this.getHardwareAcceleration((String)values.get(7));
        response.type = (String)values.get(8);
        response.formattedType = this.getFormattedDatastoreType(response.type, values.get(9));
        response.vStorageSupported = (Boolean)values.get(10);
        response.diskFormatsAvailable = this.getSupportedFormats(response.type, hasHardwareAcceleration);
        return response;
    }

    private String getHardwareAcceleration(String vStorageSupport) {
        boolean hasUnknown = false;
        boolean hasUnsupported = false;
        if (!FileSystemMountInfo.VStorageSupportStatus.vStorageSupported.toString().equals(vStorageSupport)) {
            if (FileSystemMountInfo.VStorageSupportStatus.vStorageUnsupported.toString().equals(vStorageSupport)) {
                hasUnsupported = true;
            } else {
                hasUnknown = true;
            }
        }
        if (hasUnknown) {
            return StorageStringUtil.getString("vStorage.vStorageUnknown");
        }
        if (hasUnsupported) {
            return StorageStringUtil.getString("vStorage.vStorageUnsupported");
        }
        return StorageStringUtil.getString("vStorage.vStorageSupported");
    }

    private String getFormattedDatastoreType(String dsType, Object vmfsMajorVersion) {
        if ("VMFS".equalsIgnoreCase(dsType)) {
            if (vmfsMajorVersion != null) {
                return StorageStringUtil.getString("vmfsDatastore.version.format", vmfsMajorVersion.toString());
            }
            return StorageStringUtil.getString("dsType.vmfs");
        }
        if (NFS3_TYPE.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.nfs3");
        }
        if (NFS41_TYPE.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.nfs41");
        }
        if (VSAN_TYPE.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.vsan");
        }
        if (VVOL_TYPE.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.vvol");
        }
        return dsType;
    }

    private List<VirtualDiskFormat> getSupportedFormats(String dsType, boolean hasHardwareAcceleration) {
        ArrayList<VirtualDiskFormat> result = new ArrayList<VirtualDiskFormat>();
        if (VVOL_TYPE.equals(dsType)) {
            result.add(VirtualDiskFormat.thin);
            result.add(VirtualDiskFormat.nativeThick);
            return result;
        }
        if (VSAN_TYPE.equals(dsType)) {
            result.add(VirtualDiskFormat.asDefinedInProfile);
            return result;
        }
        if ((NFS3_TYPE.equalsIgnoreCase(dsType) || NFS41_TYPE.equalsIgnoreCase(dsType)) && !hasHardwareAcceleration) {
            result.add(VirtualDiskFormat.thin);
            return result;
        }
        result.add(VirtualDiskFormat.sameAsSource);
        result.add(VirtualDiskFormat.flat);
        result.add(VirtualDiskFormat.thick);
        result.add(VirtualDiskFormat.thin);
        return result;
    }

    private boolean hasHardwareAccelerationEnabled(List<ResourceItem> datastoreInfos) {
        if (datastoreInfos == null || datastoreInfos.isEmpty()) {
            return false;
        }
        for (ResourceItem datastoreInfo : datastoreInfos) {
            if (FileSystemMountInfo.VStorageSupportStatus.vStorageSupported.toString().equals(datastoreInfo.getPropertyValues().get(7))) continue;
            return false;
        }
        return true;
    }
}

